/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.svek.RoundedNorth;
import net.sourceforge.plantuml.svek.RoundedSouth;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public final class RoundedContainer {
    private final Dimension2D dim;
    private final double titleHeight;
    private final double attributeHeight;
    private final HColor borderColor;
    private final HColor backColor;
    private final HColor imgBackcolor;
    private final UStroke stroke;
    private final double rounded;
    private final double shadowing;

    public RoundedContainer(Dimension2D dim, double titleHeight, double attributeHeight, HColor borderColor, HColor backColor, HColor imgBackcolor, UStroke stroke, double rounded, double shadowing) {
        if (dim.getWidth() == 0.0) {
            throw new IllegalArgumentException();
        }
        this.rounded = rounded;
        this.dim = dim;
        this.imgBackcolor = imgBackcolor;
        this.titleHeight = titleHeight;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.attributeHeight = attributeHeight;
        this.stroke = stroke;
        this.shadowing = shadowing;
    }

    public void drawU(UGraphic ug) {
        ug = ug.apply(this.backColor.bg()).apply(this.borderColor).apply(this.stroke);
        URectangle rect = new URectangle(this.dim.getWidth(), this.dim.getHeight()).rounded(this.rounded);
        if (this.shadowing > 0.0) {
            rect.setDeltaShadow(this.shadowing);
            ug.apply(HColorUtils.transparent().bg()).draw(rect);
            rect.setDeltaShadow(0.0);
        }
        double headerHeight = this.titleHeight + this.attributeHeight;
        new RoundedNorth(this.dim.getWidth(), headerHeight, this.backColor, this.rounded).drawU(ug);
        new RoundedSouth(this.dim.getWidth(), this.dim.getHeight() - headerHeight, this.imgBackcolor, this.rounded).drawU(ug.apply(UTranslate.dy(headerHeight)));
        ug.apply(HColorUtils.transparent().bg()).draw(rect);
        if (headerHeight > 0.0) {
            ug.apply(UTranslate.dy(headerHeight)).draw(ULine.hline(this.dim.getWidth()));
        }
        if (this.attributeHeight > 0.0) {
            ug.apply(UTranslate.dy(this.titleHeight)).draw(ULine.hline(this.dim.getWidth()));
        }
    }
}

