# Checklist: Metacat K8s 3.0.0 to 3.1.0 Upgrade Steps

> **= = = THIS IS A TEMPLATE - MAKE YOUR OWN COPY BEFORE CHECKING BOXES! = = =**

> ## IMPORTANT NOTES - before you begin...
> 1. **PURPOSE:** This ordered checklist is for upgrading an existing K8s Metacat v3.0.0 instance to
>    Metacat v3.1.0
>    * ***Very Important: Before starting a migration, you **must** have a fully-functioning
>      k8s installation of Metacat version 3.0.0/helm chart 1.1.x. Upgrade from other versions is
>      not supported. It is also assumed that your installation has already been fully indexed***
> 2. Some references below are specific to NCEAS infrastructure (e.g. CephFS storage); adjust as
>    needed for your own installation.
> 3. Assumptions: you have a working knowledge of Kubernetes deployment, including working with yaml
>    files, helm and kubectl commands, and your kubectl context is set for the target deployment
>    location

## 1. Values: Edit your existing values override file

**e.g. see the
[values-dev-cluster-example.yaml](../examples/values-dev-cluster-example.yaml)
file.**

- [ ] Remove any uid or gid overrides, since we're now adopting the defaults of 59996 for postgres
      and 59997 for metacat
- [ ] Temporarily disable probes until hashstore conversion is done


## 2. Prep Before Upgrading

- [ ] set `storage.hashstore.disableConversion: true`, so the hashstore converter won't run yet
- [ ] In the metacat database, verify that all the `systemmetadata.checksum_algorithm` entries are
  on the [list of supported
  algorithms](https://github.com/DataONEorg/hashstore-java/blob/main/src/main/java/org/dataone/hashstore/filehashstore/FileHashStore.java#L63)
  (NOTE: syntax matters! E.g. `sha-1` is OK, but `sha1` isn't):
    ```shell
    kubectl exec ${RELEASE_NAME}-postgresql-0 -- bash -c "psql -U metacat << EOF
      SELECT DISTINCT checksum_algorithm FROM systemmetadata WHERE checksum_algorithm NOT IN
            ('MD2','MD5','SHA-1','SHA-256','SHA-384','SHA-512','SHA-512/224','SHA-512/256');
    EOF"

    # then manually update each to the correct syntax; e.g:
    kubectl exec ${RELEASE_NAME}-postgresql-0 -- bash -c "psql -U metacat << EOF
      UPDATE systemmetadata SET checksum_algorithm='SHA-1' WHERE checksum_algorithm='SHA1';
    EOF"
    # ...etc
    ```

## 3. Upgrading - NOTE THERE WILL BE DOWNTIME!

### = = = = = = = = Downtime starts here = = = = = = = =

- [ ] Change ownership **ON CEPHFS** as follows:

    ```shell
    ## postgres (59996:59996) in postgresql data directory
    sudo chown -R 59996:59996 /mnt/ceph/repos/REPO-NAME/postgresql

    ## tomcat (59997:59997) in metacat directory
    sudo chown -R 59997:59997 data dataone documents logs
    ```

- [ ] ...then ensure all metacat `data` and `documents` files have `g+rw` permissions, otherwise,
  hashstore converter can't create hard links:

    ```shell
    sudo chmod -R g+rw data documents dataone
    ```

- [ ] `helm upgrade`, debug any startup and configuration issues
- [ ] Delete or comment out the `storage.hashstore.disableConversion:` setting, so the hashstore
    converter will run, and `helm upgrade` again. Allow hashstore upgrade to finish. (production
    machines took approx 0.16 seconds per object, but will likely be longer on dev cluster)

  > **NOTE:** while hashstore conversion is still in progress, it is expected for metacatUI to
  > display `Oops! It looks like there was a problem retrieving your search results.`, and for
  > `/metacat/d1/mn/v2/` api calls to display `Metacat has not been configured`

  > See [this tip](./Installation-Notes.md#monitor-hashstore-conversion-progress-and-completion) for
  > how to detect when hashstore conversion finishes

### = = = = = = = = Downtime ends here = = = = = = = =

- [ ] When hashstore conversion has finished, re-enable probes and helm upgrade to apply changes
