#!/bin/bash

echo "Creating bucket..."
curl -i -X POST -H 'Content-Type: application/json' -d '{"action": "create_bck"}' http://172.50.0.2:8080/v1/buckets/imagenet

echo "Downloading IMAGENET images into AIS cluster..."
curl -v -H 'Content-Type: application/json' -d '{
    "bucket": "imagenet",
    "object_map": {
        "n00004475_6590": "http://farm4.static.flickr.com/3175/2737866473_7958dc8760.jpg",
        "n00004475_15899": "http://farm4.static.flickr.com/3276/2875184020_9944005d0d.jpg",
        "n00004475_32312": "http://farm3.static.flickr.com/2531/4094333885_e8462a8338.jpg",
        "n00004475_35466": "http://farm4.static.flickr.com/3289/2809605169_8efe2b8f27.jpg",
        "n00004475_42770": "http://farm4.static.flickr.com/3488/4051378654_238ca94313.jpg",
        "n00004475_54295": "http://farm4.static.flickr.com/3368/3198142470_6eb0be5f32.jpg",
        "n00005787_71": "http://farm3.static.flickr.com/2278/2300491905_5272f77e56.jpg",
        "n00005787_97": "http://farm1.static.flickr.com/45/139488995_bd06578562.jpg",
        "n00005787_105": "http://farm3.static.flickr.com/2285/2658605078_f409b25597.jpg",
        "n00005787_119": "http://farm4.static.flickr.com/3202/2960028736_74d31b947d.jpg",
        "n00005787_154": "http://farm3.static.flickr.com/2506/3724084193_802ea38fc5.jpg",
        "n00005787_155": "http://farm4.static.flickr.com/3349/3225698594_b244616b3e.jpg",
        "n00005787_157": "http://farm3.static.flickr.com/2609/4113927276_33111a2398.jpg",
        "n00005787_175": "http://farm3.static.flickr.com/2179/2090355369_4c8a60f899.jpg",
        "n00005787_185": "http://farm4.static.flickr.com/3205/2815917575_c2ea596ed2.jpg",
        "n00005787_186": "http://farm3.static.flickr.com/2084/2517885309_6680a79ab1.jpg",
        "n00005787_190": "http://farm1.static.flickr.com/81/245539781_42028c8c67.jpg",
        "n00005787_198": "http://farm2.static.flickr.com/1437/680424989_da45c42286.jpg",
        "n00005787_219": "http://farm1.static.flickr.com/176/441681804_fec8ae4c58.jpg",
        "n00005787_236": "http://farm4.static.flickr.com/3195/2791862453_30361003e8.jpg",
        "n00005787_239": "http://farm1.static.flickr.com/122/280428632_b470292274.jpg",
        "n00005787_260": "http://farm1.static.flickr.com/93/245535486_859e96114b.jpg",
        "n00005787_271": "http://farm4.static.flickr.com/3075/3240794796_0736730011.jpg",
        "n00005787_295": "http://farm4.static.flickr.com/3135/4554007604_b4e938fd6a.jpg",
        "n00005787_305": "http://farm5.static.flickr.com/4045/4532975673_18b6ea51af.jpg",
        "n00005787_337": "http://farm3.static.flickr.com/2020/2520208974_912d3df80a.jpg",
        "n00005787_377": "http://farm3.static.flickr.com/2091/2483056850_fe000af0cc.jpg",
        "n00005787_418": "http://farm6.static.flickr.com/5097/5567950598_a2acefafd1.jpg",
        "n00005787_422": "http://farm3.static.flickr.com/2112/2470829249_01ae72ac9f.jpg",
        "n00005787_471": "http://farm5.static.flickr.com/4044/4533625584_4e42d9069c.jpg",
        "n00005787_486": "http://farm3.static.flickr.com/2069/2090352761_1d8f07e3e2.jpg",
        "n00005787_499": "http://farm4.static.flickr.com/3284/3121357454_9f1d1cc1c2.jpg",
        "n00005787_522": "http://farm4.static.flickr.com/3198/2658048498_feda3bd608.jpg",
        "n00005787_525": "http://farm3.static.flickr.com/2333/2442792928_0b4bdb19c2.jpg",
        "n00005787_527": "http://farm5.static.flickr.com/4152/5003583202_0b0c30ff59.jpg",
        "n00005787_532": "http://farm3.static.flickr.com/2418/2314621800_5a65699c8d.jpg",
        "n00005787_539": "http://farm3.static.flickr.com/2742/4532985921_ace1833dfc.jpg",
        "n00005787_543": "http://farm4.static.flickr.com/3422/3240792432_cde5200dd7.jpg",
        "n00005787_566": "http://farm2.static.flickr.com/1367/1073564411_4afd8bf7d6.jpg",
        "n00005787_572": "http://farm1.static.flickr.com/109/280429698_13fd49bbd1.jpg",
        "n00005787_575": "http://farm4.static.flickr.com/3657/3399838107_683ca1f605.jpg",
        "n00005787_583": "http://farm5.static.flickr.com/4010/4544847838_e53dd1634a.jpg",
        "n00005787_592": "http://farm4.static.flickr.com/3234/2660161738_39182bd6db.jpg",
        "n00005787_604": "http://farm4.static.flickr.com/3460/3225669186_db09b7f6ae.jpg",
        "n00005787_613": "http://farm4.static.flickr.com/3173/2654947893_ee66eb9c23.jpg",
        "n00005787_618": "http://farm3.static.flickr.com/2005/2518702502_8c2d137b8e.jpg",
        "n00005787_638": "http://farm1.static.flickr.com/87/280429814_d2b5216d99.jpg",
        "n00005787_645": "http://farm3.static.flickr.com/2733/4445553075_40fb9f1bfa.jpg",
        "n00005787_654": "http://farm3.static.flickr.com/2007/2482244679_4895316f61.jpg",
        "n00005787_669": "http://farm4.static.flickr.com/3243/3121081538_f72d4a7285.jpg",
        "n00005787_797": "http://farm4.static.flickr.com/3090/2482245675_c3d95d48a8.jpg",
        "n00005787_854": "http://farm3.static.flickr.com/2801/4533615328_d8a86ff4b2.jpg",
        "n00005787_859": "http://farm5.static.flickr.com/4041/4631905842_562534d4ac.jpg",
        "n00005787_874": "http://farm4.static.flickr.com/3266/3120464469_5275bd0b71.jpg",
        "n00005787_882": "http://farm6.static.flickr.com/5211/5486003502_bc49ca4967.jpg",
        "n00005787_888": "http://farm4.static.flickr.com/3083/3120435013_bede37f0ed.jpg",
        "n00005787_928": "http://farm1.static.flickr.com/86/259110846_96370bfc90.jpg",
        "n00005787_929": "http://static.flickr.com/2428/4076029220_2991c217ee_z.jpg",
        "n00005787_932": "http://farm4.static.flickr.com/3163/2792718080_cf54072a01.jpg",
        "n00005787_976": "http://farm4.static.flickr.com/3116/3120358173_a781be6cc4.jpg",
        "n00005787_978": "http://farm5.static.flickr.com/4049/4649266953_d151088c46.jpg",
        "n00005787_1003": "http://farm3.static.flickr.com/2694/4113161725_d0dcb4001a.jpg",
        "n00005787_1030": "http://farm2.static.flickr.com/1007/1133455268_7832c9437a.jpg",
        "n00005787_1035": "http://farm2.static.flickr.com/1260/1303240761_c74023816e.jpg",
        "n00005787_1104": "http://farm4.static.flickr.com/3126/3240790520_656116c780.jpg",
        "n00005787_1113": "http://farm3.static.flickr.com/2698/4533605284_f0c4e66ae6.jpg",
        "n00005787_1140": "http://farm4.static.flickr.com/3175/2635432268_c02d7ee06e.jpg",
        "n00005787_1147": "http://farm5.static.flickr.com/4023/4649244617_773fdeb966.jpg",
        "n00005787_1154": "http://farm4.static.flickr.com/3120/3121353902_a1e63236fc.jpg",
        "n00005787_1219": "http://farm4.static.flickr.com/3516/3850669108_0deec812e2.jpg",
        "n00005787_1236": "http://farm3.static.flickr.com/2424/4004645127_2ecd20592c.jpg",
        "n00005787_1270": "http://farm1.static.flickr.com/25/91298685_7d5e61e425.jpg",
        "n00005787_1316": "http://farm4.static.flickr.com/3114/2654896783_93bfe5fcbb.jpg",
        "n00005787_1415": "http://farm4.static.flickr.com/3253/3120369425_50f5a3c15d.jpg",
        "n00005787_1441": "http://farm1.static.flickr.com/79/259117078_cde4bdfc64.jpg",
        "n00005787_1452": "http://farm6.static.flickr.com/5220/5485409855_ddff4c8f04.jpg",
        "n00005787_1457": "http://farm4.static.flickr.com/3194/2634608761_aeb4840fd3.jpg",
        "n00005787_1476": "http://farm1.static.flickr.com/88/206094483_019e359e9a.jpg",
        "n00005787_1492": "http://farm4.static.flickr.com/3641/3399839767_9fa4ce0dd3.jpg",
        "n00005787_1518": "http://farm5.static.flickr.com/4060/4532985075_7386d9b7c3.jpg",
        "n00005787_1557": "http://farm4.static.flickr.com/3143/2960029798_4958a9f129.jpg",
        "n00005787_1637": "http://farm1.static.flickr.com/61/229908522_38c0307231.jpg",
        "n00005787_1723": "http://farm5.static.flickr.com/4101/4937895098_03c55098b6.jpg",
        "n00005787_1724": "http://farm6.static.flickr.com/5168/5210202599_372be30600.jpg",
        "n00005787_1727": "http://farm3.static.flickr.com/2262/2205266879_2e099166d5.jpg",
        "n00005787_1744": "http://farm4.static.flickr.com/3486/3971889358_c93ff83098.jpg",
        "n00005787_1747": "http://farm5.static.flickr.com/4050/4253675378_17b5beb407.jpg",
        "n00005787_1784": "http://farm4.static.flickr.com/3010/2679738404_da6d2b62bb.jpg",
        "n00005787_1787": "http://farm1.static.flickr.com/94/259111784_3c8f3c28dc.jpg",
        "n00005787_1805": "http://farm1.static.flickr.com/19/23449549_b722205146.jpg",
        "n00005787_1865": "http://farm3.static.flickr.com/2062/2090355885_f705e292da.jpg",
        "n00005787_1917": "http://farm4.static.flickr.com/3101/2635432342_7c691c86d7.jpg",
        "n00005787_2004": "http://farm4.static.flickr.com/3493/4004685369_2cf347308d.jpg",
        "n00005787_2084": "http://farm4.static.flickr.com/3293/2792717058_049bc1c25d.jpg",
        "n00005787_2088": "http://farm5.static.flickr.com/4032/4252905373_7040abff33.jpg",
        "n00005787_2118": "http://farm4.static.flickr.com/3058/2655777224_11a63d0ec0.jpg",
        "n00005787_2128": "http://farm3.static.flickr.com/2275/2065746181_b831609335.jpg",
        "n00005787_2150": "http://farm1.static.flickr.com/94/280428584_1c866c3d5e.jpg",
        "n00005787_2155": "http://farm5.static.flickr.com/4136/4816913245_4b4931f457.jpg",
        "n00005787_2156": "http://farm1.static.flickr.com/86/280428728_fe1b63192e.jpg",
        "n00005787_2168": "http://farm3.static.flickr.com/2679/4152227524_ded57a9e08.jpg",
        "n00005787_2213": "http://farm4.static.flickr.com/3189/2643229370_301a4775da.jpg",
        "n00005787_2225": "http://farm6.static.flickr.com/5058/5392888815_28950c7ac5.jpg",
        "n00005787_2236": "http://farm1.static.flickr.com/172/441685255_6018bb4a5e.jpg",
        "n00005787_2237": "http://farm4.static.flickr.com/3109/3225665412_4c4d54e10e.jpg",
        "n00005787_2261": "http://farm6.static.flickr.com/5297/5486077860_53eb2f3cab.jpg",
        "n00005787_2293": "http://farm5.static.flickr.com/4024/4532987525_fc06588a18.jpg",
        "n00005787_2300": "http://farm5.static.flickr.com/4010/4262409488_fd2421f194.jpg",
        "n00005787_2306": "http://farm1.static.flickr.com/59/206094485_dc288e4239.jpg",
        "n00005787_2310": "http://farm4.static.flickr.com/3293/2482244825_8e2bf6203f.jpg",
        "n00005787_2341": "http://farm6.static.flickr.com/5292/5392594111_5e886e2e61.jpg",
        "n00005787_2353": "http://farm6.static.flickr.com/5189/5567953564_fe5cd7e022.jpg",
        "n00005787_2404": "http://farm1.static.flickr.com/87/259115947_5f128f0a90.jpg",
        "n00005787_2476": "http://farm3.static.flickr.com/2306/1888041212_1f9ff84b69.jpg",
        "n00005787_2478": "http://farm4.static.flickr.com/3083/3224816965_3df3e3b23b.jpg",
        "n00005787_2523": "http://farm4.static.flickr.com/3015/2842514808_9062f3c24f.jpg",
        "n00005787_2534": "http://farm4.static.flickr.com/3139/2795507731_c31e5984bc.jpg",
        "n00005787_2587": "http://farm4.static.flickr.com/3404/3421030522_8924cd4347.jpg",
        "n00005787_2613": "http://farm5.static.flickr.com/4014/4631907766_8782ff40ac.jpg",
        "n00005787_2623": "http://farm4.static.flickr.com/3052/2483060656_3299d82a8d.jpg",
        "n00005787_2627": "http://farm3.static.flickr.com/2495/4151466489_0c8a00caa7.jpg",
        "n00005787_2638": "http://farm4.static.flickr.com/3021/2643601114_20e93bacaf.jpg",
        "n00005787_2645": "http://farm4.static.flickr.com/3287/2710767188_43d96ba8e6.jpg",
        "n00005787_2659": "http://farm4.static.flickr.com/3290/2657219695_595637484a.jpg",
        "n00005787_2686": "http://farm4.static.flickr.com/3227/3121190404_6895d01da1.jpg",
        "n00005787_2780": "http://farm3.static.flickr.com/2187/2388772305_70bdba8c35.jpg",
        "n00005787_2795": "http://farm1.static.flickr.com/113/280428385_cb56882ed9.jpg",
        "n00005787_2847": "http://farm4.static.flickr.com/3291/3121281306_6be7841c9e.jpg",
        "n00005787_2853": "http://farm4.static.flickr.com/3445/3822160804_4fd0875828.jpg",
        "n00005787_2867": "http://farm4.static.flickr.com/3089/3120549221_97d8421f73.jpg",
        "n00005787_2873": "http://farm4.static.flickr.com/3660/3404728860_6eb097e322.jpg",
        "n00005787_2883": "http://farm1.static.flickr.com/110/280429781_2952bba97c.jpg",
        "n00005787_2894": "http://farm5.static.flickr.com/4112/4950853768_eefcd26c8e.jpg",
        "n00005787_2896": "http://farm6.static.flickr.com/5171/5393193260_12a7d39ff5.jpg",
        "n00005787_2913": "http://farm5.static.flickr.com/4128/5005354400_75d5856d26.jpg",
        "n00005787_2941": "http://farm1.static.flickr.com/94/280429309_38d23ca791.jpg",
        "n00005787_2960": "http://farm5.static.flickr.com/4028/4659756056_78ea33bf3c.jpg",
        "n00005787_2973": "http://farm6.static.flickr.com/5059/5393183776_c184f18b81.jpg",
        "n00005787_3038": "http://farm4.static.flickr.com/3198/3036266757_a4b5bc17ba.jpg",
        "n00005787_3050": "http://farm3.static.flickr.com/2158/2090355167_b7558af13f.jpg",
        "n00005787_3169": "http://farm6.static.flickr.com/5019/5392652543_fc16d226ae.jpg",
        "n00005787_3185": "http://farm4.static.flickr.com/3294/2660117380_72db30c71d.jpg",
        "n00005787_3205": "http://farm3.static.flickr.com/2382/2093704732_325c8103fc.jpg",
        "n00005787_3241": "http://farm3.static.flickr.com/2233/1831081692_e73e0915ba.jpg",
        "n00005787_3246": "http://farm1.static.flickr.com/91/280428686_d8d5bd3299.jpg",
        "n00005787_3310": "http://farm4.static.flickr.com/3379/3225697508_b9645e8f47.jpg",
        "n00005787_3341": "http://farm1.static.flickr.com/14/15153915_a978f73493.jpg",
        "n00005787_3366": "http://farm6.static.flickr.com/5017/5464519386_08696c749b.jpg",
        "n00005787_3446": "http://farm4.static.flickr.com/3022/2655866512_4e9c146e52.jpg",
        "n00005787_3466": "http://farm4.static.flickr.com/3087/3120324281_662e835b79.jpg",
        "n00005787_3481": "http://farm2.static.flickr.com/1255/1341458110_c973192db8.jpg",
        "n00005787_3484": "http://farm5.static.flickr.com/4132/5029538537_f06f233e65.jpg",
        "n00005787_3498": "http://farm4.static.flickr.com/3143/2483058484_d296636479.jpg",
        "n00005787_3558": "http://farm4.static.flickr.com/3187/2657745533_b0fbc12ce5.jpg",
        "n00005787_3588": "http://farm4.static.flickr.com/3407/3224808737_61680f620a.jpg",
        "n00005787_3592": "http://farm6.static.flickr.com/5011/5392893361_c63b9767f2.jpg",
        "n00005787_3599": "http://farm4.static.flickr.com/3237/2659287155_ca6a67c2b1.jpg",
        "n00005787_3662": "http://farm5.static.flickr.com/4084/5030164898_51e39c9641.jpg",
        "n00005787_3677": "http://farm1.static.flickr.com/80/259111445_21f665cb43.jpg",
        "n00005787_3688": "http://farm6.static.flickr.com/5300/5392591101_a9709cbae6.jpg",
        "n00005787_3696": "http://farm4.static.flickr.com/3262/3120373033_902e7c0060.jpg",
        "n00005787_3738": "http://farm1.static.flickr.com/118/280430053_e6182c8a8b.jpg",
        "n00005787_3743": "http://farm1.static.flickr.com/104/259208655_310533d2b1.jpg",
        "n00005787_3750": "http://farm4.static.flickr.com/3309/3225693992_54e549ef90.jpg",
        "n00005787_3756": "http://farm4.static.flickr.com/3262/3224832889_5feb3f89db.jpg",
        "n00005787_3823": "http://farm4.static.flickr.com/3425/3842580295_a6770485a2.jpg",
        "n00005787_3852": "http://farm6.static.flickr.com/5259/5393190156_f9436e274f.jpg",
        "n00005787_3864": "http://farm1.static.flickr.com/82/205688197_e7406d8d3d.jpg",
        "n00005787_3885": "http://farm4.static.flickr.com/3161/2482246165_7ee20052f5.jpg",
        "n00005787_3912": "http://farm3.static.flickr.com/2587/4113161535_e02d69c6a9.jpg",
        "n00005787_3915": "http://farm5.static.flickr.com/4069/4544393353_cc4c7f2d43.jpg",
        "n00005787_3943": "http://farm4.static.flickr.com/3232/3120354277_d4e83855b4.jpg",
        "n00005787_3968": "http://farm4.static.flickr.com/3366/3224818083_18a6aa65f4.jpg",
        "n00005787_3991": "http://farm1.static.flickr.com/112/280430223_543affee9a.jpg",
        "n00005787_3992": "http://farm6.static.flickr.com/5014/5567960390_5c871cc284.jpg",
        "n00005787_4002": "http://farm4.static.flickr.com/3257/2317265507_252abdc787.jpg",
        "n00005787_4012": "http://farm4.static.flickr.com/3568/3444682216_d17cefecfe.jpg",
        "n00005787_4077": "http://farm6.static.flickr.com/5258/5393487388_ebc3029baf.jpg",
        "n00005787_4101": "http://farm6.static.flickr.com/5100/5486302528_64cd817d95.jpg",
        "n00005787_4163": "http://farm4.static.flickr.com/3619/4554006312_94f0096be4.jpg",
        "n00005787_4205": "http://farm5.static.flickr.com/4051/4252905065_0fb6e5421a.jpg",
        "n00005787_4238": "http://farm4.static.flickr.com/3505/3224843509_66fdb8e3c8.jpg",
        "n00005787_4264": "http://farm3.static.flickr.com/2593/4005478586_3bd3b4c8f5.jpg",
        "n00005787_4297": "http://farm1.static.flickr.com/13/15084867_b50ae7752e.jpg",
        "n00005787_4316": "http://farm4.static.flickr.com/3241/3120300321_2e54b8ce8a.jpg",
        "n00005787_4319": "http://farm4.static.flickr.com/3127/4554006686_253ca753eb.jpg",
        "n00005787_4328": "http://farm6.static.flickr.com/5293/5486085214_95a75b7a38.jpg",
        "n00005787_4337": "http://farm1.static.flickr.com/82/280428676_98fa7e6849.jpg",
        "n00005787_4349": "http://farm6.static.flickr.com/5258/5567962934_bb3e2acf45.jpg",
        "n00005787_4398": "http://farm6.static.flickr.com/5213/5486083214_455493717b.jpg",
        "n00005787_4438": "http://farm4.static.flickr.com/3294/3120488719_37f509a0d0.jpg",
        "n00005787_4439": "http://farm1.static.flickr.com/88/230030008_ad801fc323.jpg",
        "n00005787_4453": "http://farm1.static.flickr.com/84/280429875_aeb359a00b.jpg",
        "n00005787_4454": "http://farm2.static.flickr.com/1367/1125531218_eab0dfb4c2.jpg",
        "n00005787_4464": "http://farm4.static.flickr.com/3484/3949328057_e3c6e1d59c.jpg",
        "n00005787_4468": "http://farm2.static.flickr.com/1230/1133499212_49c738d96d.jpg",
        "n00005787_4470": "http://farm1.static.flickr.com/185/493078638_2d26f4371e.jpg",
        "n00005787_4495": "http://farm1.static.flickr.com/40/97434294_32a782a1a9.jpg",
        "n00005787_4496": "http://farm4.static.flickr.com/3085/3121308948_6c27d1fa3b.jpg",
        "n00005787_4535": "http://farm3.static.flickr.com/2104/2091139064_e7e98971d4.jpg",
        "n00005787_4555": "http://farm6.static.flickr.com/5269/5567368305_a53d7a7fe0.jpg",
        "n00005787_4556": "http://farm5.static.flickr.com/4131/5002966839_f5f49ac4d4.jpg",
        "n00005787_4569": "http://farm3.static.flickr.com/2237/2310121238_70da15f1c9.jpg",
        "n00005787_4610": "http://farm1.static.flickr.com/83/259116214_2c645815ea.jpg",
        "n00005787_4633": "http://farm4.static.flickr.com/3472/3225628066_6ea5b14c77.jpg",
        "n00005787_4674": "http://farm4.static.flickr.com/3512/3224765823_82f5a247f8.jpg",
        "n00005787_4681": "http://farm6.static.flickr.com/5083/5242791430_8483351068.jpg",
        "n00005787_4682": "http://farm2.static.flickr.com/1314/1133496212_c164f29261.jpg",
        "n00005787_4727": "http://farm4.static.flickr.com/3211/2959189053_1c395a0069.jpg",
        "n00005787_4743": "http://farm2.static.flickr.com/1150/5132331342_f12ca6ba1e.jpg",
        "n00005787_4804": "http://farm5.static.flickr.com/4152/5030156220_fd5f69ff18.jpg",
        "n00005787_4811": "http://farm1.static.flickr.com/87/245539203_286b3eb02f.jpg",
        "n00005787_4823": "http://farm4.static.flickr.com/3449/3225622592_cb13d908d0.jpg",
        "n00005787_4854": "http://farm3.static.flickr.com/2525/4113158069_e1d4b0d7da.jpg",
        "n00005787_4861": "http://farm6.static.flickr.com/5254/5485493451_1cfb51d6b8.jpg",
        "n00005787_4912": "http://farm5.static.flickr.com/4034/4544390217_ce3507086f.jpg",
        "n00005787_4980": "http://farm2.static.flickr.com/1101/910968436_8c6fdf8da3.jpg",
        "n00005787_5004": "http://farm1.static.flickr.com/96/245543813_2d55bea890.jpg",
        "n00005787_5048": "http://farm4.static.flickr.com/3188/2483058234_101e383644.jpg",
        "n00005787_5060": "http://farm5.static.flickr.com/4090/5029569199_1f3817cd3b.jpg",
        "n00005787_5070": "http://farm3.static.flickr.com/2688/4252898171_a3c210aacf.jpg",
        "n00005787_5077": "http://farm6.static.flickr.com/5058/5392588657_5ebed4d588.jpg",
        "n00005787_5098": "http://farm4.static.flickr.com/3234/2801956579_37b0e4a9fd.jpg",
        "n00005787_5134": "http://farm4.static.flickr.com/3264/2709954791_bbf42738ea.jpg",
        "n00005787_5142": "http://farm4.static.flickr.com/3126/2483061846_9091be69b2.jpg",
        "n00005787_5166": "http://farm3.static.flickr.com/2765/4413231622_b95d17c37f.jpg",
        "n00005787_5197": "http://farm4.static.flickr.com/3358/3225705886_bb86488f56.jpg",
        "n00005787_5255": "http://farm4.static.flickr.com/3341/3225706944_c89ac50df1.jpg",
        "n00005787_5304": "http://farm4.static.flickr.com/3385/3225672162_d82d8c1257.jpg",
        "n00005787_5307": "http://farm4.static.flickr.com/3386/3444696374_e719c1d60d.jpg",
        "n00005787_5424": "http://farm5.static.flickr.com/4031/4421909607_23de795bdd.jpg",
        "n00005787_5562": "http://farm5.static.flickr.com/4002/4631307973_1bdee15ed8.jpg",
        "n00005787_5674": "http://farm2.static.flickr.com/1166/3173507827_455a8dbd9f.jpg",
        "n00005787_5707": "http://farm4.static.flickr.com/3195/2519385137_dec37fb4b9.jpg",
        "n00005787_5712": "http://farm4.static.flickr.com/3565/3479750274_833ec14c2a.jpg",
        "n00005787_5753": "http://farm4.static.flickr.com/3383/3598209186_9c3b217bb2.jpg",
        "n00005787_5768": "http://farm3.static.flickr.com/2670/4151468941_cc9d572171.jpg",
        "n00005787_5772": "http://farm1.static.flickr.com/97/245541532_a8c1d1f0c2.jpg",
        "n00005787_5819": "http://farm4.static.flickr.com/3284/3043657244_16ab1dde52.jpg",
        "n00005787_5830": "http://farm4.static.flickr.com/3305/3225695556_b447f14686.jpg",
        "n00005787_5834": "http://farm5.static.flickr.com/4013/4252906775_01f101b997.jpg",
        "n00005787_5835": "http://farm1.static.flickr.com/85/280429686_1880b438cd.jpg",
        "n00005787_5851": "http://farm4.static.flickr.com/3571/3459989462_4bf4f9667c.jpg",
        "n00005787_5865": "http://farm4.static.flickr.com/3077/2639975222_82f92db622.jpg",
        "n00005787_5877": "http://farm4.static.flickr.com/3132/3121073834_4ecb809594.jpg",
        "n00005787_5889": "http://farm1.static.flickr.com/73/230030053_2e953a63c9.jpg",
        "n00005787_5895": "http://farm5.static.flickr.com/4026/4631906874_91825bebe1.jpg",
        "n00005787_5957": "http://farm5.static.flickr.com/4096/4951032822_7cbc616b95.jpg",
        "n00005787_6034": "http://farm4.static.flickr.com/3537/3443866845_335eb90053.jpg",
        "n00005787_6052": "http://farm3.static.flickr.com/2653/4005462440_ff9b92aa31.jpg",
        "n00005787_6123": "http://farm4.static.flickr.com/3083/2564783198_ef03839758.jpg",
        "n00005787_6130": "http://farm2.static.flickr.com/1218/1341230003_9473ec77f2.jpg",
        "n00005787_6133": "http://farm5.static.flickr.com/4062/4611549990_c014113093.jpg",
        "n00005787_6149": "http://farm6.static.flickr.com/5242/5350999657_464bc9ecd6.jpg",
        "n00005787_6229": "http://farm3.static.flickr.com/2535/4075303703_700d41dc17.jpg",
        "n00005787_6238": "http://farm5.static.flickr.com/4020/4631906498_29e4508691.jpg",
        "n00005787_6274": "http://farm6.static.flickr.com/5300/5392656695_38d35da963.jpg",
        "n00005787_6309": "http://farm4.static.flickr.com/3130/3120272435_c0795d5ce9.jpg",
        "n00005787_6340": "http://farm4.static.flickr.com/3119/3120431547_c11e170b02.jpg",
        "n00005787_6407": "http://farm5.static.flickr.com/4018/4252900901_cf2577b407.jpg",
        "n00005787_6433": "http://farm4.static.flickr.com/3093/3120541377_cea1da1ccd.jpg",
        "n00005787_6467": "http://farm4.static.flickr.com/3305/3239955191_8425f5aa76.jpg",
        "n00005787_6517": "http://farm5.static.flickr.com/4019/4649874100_9708936606.jpg",
        "n00005787_6541": "http://farm4.static.flickr.com/3109/3120484969_3de0a3791e.jpg",
        "n00005787_6564": "http://farm3.static.flickr.com/2124/2065727301_200c552360.jpg",
        "n00005787_6583": "http://farm6.static.flickr.com/5298/5393279364_e66fde5d34.jpg",
        "n00005787_6587": "http://farm4.static.flickr.com/3254/3120918828_db1233d0d9.jpg",
        "n00005787_6612": "http://farm4.static.flickr.com/3527/3224806907_1f18d12d31.jpg",
        "n00005787_6620": "http://farm4.static.flickr.com/3116/2634608873_acd6fa9e12.jpg",
        "n00005787_6625": "http://farm2.static.flickr.com/1330/1332200459_47eedf46e5.jpg",
        "n00005787_6649": "http://farm1.static.flickr.com/99/280428660_75ecd8bd65.jpg",
        "n00005787_6652": "http://farm4.static.flickr.com/3256/2573634890_c16ca4e96c.jpg",
        "n00005787_6654": "http://farm1.static.flickr.com/106/259207978_a19c235c4a.jpg",
        "n00005787_6673": "http://farm5.static.flickr.com/4130/5029544691_2938beeafd.jpg",
        "n00005787_6681": "http://farm4.static.flickr.com/3264/2298668680_4155ba7f5a.jpg",
        "n00005787_6698": "http://farm4.static.flickr.com/3500/4004812001_c1cdafd1d7.jpg",
        "n00005787_6729": "http://farm5.static.flickr.com/4033/4712828967_207e717c68.jpg",
        "n00005787_6743": "http://farm5.static.flickr.com/4049/4631308141_e2aa29a0a3.jpg",
        "n00005787_6754": "http://farm4.static.flickr.com/3464/3224856841_18191566f6.jpg",
        "n00005787_6780": "http://farm3.static.flickr.com/2062/1887201509_66af919978.jpg",
        "n00005787_6830": "http://farm4.static.flickr.com/3102/2482242825_c6cf9dc893.jpg",
        "n00005787_6833": "http://farm4.static.flickr.com/3290/3121284874_6a4676010d.jpg",
        "n00005787_6847": "http://farm4.static.flickr.com/3355/3225653940_b63041c4b8.jpg",
        "n00005787_6859": "http://farm4.static.flickr.com/3268/2842514586_38c5a82f63.jpg",
        "n00005787_6873": "http://farm4.static.flickr.com/3029/2816770854_429fc9c9ce.jpg",
        "n00005787_6885": "http://farm4.static.flickr.com/3041/2832131927_8c8241750f.jpg",
        "n00005787_6902": "http://farm1.static.flickr.com/79/259117244_06a725b5ef.jpg",
        "n00005787_6919": "http://farm4.static.flickr.com/3253/2299712838_06a6b434b3.jpg",
        "n00005787_6965": "http://farm4.static.flickr.com/3390/3443868205_30c1593507.jpg",
        "n00005787_7012": "http://farm3.static.flickr.com/2251/2206054342_9b45b0595d.jpg",
        "n00005787_7027": "http://farm5.static.flickr.com/4116/4812075198_0fa53bb743.jpg",
        "n00005787_7034": "http://farm4.static.flickr.com/3225/3120445967_151aa3fffa.jpg",
        "n00005787_7060": "http://farm3.static.flickr.com/2103/2310121322_cc7a1817f6.jpg",
        "n00005787_7078": "http://farm4.static.flickr.com/3190/3037100098_fc69b42dbe.jpg",
        "n00005787_7090": "http://farm4.static.flickr.com/3095/2317451205_1e8284be2b.jpg",
        "n00005787_7091": "http://farm4.static.flickr.com/3199/3120417149_40ee64de22.jpg",
        "n00005787_7104": "http://farm5.static.flickr.com/4006/4668328621_7455913688.jpg",
        "n00005787_7108": "http://farm4.static.flickr.com/3282/2298903465_0e92eff26a.jpg",
        "n00005787_7112": "http://farm1.static.flickr.com/80/259207529_2b8ddf80e4.jpg",
        "n00005787_7126": "http://farm4.static.flickr.com/3126/3120569761_f27c9f1a4d.jpg",
        "n00005787_7188": "http://farm4.static.flickr.com/3068/3121139744_47ee55c3c5.jpg",
        "n00005787_7262": "http://farm1.static.flickr.com/84/259207033_fb51d78ab5.jpg",
        "n00005787_7277": "http://farm1.static.flickr.com/83/245525004_95732d8f4a.jpg",
        "n00005787_7281": "http://farm4.static.flickr.com/3001/2792704870_c10810d2f4.jpg",
        "n00005787_7298": "http://farm4.static.flickr.com/3206/3120533957_ac16fd6267.jpg",
        "n00005787_7305": "http://farm4.static.flickr.com/3260/3121204652_0a206af794.jpg",
        "n00005787_7306": "http://farm5.static.flickr.com/4029/4445552165_cc6c8872c2.jpg",
        "n00005787_7326": "http://farm5.static.flickr.com/4070/4533612676_03a70180e0.jpg",
        "n00005787_7370": "http://farm1.static.flickr.com/95/259208507_08f8af957e.jpg",
        "n00005787_7391": "http://farm3.static.flickr.com/2764/4113927466_769275eafc.jpg",
        "n00005787_7406": "http://farm4.static.flickr.com/3311/3287944074_d887f836bf.jpg",
        "n00005787_7421": "http://farm5.static.flickr.com/4071/4545020900_f010ac8701.jpg",
        "n00005787_7422": "http://farm4.static.flickr.com/3443/3240793840_c2321d3498.jpg",
        "n00005787_7423": "http://farm6.static.flickr.com/5260/5567366637_a9a96e4179.jpg",
        "n00005787_7462": "http://farm1.static.flickr.com/192/441680373_e253f634b9.jpg",
        "n00005787_7464": "http://farm6.static.flickr.com/5100/5567948854_2b9ce292a1.jpg",
        "n00005787_7557": "http://farm4.static.flickr.com/3581/3444683154_b216216650.jpg",
        "n00005787_7567": "http://farm1.static.flickr.com/98/259111199_e2a45c13f0.jpg",
        "n00005787_7572": "http://farm3.static.flickr.com/2691/4446328246_a67682d35d.jpg",
        "n00005787_7573": "http://farm4.static.flickr.com/3542/3443873369_aa29dcf0e9.jpg",
        "n00005787_7640": "http://farm3.static.flickr.com/2112/2310121180_7c6d729ea0.jpg",
        "n00005787_7644": "http://farm2.static.flickr.com/1070/531516645_a585e9c0e1.jpg",
        "n00005787_7655": "http://farm3.static.flickr.com/2747/4152230300_194ef2d257.jpg",
        "n00005787_7673": "http://farm5.static.flickr.com/4066/4659131915_fd043e2e79.jpg",
        "n00005787_7721": "http://farm4.static.flickr.com/3133/3121173688_23feb48e8b.jpg",
        "n00005787_7736": "http://farm6.static.flickr.com/5057/5486079634_bb1c8223ba.jpg",
        "n00005787_7771": "http://farm3.static.flickr.com/2358/2660133944_9039f15ffc.jpg",
        "n00005787_7801": "http://farm5.static.flickr.com/4092/5030180976_3733c0b78e.jpg",
        "n00005787_7864": "http://farm1.static.flickr.com/195/441685263_6fefdaab51.jpg",
        "n00005787_7869": "http://farm6.static.flickr.com/5107/5567365015_04e905337c.jpg",
        "n00005787_7957": "http://farm1.static.flickr.com/117/280428743_597f8f7286.jpg",
        "n00005787_7963": "http://farm5.static.flickr.com/4028/4544848026_b365de3ee0.jpg",
        "n00005787_7987": "http://farm1.static.flickr.com/84/259116744_e5387ad23f.jpg",
        "n00005787_7995": "http://farm4.static.flickr.com/3607/3377582545_943f39fba6.jpg",
        "n00005787_8006": "http://farm2.static.flickr.com/1310/1341458692_24c21d422f.jpg",
        "n00005787_8037": "http://farm3.static.flickr.com/2496/3704093734_bec38af494.jpg",
        "n00005787_8060": "http://farm3.static.flickr.com/2525/4005445280_4ae562c53e.jpg",
        "n00005787_8236": "http://farm4.static.flickr.com/3121/3121266266_b501674e48.jpg",
        "n00005787_8271": "http://farm3.static.flickr.com/2702/4253669372_d4a064f6f2.jpg",
        "n00005787_8278": "http://farm6.static.flickr.com/5011/5392662915_2f2d910972.jpg",
        "n00005787_8293": "http://farm6.static.flickr.com/5283/5242110599_1a0ddb0303.jpg",
        "n00005787_8349": "http://farm4.static.flickr.com/3413/3225651576_9ca37e07c8.jpg",
        "n00005787_8391": "http://farm4.static.flickr.com/3054/2791856213_4b01268643.jpg",
        "n00005787_8414": "http://farm1.static.flickr.com/81/259112062_6c5c71ebcf.jpg",
        "n00005787_8461": "http://farm4.static.flickr.com/3566/3444694878_77e6cbd929.jpg",
        "n00005787_8478": "http://farm3.static.flickr.com/2318/2091137118_5af3c46f98.jpg",
        "n00005787_8504": "http://farm1.static.flickr.com/24/62112934_7feaf2a807.jpg",
        "n00005787_8519": "http://farm1.static.flickr.com/172/441683042_da61907d38.jpg",
        "n00005787_8543": "http://farm2.static.flickr.com/1116/824035323_e29fc2d630.jpg",
        "n00005787_8562": "http://farm3.static.flickr.com/2555/3767917861_5414328a2c.jpg",
        "n00005787_8584": "http://farm4.static.flickr.com/3185/3120350227_e0777e9ea5.jpg",
        "n00005787_8603": "http://farm2.static.flickr.com/1215/1342119128_cd85369e44.jpg",
        "n00005787_8616": "http://farm4.static.flickr.com/3261/3120576389_e25b22f513.jpg",
        "n00005787_8640": "http://farm6.static.flickr.com/5134/5492175774_f873d6def2.jpg",
        "n00005787_8656": "http://farm3.static.flickr.com/2157/2090350779_f8a016861f.jpg",
        "n00005787_8709": "http://farm4.static.flickr.com/3234/2536681734_0d20667e18.jpg",
        "n00005787_8735": "http://farm1.static.flickr.com/127/323948382_271b4042c2.jpg",
        "n00005787_8756": "http://farm3.static.flickr.com/2316/2093703716_6f3d8c4726.jpg",
        "n00005787_8784": "http://farm3.static.flickr.com/2369/2069175411_8e6a7003ae.jpg",
        "n00005787_8857": "http://farm3.static.flickr.com/2689/4243748850_306fee3a28.jpg",
        "n00005787_8892": "http://farm4.static.flickr.com/3476/3950107906_e93fe0f4ed.jpg",
        "n00005787_8911": "http://farm2.static.flickr.com/1146/1340571251_af2d375db8.jpg",
        "n00005787_9064": "http://farm3.static.flickr.com/2038/2396858277_3c47b413f2.jpg",
        "n00005787_9075": "http://farm4.static.flickr.com/3111/3120087655_1718cb099c.jpg",
        "n00005787_9143": "http://farm6.static.flickr.com/5218/5393171750_d96e5092d9.jpg",
        "n00005787_9146": "http://farm4.static.flickr.com/3131/2792712046_d728116426.jpg",
        "n00005787_9148": "http://farm3.static.flickr.com/2003/2317265511_9ca99f6801.jpg",
        "n00005787_9159": "http://farm5.static.flickr.com/4026/4568402055_db63da47c6.jpg",
        "n00005787_9167": "http://farm3.static.flickr.com/2727/4152230740_c94f2a3c71.jpg",
        "n00005787_9175": "http://farm4.static.flickr.com/3205/2960028932_8388f1a5f0.jpg",
        "n00005787_9189": "http://farm4.static.flickr.com/3288/2847039387_4f5ae0d796.jpg",
        "n00005787_9255": "http://farm3.static.flickr.com/2801/4113161201_8fa537d98d.jpg",
        "n00005787_9359": "http://farm4.static.flickr.com/3017/2482246507_3ceea9a355.jpg",
        "n00005787_9361": "http://farm6.static.flickr.com/5256/5393169396_fd05459417.jpg",
        "n00005787_9393": "http://farm5.static.flickr.com/4058/4545028640_db685aa620.jpg",
        "n00005787_9414": "http://farm4.static.flickr.com/3017/3121216338_c564c2ed1b.jpg",
        "n00005787_9428": "http://farm2.static.flickr.com/1245/1441813542_986965b9c8.jpg",
        "n00005787_9571": "http://farm4.static.flickr.com/3159/2979048672_5a19593596.jpg",
        "n00005787_9573": "http://farm3.static.flickr.com/2340/2536689092_a63cf96863.jpg",
        "n00005787_9574": "http://farm3.static.flickr.com/2521/3704093246_498a2a1178.jpg",
        "n00005787_9575": "http://farm2.static.flickr.com/1014/1392663534_0c83c12c10.jpg",
        "n00005787_9584": "http://farm3.static.flickr.com/2227/2299711736_7c21e5a1cd.jpg",
        "n00005787_9585": "http://farm1.static.flickr.com/120/280429988_163408d65e.jpg",
        "n00005787_9601": "http://farm4.static.flickr.com/3125/3120365387_b3a74e861a.jpg",
        "n00005787_9609": "http://farm5.static.flickr.com/4008/4533628486_f537f0e47d.jpg",
        "n00005787_9626": "http://farm1.static.flickr.com/79/245538560_7ab5c73cdc.jpg",
        "n00005787_9653": "http://farm4.static.flickr.com/3458/3225682978_786b550bdc.jpg",
        "n00005787_9685": "http://farm5.static.flickr.com/4098/4816913251_3d2542710e.jpg",
        "n00005787_9716": "http://farm4.static.flickr.com/3081/3224815853_72616d1ef0.jpg",
        "n00005787_9723": "http://farm2.static.flickr.com/1266/559584572_bff32f7897.jpg",
        "n00005787_9780": "http://farm1.static.flickr.com/92/245537973_9ae1075f13.jpg",
        "n00005787_9817": "http://farm1.static.flickr.com/13/15084866_bd4d61cd17.jpg",
        "n00005787_9845": "http://farm1.static.flickr.com/83/245541021_4bde236246.jpg",
        "n00005787_9882": "http://farm3.static.flickr.com/2700/4533607712_8ec1956a2e.jpg",
        "n00005787_9885": "http://farm4.static.flickr.com/3248/2483060930_7c8513502a.jpg",
        "n00005787_9887": "http://farm5.static.flickr.com/4131/5029560725_f38d624e3b.jpg",
        "n00005787_9953": "http://farm1.static.flickr.com/193/441680363_f8e55fe735.jpg",
        "n00005787_9959": "http://farm5.static.flickr.com/4131/5029556485_58bd9feb69.jpg",
        "n00005787_10012": "http://farm5.static.flickr.com/4051/4631906650_9254d17b2a.jpg",
        "n00005787_10027": "http://farm5.static.flickr.com/4133/5030151232_9c2f7b4104.jpg",
        "n00005787_10045": "http://farm4.static.flickr.com/3266/3121383494_05053629ef.jpg",
        "n00005787_10081": "http://farm3.static.flickr.com/2415/2482243911_fd8aae3ab2.jpg",
        "n00005787_10115": "http://farm1.static.flickr.com/93/259112356_ee4189d8df.jpg",
        "n00005787_10135": "http://farm4.static.flickr.com/3097/2654942921_b1f008e1ca.jpg",
        "n00005787_10166": "http://farm6.static.flickr.com/5098/5393248810_b0cbf33151.jpg",
        "n00005787_10171": "http://farm1.static.flickr.com/82/259112658_92d3d901b3.jpg",
        "n00005787_10200": "http://farm4.static.flickr.com/3408/3444695488_2a4625cee1.jpg",
        "n00005787_10202": "http://farm1.static.flickr.com/118/280429677_7d6b32e2bb.jpg",
        "n00005787_10227": "http://farm3.static.flickr.com/2533/4005067302_b03a058ac4.jpg",
        "n00005787_10235": "http://farm6.static.flickr.com/5055/5485405169_2ced51ac98.jpg",
        "n00005787_10267": "http://farm1.static.flickr.com/16/91299996_603d71cab0.jpg",
        "n00005787_10275": "http://farm4.static.flickr.com/3457/3224852897_8893aefccd.jpg",
        "n00005787_10286": "http://farm3.static.flickr.com/2111/2372052577_57c46f05f0.jpg",
        "n00005787_10348": "http://farm1.static.flickr.com/122/280428701_e0c1518342.jpg",
        "n00005787_10380": "http://farm4.static.flickr.com/3217/2960028874_4cc138a39f.jpg",
        "n00005787_10421": "http://farm3.static.flickr.com/2383/2520209724_94db428e69.jpg",
        "n00005787_10437": "http://farm4.static.flickr.com/3461/3240795104_919de78ca3.jpg",
        "n00005787_10481": "http://farm3.static.flickr.com/2358/2092907731_e426f40470.jpg",
        "n00005787_10539": "http://farm4.static.flickr.com/3608/3443872087_216427a1a7.jpg",
        "n00005787_10566": "http://farm3.static.flickr.com/2088/2300491033_b48d19873b.jpg",
        "n00005787_10638": "http://farm4.static.flickr.com/3119/2799023005_e31006a3ce.jpg",
        "n00005787_10703": "http://farm5.static.flickr.com/4109/5002967955_177d6e574c.jpg",
        "n00005787_10719": "http://farm3.static.flickr.com/2228/2658601098_14bb88178a.jpg",
        "n00005787_10758": "http://farm4.static.flickr.com/3353/3224853679_ab4f02460c.jpg",
        "n00005787_10762": "http://farm4.static.flickr.com/3288/3121298472_45816752b2.jpg",
        "n00005787_10789": "http://farm6.static.flickr.com/5012/5392575757_5e7136f6b8.jpg",
        "n00005787_10792": "http://farm3.static.flickr.com/2117/2093713032_66a60b4c19.jpg",
        "n00005787_10798": "http://farm4.static.flickr.com/3049/2298921713_b8d6093fbe.jpg",
        "n00005787_10820": "http://farm2.static.flickr.com/1263/1342121930_b561064032.jpg",
        "n00005787_10825": "http://farm3.static.flickr.com/2723/4253674650_3abd864ec4.jpg",
        "n00005787_10868": "http://farm6.static.flickr.com/5215/5392891887_2d39534792.jpg",
        "n00005787_10914": "http://farm1.static.flickr.com/107/280428950_cb3a224185.jpg",
        "n00005787_10921": "http://farm4.static.flickr.com/3035/2655037179_5ba53dcbf3.jpg",
        "n00005787_10934": "http://farm2.static.flickr.com/1112/1360174385_9c4633f516.jpg",
        "n00005787_10944": "http://farm5.static.flickr.com/4057/4532969227_dc88a9c03a.jpg",
        "n00005787_11019": "http://farm2.static.flickr.com/1232/1341461602_5210609e4a.jpg",
        "n00005787_11035": "http://farm4.static.flickr.com/3010/2483056318_151c592241.jpg",
        "n00005787_11069": "http://farm4.static.flickr.com/3267/3121736287_8db77ec1d7.jpg",
        "n00005787_11093": "http://farm4.static.flickr.com/3348/3444690056_517396c561.jpg",
        "n00005787_11139": "http://farm4.static.flickr.com/3432/3784463467_a62b9613f6.jpg",
        "n00005787_11159": "http://farm4.static.flickr.com/3232/3120291237_3b3c808851.jpg",
        "n00005787_11205": "http://farm1.static.flickr.com/105/259206813_0955fbdffb.jpg",
        "n00005787_11276": "http://farm5.static.flickr.com/4072/4631908272_678e6b7d57.jpg",
        "n00005787_11288": "http://farm4.static.flickr.com/3371/3224809407_bea2809cd2.jpg",
        "n00005787_11295": "http://farm5.static.flickr.com/4016/4544397555_6c844b536b.jpg",
        "n00005787_11306": "http://farm3.static.flickr.com/2096/2482243733_429de6db0d.jpg",
        "n00005787_11316": "http://farm3.static.flickr.com/2541/4252909331_36be916897.jpg",
        "n00005787_11347": "http://farm4.static.flickr.com/3312/3443878351_f0502aaf15.jpg",
        "n00005787_11516": "http://farm4.static.flickr.com/3020/4554005780_670f404981.jpg",
        "n00005787_11519": "http://farm3.static.flickr.com/2187/2388455447_151d087518.jpg",
        "n00005787_11528": "http://farm4.static.flickr.com/3237/2709939607_91b3cb9832.jpg",
        "n00005787_11590": "http://farm4.static.flickr.com/3076/2710786108_0042df8732.jpg",
        "n00005787_11592": "http://farm4.static.flickr.com/3214/2794959115_e3ea5e67fc.jpg",
        "n00005787_11593": "http://farm4.static.flickr.com/3015/2710787852_8822713d23.jpg",
        "n00005787_11610": "http://farm4.static.flickr.com/3423/3224838833_19291f2bc6.jpg",
        "n00005787_11612": "http://farm4.static.flickr.com/3003/2959188717_0ca82608cb.jpg",
        "n00005787_11617": "http://farm4.static.flickr.com/3186/2706452133_c7e5bce820.jpg",
        "n00005787_11639": "http://farm5.static.flickr.com/4147/5003576012_7a0151028b.jpg",
        "n00005787_11666": "http://farm4.static.flickr.com/3107/3120395509_49415b54b2.jpg",
        "n00005787_11702": "http://farm4.static.flickr.com/3212/2791863549_a030afbc90.jpg",
        "n00005787_11721": "http://farm1.static.flickr.com/87/206093607_ca2fbd00d6.jpg",
        "n00005787_11737": "http://farm3.static.flickr.com/2078/2482246733_fba6ca5cff.jpg",
        "n00005787_11752": "http://farm2.static.flickr.com/1287/1133494764_0fa894f46e.jpg",
        "n00005787_11775": "http://farm5.static.flickr.com/4088/5030184496_bab7d252b8.jpg",
        "n00005787_11799": "http://farm2.static.flickr.com/1292/1133477960_f00562a1d5.jpg",
        "n00005787_11801": "http://farm4.static.flickr.com/3061/2978191459_06bbc59b97.jpg",
        "n00005787_11825": "http://farm4.static.flickr.com/3349/3224798145_c2fc53ab17.jpg",
        "n00005787_11849": "http://farm4.static.flickr.com/3286/3121364530_3a37a4ab95.jpg",
        "n00005787_11855": "http://farm3.static.flickr.com/2004/2482242165_84af0619f2.jpg",
        "n00005787_11858": "http://farm5.static.flickr.com/4034/4659132841_d597c9b6f6.jpg",
        "n00005787_11869": "http://farm1.static.flickr.com/116/259206644_675cbcc013.jpg",
        "n00005787_11873": "http://farm3.static.flickr.com/2529/4113928264_3a3c688250.jpg",
        "n00005787_11880": "http://farm4.static.flickr.com/3445/3239956995_a0866b82f5.jpg",
        "n00005787_11897": "http://farm4.static.flickr.com/3260/3224844669_ba79e037e5.jpg",
        "n00005787_12029": "http://farm3.static.flickr.com/2312/2300490461_bba285b480.jpg",
        "n00005787_12094": "http://farm4.static.flickr.com/3268/3121227634_ec1b8155a9.jpg",
        "n00005787_12128": "http://farm1.static.flickr.com/81/230030157_65e88a22e9.jpg",
        "n00005787_12150": "http://farm1.static.flickr.com/115/280430104_2a631c6fbc.jpg",
        "n00005787_12177": "http://farm3.static.flickr.com/2205/2205266877_7607516b6a.jpg",
        "n00005787_12198": "http://farm5.static.flickr.com/4149/5029535389_ab2f6663ea.jpg",
        "n00005787_12199": "http://farm6.static.flickr.com/5217/5392676149_1e7aaee37d.jpg",
        "n00005787_12203": "http://farm4.static.flickr.com/3126/3224851525_bc372441e9.jpg",
        "n00005787_12210": "http://farm4.static.flickr.com/3393/3225656834_53cd4ce5f1.jpg",
        "n00005787_12215": "http://farm1.static.flickr.com/174/441680377_8fa1449d0d.jpg",
        "n00005787_12258": "http://farm4.static.flickr.com/3056/2318265748_e97c1437c4.jpg",
        "n00005787_12285": "http://farm1.static.flickr.com/91/259209101_4560b4de43.jpg",
        "n00005787_12287": "http://farm4.static.flickr.com/3133/2317464369_25eb9d846d.jpg",
        "n00005787_12306": "http://farm5.static.flickr.com/4069/4545026482_7359597607.jpg",
        "n00005787_12370": "http://farm3.static.flickr.com/2694/4252904283_8e9cef4f93.jpg",
        "n00005787_12394": "http://farm5.static.flickr.com/4033/4532969705_055a8c8c7e.jpg",
        "n00005787_12408": "http://farm6.static.flickr.com/5091/5393247240_23ca4e7171.jpg",
        "n00005787_12426": "http://farm4.static.flickr.com/3140/2635432392_7fe79e5fd0.jpg",
        "n00005787_12464": "http://farm2.static.flickr.com/1420/1133491344_22b7eeb8ae.jpg",
        "n00005787_12501": "http://farm1.static.flickr.com/88/205685436_f8f7549ef4.jpg",
        "n00005787_12545": "http://farm5.static.flickr.com/4041/4545021196_861920b91d.jpg",
        "n00005787_12547": "http://farm3.static.flickr.com/2730/4252901555_6e6266592a.jpg",
        "n00005787_12568": "http://farm4.static.flickr.com/3058/2655044593_32977a4802.jpg",
        "n00005787_12575": "http://farm1.static.flickr.com/90/234728263_85127c765c.jpg",
        "n00005787_12623": "http://farm1.static.flickr.com/11/91300536_7c2d75632f.jpg",
        "n00005787_12625": "http://farm5.static.flickr.com/4154/5030152704_dfb800be9f.jpg",
        "n00005787_12658": "http://farm6.static.flickr.com/5131/5486090566_6dc3e575c9.jpg",
        "n00005787_12666": "http://farm4.static.flickr.com/3141/2655001105_0ffeec5302.jpg",
        "n00005787_12686": "http://farm3.static.flickr.com/2791/4085490355_842a550f4f.jpg",
        "n00005787_12762": "http://farm5.static.flickr.com/4047/4684343022_bdfe01a696.jpg",
        "n00005787_12767": "http://farm6.static.flickr.com/5258/5393494456_309841c386.jpg",
        "n00005787_12769": "http://farm6.static.flickr.com/5241/5242754242_49a76f842a.jpg",
        "n00005787_12771": "http://farm2.static.flickr.com/1188/1133456816_e539cc54e1.jpg",
        "n00005787_12775": "http://farm1.static.flickr.com/93/259115637_367064cd73.jpg",
        "n00005787_12793": "http://farm6.static.flickr.com/5017/5393483392_5a3896ea07.jpg",
        "n00005787_12812": "http://farm3.static.flickr.com/2206/2635432440_8051ef20da.jpg",
        "n00005787_12856": "http://farm5.static.flickr.com/4022/4460267574_5fcc8ccdbd.jpg",
        "n00005787_12858": "http://farm4.static.flickr.com/3179/3120449845_a0b818d852.jpg",
        "n00005787_12877": "http://farm2.static.flickr.com/1406/1133467732_a3b7bf204d.jpg",
        "n00005787_12918": "http://farm4.static.flickr.com/3246/3121371816_fd3b581e52.jpg",
        "n00005787_12928": "http://farm6.static.flickr.com/5171/5486007132_e4d15497b3.jpg",
        "n00005787_12931": "http://farm3.static.flickr.com/2118/1505444590_661dd87969.jpg",
        "n00005787_12936": "http://farm5.static.flickr.com/4037/4533617628_b421f325d8.jpg",
        "n00005787_12948": "http://farm4.static.flickr.com/3510/3224854597_931e9f89d5.jpg",
        "n00005787_12959": "http://farm3.static.flickr.com/2429/4005077222_d65e6af05e.jpg",
        "n00005787_12965": "http://farm3.static.flickr.com/2289/2205266865_3831ababcb.jpg",
        "n00005787_12976": "http://farm5.static.flickr.com/4152/5004745055_3bdecb26f4.jpg",
        "n00005787_12981": "http://farm6.static.flickr.com/5297/5392655283_5ac4a54752.jpg",
        "n00005787_12989": "http://farm5.static.flickr.com/4088/5029564161_2c61158799.jpg",
        "n00005787_12994": "http://farm5.static.flickr.com/4083/5004741111_e444f2c517.jpg",
        "n00005787_13014": "http://farm4.static.flickr.com/3624/3581300300_06bd9d788d_o.jpg",
        "n00005787_13030": "http://farm6.static.flickr.com/5011/5457885861_1f78e43b94.jpg",
        "n00005787_13051": "http://farm4.static.flickr.com/3040/2657746313_bd0d675c63.jpg",
        "n00005787_13093": "http://farm2.static.flickr.com/1133/1341461214_0d5d5c5842.jpg",
        "n00005787_13108": "http://farm4.static.flickr.com/3247/2654893807_96e542d479.jpg",
        "n00005787_13127": "http://farm4.static.flickr.com/3532/3272495412_741a67215e.jpg",
        "n00005787_13130": "http://farm4.static.flickr.com/3515/4004389115_05679762e5.jpg",
        "n00005787_13140": "http://farm6.static.flickr.com/5017/5485406213_1f2323962c.jpg",
        "n00005787_13141": "http://farm1.static.flickr.com/97/280430292_9d2a013d22.jpg",
        "n00005787_13145": "http://farm6.static.flickr.com/5291/5393267848_6f97f46f48.jpg",
        "n00005787_13146": "http://farm1.static.flickr.com/45/139791791_8b62031fe4.jpg",
        "n00005787_13164": "http://farm4.static.flickr.com/3650/3444683730_0b24a9d6ed.jpg",
        "n00005787_13174": "http://farm2.static.flickr.com/1246/1132638525_0c0c242ec8.jpg",
        "n00005787_13198": "http://farm1.static.flickr.com/23/91297875_825b860b50.jpg",
        "n00005787_13204": "http://farm4.static.flickr.com/3521/4075292725_3c98d435b6.jpg",
        "n00005787_13221": "http://farm6.static.flickr.com/5094/5567964704_6ef04fd52b.jpg",
        "n00005787_13222": "http://farm4.static.flickr.com/3247/2960029110_e471b0fa1c.jpg",
        "n00005787_13230": "http://farm5.static.flickr.com/4013/4649239245_3a7d58b1ee.jpg",
        "n00005787_13231": "http://farm1.static.flickr.com/74/205688200_cfa63557b3.jpg",
        "n00005787_13236": "http://farm1.static.flickr.com/88/245529305_0d3758f2ec.jpg",
        "n00005787_13246": "http://farm4.static.flickr.com/3223/3120079951_32586d0c06.jpg",
        "n00005787_13265": "http://farm4.static.flickr.com/3466/3709323829_7db5fedc45.jpg",
        "n00005787_13279": "http://farm1.static.flickr.com/105/280430082_6f8fdd12e6.jpg",
        "n00005787_13294": "http://farm5.static.flickr.com/4020/4659132601_af3e100f32.jpg",
        "n00005787_13313": "http://farm4.static.flickr.com/3251/3121347248_3fd13f94c4.jpg",
        "n00005787_13344": "http://farm4.static.flickr.com/3124/3120910846_49a3ba44be.jpg",
        "n00005787_13345": "http://farm5.static.flickr.com/4151/5004739391_cea3622fcb.jpg",
        "n00005787_13359": "http://farm2.static.flickr.com/1207/1340571979_a71160fa28.jpg",
        "n00005787_13412": "http://farm4.static.flickr.com/3354/3444692732_0ed75e6384.jpg",
        "n00005787_13420": "http://farm1.static.flickr.com/94/280428770_30dd399feb.jpg",
        "n00005787_13460": "http://farm3.static.flickr.com/2093/2482244073_eded52a032.jpg",
        "n00005787_13465": "http://farm4.static.flickr.com/3206/3120559957_2c9bb43986.jpg",
        "n00005787_13496": "http://farm4.static.flickr.com/3339/3444693298_1385a8606e.jpg",
        "n00005787_13513": "http://farm4.static.flickr.com/3038/3042812379_2739846493.jpg",
        "n00005787_13516": "http://farm4.static.flickr.com/3288/2906610741_c3c0a89c0e_o.jpg",
        "n00005787_13532": "http://farm5.static.flickr.com/4152/5029557259_bd8d6b6975.jpg",
        "n00005787_13542": "http://farm4.static.flickr.com/3420/3703284843_8e311cdfb5.jpg",
        "n00005787_13559": "http://farm4.static.flickr.com/3099/3225669884_667c01b938.jpg",
        "n00005787_13560": "http://farm4.static.flickr.com/3060/2482241167_b82d77ec0d.jpg",
        "n00005787_13600": "http://farm4.static.flickr.com/3351/3443862917_a11c7f7d3e.jpg",
        "n00005787_13639": "http://farm4.static.flickr.com/3250/2960028586_34f8a264fa.jpg",
        "n00005787_13699": "http://farm3.static.flickr.com/2729/4533613830_541a739ce0.jpg",
        "n00005787_13721": "http://farm2.static.flickr.com/1250/857178399_607c03dc4a.jpg",
        "n00005787_13728": "http://farm3.static.flickr.com/2373/2483060408_0c65fa447d.jpg",
        "n00005787_13739": "http://farm1.static.flickr.com/17/23449387_0d3bd8e862.jpg",
        "n00005787_13774": "http://farm4.static.flickr.com/3608/3444687076_6fe2fc9c98.jpg",
        "n00005787_13912": "http://farm1.static.flickr.com/97/245536551_fb7866f3fe.jpg",
        "n00005787_13919": "http://farm4.static.flickr.com/3146/2655718146_5400a53c7f.jpg",
        "n00005787_13980": "http://farm4.static.flickr.com/3033/2719533980_298835b7b6.jpg",
        "n00005787_14011": "http://farm5.static.flickr.com/4136/4820414463_b4fb40aaf2.jpg",
        "n00005787_14014": "http://farm4.static.flickr.com/3194/2678920355_58a80aa77d.jpg",
        "n00005787_14017": "http://farm1.static.flickr.com/79/245542731_5763da9b08.jpg",
        "n00005787_14110": "http://farm4.static.flickr.com/3386/3244362099_a2b7e85c32.jpg",
        "n00005787_14138": "http://farm5.static.flickr.com/4075/4816913237_a22f473fee.jpg",
        "n00005787_14155": "http://farm3.static.flickr.com/2246/2312934163_fa2469f752.jpg",
        "n00005787_14160": "http://farm3.static.flickr.com/2524/4151471261_fd69159339.jpg",
        "n00005787_14172": "http://farm5.static.flickr.com/4060/4712576636_50873e7e77.jpg",
        "n00005787_14194": "http://farm1.static.flickr.com/77/230030221_7fd77071dc.jpg",
        "n00005787_14201": "http://farm4.static.flickr.com/3092/3225694834_eb26735bc0.jpg"
    }
}' http://172.50.0.2:8080/v1/download/multi # download external files into AIS cluster

echo "Adding Grafana dashboard..."
curl -d '{"meta":{"isStarred":true,"type":"db","canSave":true,"canEdit":true,"canAdmin":true,"canStar":true,"slug":"aistore","isFolder":false,"folderId":0,"folderTitle":"General","folderUrl":"","provisioned":false},"dashboard":{"annotations": { "list": [ { "builtIn": 1, "datasource": "-- Grafana --", "enable": true, "hide": true, "iconColor": "rgba(0, 211, 255, 1)", "name": "Annotations & Alerts", "type": "dashboard" } ] }, "editable": true, "gnetId": null, "graphTooltip": 0, "id": null, "links": [], "panels": [ { "aliasColors": {}, "bars": false, "dashLength": 10, "dashes": false, "fill": 1, "gridPos": { "h": 9, "w": 12, "x": 0, "y": 0 }, "id": 2, "legend": { "avg": false, "current": false, "max": false, "min": false, "show": true, "total": false, "values": false }, "lines": true, "linewidth": 1, "links": [], "nullPointMode": "null", "percentage": false, "pointradius": 5, "points": false, "renderer": "flot", "seriesOverrides": [], "spaceLength": 10, "stack": false, "steppedLine": false, "targets": [ { "refCount": 0, "refId": "A", "target": "sumSeries(stats.gauges.aistarget.*.dl.count, a)" }, { "refCount": 0, "refId": "B", "target": "sumSeries(stats.gauges.aistarget.*.err.dl.count, b)" } ], "thresholds": [], "timeFrom": null, "timeRegions": [], "timeShift": null, "title": "Requests count (200, 404)", "tooltip": { "shared": true, "sort": 0, "value_type": "individual" }, "type": "graph", "xaxis": { "buckets": null, "mode": "time", "name": null, "show": true, "values": [] }, "yaxes": [ { "format": "short", "label": null, "logBase": 1, "max": null, "min": null, "show": true }, { "format": "short", "label": null, "logBase": 1, "max": null, "min": null, "show": true } ], "yaxis": { "align": false, "alignLevel": null } }, { "aliasColors": {}, "bars": false, "dashLength": 10, "dashes": false, "fill": 1, "gridPos": { "h": 9, "w": 12, "x": 12, "y": 0 }, "id": 4, "legend": { "avg": false, "current": false, "max": false, "min": false, "show": true, "total": false, "values": false }, "lines": true, "linewidth": 1, "links": [], "nullPointMode": "null", "percentage": false, "pointradius": 5, "points": false, "renderer": "flot", "seriesOverrides": [], "spaceLength": 10, "stack": false, "steppedLine": false, "targets": [ { "refCount": 0, "refId": "B", "target": "sumSeries(stats.gauges.aistarget.*.dl.bytes, b)" }, { "refCount": 0, "refId": "A", "target": "stats.gauges.aistarget.*.dl.bytes" } ], "thresholds": [], "timeFrom": null, "timeRegions": [], "timeShift": null, "title": "Bytes received", "tooltip": { "shared": true, "sort": 0, "value_type": "individual" }, "type": "graph", "xaxis": { "buckets": null, "mode": "time", "name": null, "show": true, "values": [] }, "yaxes": [ { "format": "short", "label": null, "logBase": 1, "max": null, "min": null, "show": true }, { "format": "short", "label": null, "logBase": 1, "max": null, "min": null, "show": true } ], "yaxis": { "align": false, "alignLevel": null } }, { "aliasColors": {}, "bars": false, "dashLength": 10, "dashes": false, "fill": 1, "gridPos": { "h": 7, "w": 24, "x": 0, "y": 9 }, "id": 6, "legend": { "avg": false, "current": false, "max": false, "min": false, "show": true, "total": false, "values": false }, "lines": true, "linewidth": 1, "links": [], "nullPointMode": "null", "percentage": false, "pointradius": 5, "points": false, "renderer": "flot", "seriesOverrides": [], "spaceLength": 10, "stack": false, "steppedLine": false, "targets": [ { "refCount": -1, "refId": "A", "target": "stats.*.aistarget.*.get.throughput" }, { "refCount": 0, "refId": "B", "target": "alias(sumSeries(#A, #B), '"'"'Total throughput'"'"')", "targetFull": "alias(sumSeries(stats.*.aistarget.*.get.throughput, #B), '"'"'Total throughput'"'"')" } ], "thresholds": [], "timeFrom": null, "timeRegions": [], "timeShift": null, "title": "Get Throughput (bytes/sec)", "tooltip": { "shared": true, "sort": 0, "value_type": "individual" }, "type": "graph", "xaxis": { "buckets": null, "mode": "time", "name": null, "show": true, "values": [] }, "yaxes": [ { "format": "Bps", "label": null, "logBase": 1, "max": null, "min": null, "show": true }, { "format": "short", "label": null, "logBase": 1, "max": null, "min": null, "show": true } ], "yaxis": { "align": false, "alignLevel": null } } ], "refresh": "1s", "schemaVersion": 16, "style": "dark", "tags": [], "templating": { "list": [] }, "time": { "from": "now-5m", "to": "now" }, "timepicker": { "refresh_intervals": [ "1s", "5s", "10s" ], "time_options": [ "5m", "15m", "1h", "6h", "12h", "24h", "2d", "7d", "30d" ] }, "timezone": "", "title": "AIStore", "uid": null}}' -H "Content-Type: application/json" -X POST http://admin:admin@localhost:3000/api/dashboards/db > /dev/null 2>&1

echo "Opening Grafana dashboard in sec (login: admin;admin)..."
sleep 5
xdg-open http://localhost:3000/dashboards > /dev/null 2>&1
