For quick getting-started (local-playground) session _and_ in-depth overview, please refer to:

* [AIS AuthN documentation](/docs/authn.md).

## Table of contents

- [User Account and Access management](#user-account-and-access-management)
- [Token management](#token-management)
  - [Generate a token for CLI](#generate-a-token-for-cli)
  - [Generate a token to a file](#generate-a-token-to-a-file)
  - [Revoke a token](#revoke-a-token)
- [Command List](#command-list)
  - [Register new user](#register-new-user)
  - [Update user](#update-user)
  - [Unregister existing user](#unregister-existing-user)
  - [List registered users](#list-registered-users)
  - [Add a new role](#add-a-new-role)
  - [List existing roles](#list-existing-roles)
  - [Log in to AIS cluster](#log-in-to-ais-cluster)
  - [Log out](#log-out)
  - [Register new cluster](#register-new-cluster)
  - [Update existing cluster](#update-existing-cluster)
  - [Unregister existing cluster](#unregister-existing-cluster)
  - [List registered clusters](#list-registered-clusters)
  - [Show AuthN server configuration](#show-authn-server-configuration)
  - [Change AuthN server configuration](#change-authn-server-configuration)

## User Account and Access management

[AuthN](/docs/authn.md) is an AIS authorization server that can be deployed to manage user access to one or more AIS clusters.

All commands (except `logout`) send requests to AuthN URL defined in the AIS CLI configuration file.
Configuration can be overridden with environment variable `AIS_AUTHN_URL`, e.g., `AIS_AUTHN_URL=http://10.0.0.20:52001 ais auth add ...`.

The CLI provides an easy way to manage users, and to grant and revoke access permissions.
Only users with `Admin` role can manage the AuthN server.

Every request to AuthN, except `login` and `logout`, requires a token.
The token is generated by the server after the user successfully logs in.
CLI automatically saves the received token to user's configuration directory and attaches it to every request.

When a token is revoked, AuthN notifies [registered clusters](#list-registered-clusters), so that they update their blacklists.

## Token management

### Generate a token for CLI

After successful login, the CLI saves the generated token to the user's configuration directory for future use and automatically passes it with every request to AuthN.
For convenience, the CLI prints out the generated token so it can be copied and used with other clients.

```console
$ ais auth login -p admin admin
Token(/home/ubuntu/.config/ais/cli/auth.token):
```

### Generate a token to a file

The CLI supports loading a token from a custom location.
One possible usage is imitating the Linux `sudo` command:
    1. A user logs into the AIStore cluster as an Admin and saves the token to some location.
    2. The user logs into AIStore as a regular user with default options. (A regular user's requests would then use that last generated token for all requests).
    3. When elevated privileges are needed, the user can *specify the path to the admin token*.

```console
$ # Generate a token and save it to a given location
$ ais auth login -p admin --file ./admin.token admin
Token saved to ./admin.token

$ # Log in as a regular user
$ ais auth login -p pass user
Token(/home/ubuntu/.config/ais/cli/auth.token)

$ # Create bucket as a regular user
$ ais create ais://bck1

$ # Removing a user requires admin's token, pass a path to the token to CLI
$ AIS_AUTHN_TOKEN_FILE=./admin.token ais auth rm user tmpUser1
```

### Revoke a token

When a user's token is compromised, the token should be revoked:

```console
$ # Pass the token in the command line
$ ais auth rm token eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhZG1pbiI6dHJ1Z...

$ # Read the token from a file created by AIS CLI
$ ais auth rm token -f /home/user/user.token
```

## Command List

### Register new user

`ais auth add user [-p USER_PASS] USER_NAME [ROLE [ROLE...]]`

Register a user and assign a list of roles to the user.

If the list of roles is not provided, the new user does not have any permissions.

Bucket access does not necessarily require creating a role. Instead, `admin` can **register a user with an empty role and grant permissions to the required buckets**.

#### Examples

```console
$ ais auth add user -p password user1
$ ais auth add user -p password user2 PowerUser
$ ais auth show user
NAME    ROLES
admin   Admin
user1   -
user2   PowerUser
```

### Update user

`ais auth update user [-p USER_PASS] USER_NAME [ROLE [ROLE...]]`

Updates user password and list of roles. If the role list is omitted, the current
user role remains unchanged.
Changing the role for the built-in account `admin` is forbidden.

### Unregister existing user

`ais auth rm user USER_NAME`

Remove an existing user. The built-in account `admin` cannot be removed.

### List registered users

`ais auth show user [USER [-v]]`

Displays the list of registered users.

```console
$ ais auth show user
NAME    ROLES
admin   Admin
user1   Guest-clu1,Guest-clu2
user2   PowerUser-clu1
```

By default, the user is displayed in short mode.
Option `-v` prints detailed info:

```console
$ ais auth show user user1
NAME    ROLES
user1   Guest-clu

$ ais auth show user user1 -v
Name            test
Roles           Guest-local
CLUSTER ID      ALIAS   PERMISSIONS
k5zAzdhbr       clu     GET,HEAD-OBJECT,HEAD-BUCKET,LIST-OBJECTS
```

### Add a new role

`ais auth add role ROLE_ID PERMISSION [PERMISSION...] [--flags]`

Creates a role and grants the list of permissions to the role.

| Flag | Description | Argument |
| --- | --- | --- |
| `--cluster` | Grants permissions to access and operate on a cluster (scope: cluster) | Cluster ID or alias |
| `--bucket` | Grants permissions to access and operate on a specific bucket (scope: bucket) | Bucket URI (provider and bucket name), e.g. `ais://imagenet` |

If only `--cluster` is defined, the permissions are used as default ones to access *every* bucket in the cluster.

**Note**:

* Flag `--bucket` always requires `--cluster` to be defined.
* `PERMISSION` can be a single compound permission (one of `ro`, `rw`, `su`) or a specific access permission.

Examples:

```console
# Create a role with read-write access to all buckets in the cluster
$ ais auth add role rwRole --cluster clusterOne rw
$ ais auth show role rwRole -v
Role            rwRole
Description
CLUSTER ID      ALIAS        PERMISSIONS
k5zAzdhbr       clusterOne   GET,HEAD-OBJECT,PUT,APPEND,DELETE-OBJECT,MOVE-OBJECT,HEAD-BUCKET,LIST-OBJECTS

# Grant specific permission to a cluster-level role
$ ais auth add role specRole clusterOne GET HEAD-BUCKET LIST-OBJECT
$ ais auth show role specRole -v
Role            specRole
Description
CLUSTER ID      ALIAS        PERMISSIONS
k5zAzdhbr       clusterOne   GET,HEAD-BUCKET,LIST-OBJECTS
```

### List existing roles

`ais auth show role [ROLE]`

Displays existing roles in alphabetical order.

Flags:

| Flag | Type | Description |
| --- | --- | --- |
| `-v` | `bool` | Enables verbose mode. In short mode only role names and their descriptions are displayed. In verbose mode, details about cluster and bucket permissions are shown as well. When `ROLE` is set, verbose mode enables automatically |
| `--cluster` | `string` | Comman-separated list of cluster IDs. Only roles that grants permissions to these clusters or buckets of these clusters are shown |

Note: some roles include "global" permissions - it is roles which are not bound to all clusters.
You can create such role by omitting `--cluster` flag while adding or updating a role.
To list "global" roles, pass a **list** which contains an empty cluster ID.
List that contains only "global" cluster ID is `","`. E.g, `ais auth show role --cluster=,`.

```console
$ ais auth show role
ROLE            DESCRIPTION
Admin           AuthN administrator
BucketOwner     Full access to buckets
Guest           Read-only access to buckets
PowerUser       Full access to cluster
```

By default, the role is displayed in short mode.
Option `-v` prints detailed info:

```console
$ ais auth show role
ROLE            DESCRIPTION
Guest-clu       Read-only access to buckets of cluster k5zAzdhbr[local]

$ ais auth show role -v
Role            Guest-local
Description     Read-only access to buckets of cluster k5zAzdhbr[local]
CLUSTER ID      ALIAS   PERMISSIONS
k5zAzdhbr       local   GET,HEAD-OBJECT,HEAD-BUCKET,LIST-OBJECTS
```

Show all, global, and a single cluster roles:

```console
$ ais auth show role -v
Role              Admin
Description       AuthN administrator

Role              role1
Description
CLUSTER ID        ALIAS    PERMISSIONS
                           GET,HEAD-OBJECT,HEAD-BUCKET,LIST-OBJECTS,LIST-BUCKETS

Role              role2
Description
CLUSTER ID        ALIAS    PERMISSIONS
wRF7CDVbN         clu-tst  GET,HEAD-OBJECT,HEAD-BUCKET,LIST- OBJECTS,LIST-BUCKETS

Role              role3
Description
CLUSTER ID        ALIAS    PERMISSIONS
wRF7CDVbN         clu-tst  GET,HEAD-OBJECT,LIST-OBJECTS

$ ais auth show role --cluster=clu-tst
ROLE      DESCRIPTION
role2
role3

$ ais auth show role --cluster=,
ROLE      DESCRIPTION
role1
```

### Log in to AIS cluster

`ais auth login [-p USER_PASS] USER_NAME [--expire EXPIRATION_TIME]`

Issue a token for a user.
After successful login, the user's token is saved to CLI configuration directory (typically `~/.config/ais/cli/`) under `auth.token` filename.

Subsequent `ais` commands automatically load and use the token for requests to the AIS cluster.
The saved token can be used by other applications, like `curl`.
Please see [AuthN documentation](/docs/authn.md) for how to use AuthN API directly.

By default, the AuthN token expiration is 24 hours.
Use option `-e` or `--expire` to generate a token with custom expiration time.

```console
$ # Generate a token that expires in 5 hours
$ ais auth login -p password username -e 5h

$ # Generate a token that never expires
$ ais auth login -p password username -e 0
```

### Log out

`ais auth logout`

Delete the user's token from a local machine. The token is not revoked, so it can be used by any application until it expires.
To forbid using the token from any application, the token must be revoked manually in addition to logging out.

### Register new cluster

`ais auth add cluster [ALIAS] [URL...]`

If URL is omitted, CLI registers a cluster using its URL from CLI configuration or `AIS_ENDPOINT` variable.
When the URL list is defined, CLI tries to connect the cluster using the first URL from the list.

Register the cluster and assign the list of URLs for sending notifications.
A user may assign an alias to the cluster for convenience: AuthN commands accepts both cluster ID and alias in requests.
Alias must be a unique name.  Alias is an arbitrary name, but it should not start with `http`.
In this case, CLI treats the alias as the URL.

On successful cluster registration, AuthN automatically creates a few predefined unique roles for the cluster: with full access,
read-write access to all its buckets, and read-only access to the cluster.
Please note that the role names include cluster's alias if it was defined. If the alias is omitted, AuthN adds cluster ID to a role name.

See full example in [List registered clusters](#list-registered-clusters).

### Update existing cluster

`ais auth update cluster CLUSTER_ID [ALIAS] URL [URL...]`

Replaces the list of URLs or changes alias for an existing cluster.

### Unregister existing cluster

`ais auth rm cluster CLUSTER_ID`

Remove the existing cluster from the notification list.

### List registered clusters

`ais auth show cluster`

Display the list of the cluster that subscribe to AuthN notifications.

```console
# register a cluster without an alias
$ ais auth add cluster http://172.0.10.10 http://10.0.10.10

# register a cluster with an alias and default URL
$ ais auth add cluster srv1

# check the list of the clusters
$ ais auth show cluster
CLUSTER ID      ALIAS   URLs
2xs35th89               http://172.0.10.10,http://10.0.10.10
78df35690       srv1    http://172.0.10.50

# check the list of generated roles. Note that for convenience,
# the role description includes both ID and alias if appropriate
$ ais auth show role
ROLE                    DESCRIPTION
Admin                   AuthN administrator
BucketOwner-2xs35th89   Full access to buckets of cluster 2xs35th89
BucketOwner-srv1        Full access to buckets of cluster 78df35690[srv1]
ClusterOwner-2xs35th89  Full access to cluster 2xs35th89
ClusterOwner-srv1       Full access to cluster 78df35690[srv1]
Guest-2xs35th89         Read-only access to buckets of cluster 2xs35th89
Guest-srv1              Read-only access to buckets of cluster 78df35690[srv1]
```

### Show AuthN server configuration

`ais auth show config [--json | PREFIX]`

Display the AuthN server configuration in tabular or JSON format.
In tabular output, the prefix filters only properties which names start with it.

```console
$ ais auth show config auth.e
PROPERTY                 VALUE
auth.expiration_time     5h

$ ais auth show config --json
{
    "path": "/home/ubuntu/.authn/authn.json",
    "confdir": "/home/ubuntu/.authn",
    "log": {
        "dir": "/tmp/ais/authn/log",
        "level": "3"
    },
    "net": {
        "http": {
            "port": 52001,
            "use_https": false,
            "server_crt": "server.crt",
            "server_key": "server.key"
        }
    },
    "auth": {
        "secret": "aBitLongSecretKey",
        "expiration_time": "5h"
    },
    "timeout": {
        "default_timeout": "30s"
    }
}

```

### Change AuthN server configuration

`ais auth set config PROP VALUE [PROP VALUE...]`

Update AuthN server configuration.
The command allows updating options that can be changed without AuthN server restart.
New property values can be defined either in `PROPERTY VALUE` or `PROPERTY=VALUE` form.

```console
$ ais auth set config auth.
auth.expiration_time  auth.secret

$ ais auth set config auth.expiration_time 4h
$ ais auth show config auth.e
PROPERTY                 VALUE
auth.expiration_time     4h
```

Do not forget to update the secret on all clusters if you change AuthN secret.
Otherwise, new tokens will be rejected by AIS clusters.
