## Table of Contents
- [`ais tls` command](#ais-tls-command)
- [Cert alerts](#cert-alerts)
- [Show TLS certificate](#show-tls-certificate)
- [Load TLS certificate](#load-tls-certificate)

HTTPS deployment implies (and requires) that each AIS node has a valid TLS (a.k.a. [X.509](https://www.ssl.com/faqs/what-is-an-x-509-certificate/)) certificate.

The latter has a number of interesting properties ultimately intended to authenticate clients (users) to servers (AIS nodes). And vice versa.

In addition, TLS certificates tend to expire from time to time. In fact, each TLS certificate has expiration date with the standard-defined maximum being 13 months (397 days).

> Some sources claim 398 days but the (much) larger point remains: TLS certificates do expire. Which means, they must be periodically updated and timely reloaded.

Starting v3.24, AIStore:

* tracks certificate expiration times;
* automatically - upon update - reloads updated certificates;
* [raises associated alerts](#cert-alerts).

## `ais tls` command

```console
$ ais tls --help
NAME:
   ais tls - load or reload (an updated) TLS certificate; display information about currently deployed certificates

USAGE:
   ais tls command [arguments...] [command options]

COMMANDS:
   show                   show TLS certificate's version, issuer's common name, and from/to validity bounds
   load-certificate       load TLS certificate
   validate-certificates  check that all TLS certificates are identical

OPTIONS:
   --help, -h  show help
```

## Cert alerts

Associated alerts are listed below but first - an example:

```console
$ ais show cluster

PROXY            MEM AVAIL  LOAD AVERAGE    UPTIME      STATUS  ALERT
p[KKFpNjqo][P]   127.77GiB  [5.2 7.2 3.1]   108h30m40s  online  **tls-cert-will-soon-expire**
...

TARGET           MEM AVAIL  CAP USED(%)     CAP AVAIL   LOAD AVERAGE    UPTIME      STATUS  ALERT
t[pDztYhhb]      98.02GiB   16%             960.824GiB  [9.1 13.4 8.3]  108h30m1s  online  **tls-cert-will-soon-expire**
...
...
```

Overall, there are currently 3 (three) related alerts:

| alert | comment |
| -- | -- |
| `tls-cert-will-soon-expire` | a warning that X.509 cert will expire in less than 3 days |
| `tls-cert-expired` | X.509 expired (red alert, as the name implies) |
| `tls-cert-invalid` | e.g., invalid PEM format; further details at [OpenSSL: X.509 errors](https://x509errors.org/)  |

## Show TLS certificate

The command has an optional `NODE` argument - press `<TAB-TAB>` to select.

Otherwise, simply run:

```console
$ ais show tls

PROPERTY                 VALUE
public-key-algorithm     RSA
serial-number            55543812950694702162300597243874591179118407338
signature-algorithm      SHA256-RSA
valid                    from 2024-08-26 18:18:12 to 2025-08-26 18:18:12
version                  3
issued-by (CN)           localhost
```

## Load TLS certificate

By default, all nodes in the cluster with (unconditionlly) reload X.509 certificates from the respective configured locations:

```console
$ ais tls load-certificate

Done: all nodes.
```

But you can also choose any specific node, and ask it to reload. See `ais tls load-certificate --help` for details.

If aistore is deployed with aithentication (enabled), reloading certificates will require administrative permissions.

> See `ais config cluster` command and related `auth.enabled` knob.

### Further references

- [Generating self-signed certificates](/docs/https.md#generating-self-signed-certificates)
- [Deploying: 4 targets, 1 gateway, 6 mountpaths, AWS backend](/docs/https.md#deploying-4-targets-1-gateway-6-mountpaths-aws-backend)
- [Accessing HTTPS-based cluster](/docs/https.md#accessing-https-based-cluster)
- [Testing with self-signed certificates](/docs/https.md#testing-with-self-signed-certificates)
- [Observability: TLS related alerts](/docs/https.md#observability-tls-related-alerts)
- [Updating and reloading X.509 certificates](/docs/https.md#updating-and-reloading-x509-certificates)
- [Switching cluster between HTTP and HTTPS](/docs/https.md#switching-cluster-between-http-and-https)
