# Coyan: A Static Fault Tree Unreliability solver using Weighted Model Counting.

Coyan is a tool that internally translates a Fault Tree in GALILEO format to CNF formula, and if a WMC solver is provided, 
runs the solver obtaining the Unrelaibility of the Fault Tree.

## Build

Create the binary by running:
```bash
cargo build --release -p coyan_fta
```
This creates the binary `/target/release/coyan_fta`.

## Usage

```bash
./target/release/coyan_fta <COMMAND> -i <INPUT> [OPTIONS] 
```

Commands: 
  - `info`: Outputs information about the FT, like the amount of basic events, of gates and the number of clauses generated by the method.
    - OPTIONS:
      - `--simplify                     `: Simplify the FT by removing gates with only one children.
      - `-h, --help                     `: Print help

  - `translate`: Translates the FT implicit formula to a CNF equisatisfiable formula. Outputs a DIMACS file with a wcnf.
    - OPTIONS:
      - `-o, --output <OUTPUT>           `: Output file, writes .cnf or .wcnf depending on the format.
      - `-t, --timebounds <TIMEBOUNDS> <TIMEBOUNDS> <TIMEBOUNDS>`: Tiembounds for the exponential models. It creates a range of values according to the command arguments: `[start, end, step]`. Conflicts with timepoint.
      - `--timepoint <TIMEPOINT>`         : Compute Unrelaiability of the FT a fiven timepoint [default: 1]. Conflicts with timebounds.
      - `--format <FORMAT>               `: Output format for the CNF formula. The format gives the extension to the file. Currently supports MC21 and MCC [default: MC21]
      - `--simplify                      `: Simplify the FT by removing gates with only one children.
      - `--verb                          `: Verbosity, if true, prints more details at finish. Default = false.
      - `-h, --help                      `: Print help

  - `solve`: Executes a Solver to obtain the TEP of the FT at a given timepoint or timebound
    - Supported Solvers: `GPMC` and `ADDMC`.
    - OPTIONS:
      - `-s, --solver-path <SOLVER_PATH> `: Solver path and arguments. If the solver needs arguments, separate them using a colon. Example: `/solvers/gpmc:mode=1`
      - `-t, --timebounds <TIMEBOUNDS> <TIMEBOUNDS> <TIMEBOUNDS>`: Tiembounds for the exponential models. It creates a range of values according to the command arguments: `[start, end, step]`. Conflicts with timepoint.
      - `--timepoint <TIMEPOINT>         `: Compute Unrelaiability of the FT a fiven timepoint [default: 1]. Conflicts with timebounds.
      - `--format <FORMAT>               `: Output format for the CNF formula. Currently supports MC21 and MCC [default: MC21]
      - `--num_threads  <NUM_THREADS>    `: Number of threads to use when timebounds are used [default: 4].
      - `--simplify                      `: Simplify the FT by removing gates with only one children.
      - `--verb                          `: Verbosity, if true, prints more details when finished. Default = false.
      - `-h, --help                      `: Print help

## WMC solvers

Currently, Coyan supports the [GPMC](https://git.trs.css.i.nagoya-u.ac.jp/k-hasimt/GPMC) solver and the [ADDMC](https://github.com/vardigroup/ADDMC). For more details on Model Counting, we refer to the [Model Counting Competition](https://mccompetition.org/).



