/*****************************************************************************
 * pce                                                                       *
 *****************************************************************************/

/*****************************************************************************
 * File name:   src/devices/video/cga_font.h                                 *
 * Created:     2008-10-29 by Hampa Hug <hampa@hampa.ch>                     *
 *****************************************************************************/

/* $Id$ */


#ifndef PCE_VIDEO_CGA_FONT_H
#define PCE_VIDEO_CGA_FONT_H 1


/*
 * CGA thick font
 *
 * (from 5788005 ROM at 0x1800)
 */
static
unsigned char cga_font_thick[256 * 8] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 00 */
	0x7e, 0x81, 0xa5, 0x81, 0xbd, 0x99, 0x81, 0x7e,	/* 01 */
	0x7e, 0xff, 0xdb, 0xff, 0xc3, 0xe7, 0xff, 0x7e,	/* 02 */
	0x6c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00,	/* 03 */
	0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00,	/* 04 */
	0x38, 0x7c, 0x38, 0xfe, 0xfe, 0xd6, 0x10, 0x38,	/* 05 */
	0x10, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x10, 0x38,	/* 06 */
	0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00,	/* 07 */
	0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff,	/* 08 */
	0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00,	/* 09 */
	0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff,	/* 0A */
	0x0f, 0x07, 0x0f, 0x7d, 0xcc, 0xcc, 0xcc, 0x78,	/* 0B */
	0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18,	/* 0C */
	0x3f, 0x33, 0x3f, 0x30, 0x30, 0x70, 0xf0, 0xe0,	/* 0D */
	0x7f, 0x63, 0x7f, 0x63, 0x63, 0x67, 0xe6, 0xc0,	/* 0E */
	0x18, 0xdb, 0x3c, 0xe7, 0xe7, 0x3c, 0xdb, 0x18,	/* 0F */
	0x80, 0xe0, 0xf8, 0xfe, 0xf8, 0xe0, 0x80, 0x00,	/* 10 */
	0x02, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x02, 0x00,	/* 11 */
	0x18, 0x3c, 0x7e, 0x18, 0x18, 0x7e, 0x3c, 0x18,	/* 12 */
	0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00,	/* 13 */
	0x7f, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x00,	/* 14 */
	0x3e, 0x63, 0x38, 0x6c, 0x6c, 0x38, 0xcc, 0x78,	/* 15 */
	0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x00,	/* 16 */
	0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0xff,	/* 17 */
	0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00,	/* 18 */
	0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00,	/* 19 */
	0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00,	/* 1A */
	0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00,	/* 1B */
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00,	/* 1C */
	0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00,	/* 1D */
	0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x00, 0x00,	/* 1E */
	0x00, 0xff, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00,	/* 1F */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 20 */
	0x30, 0x78, 0x78, 0x30, 0x30, 0x00, 0x30, 0x00,	/* 21 */
	0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 22 */
	0x6c, 0x6c, 0xfe, 0x6c, 0xfe, 0x6c, 0x6c, 0x00,	/* 23 */
	0x30, 0x7c, 0xc0, 0x78, 0x0c, 0xf8, 0x30, 0x00,	/* 24 */
	0x00, 0xc6, 0xcc, 0x18, 0x30, 0x66, 0xc6, 0x00,	/* 25 */
	0x38, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0x76, 0x00,	/* 26 */
	0x60, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 27 */
	0x18, 0x30, 0x60, 0x60, 0x60, 0x30, 0x18, 0x00,	/* 28 */
	0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60, 0x00,	/* 29 */
	0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00,	/* 2A */
	0x00, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0x00,	/* 2B */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60,	/* 2C */
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,	/* 2D */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00,	/* 2E */
	0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00,	/* 2F */
	0x7c, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0x7c, 0x00,	/* 30 */
	0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xfc, 0x00,	/* 31 */
	0x78, 0xcc, 0x0c, 0x38, 0x60, 0xcc, 0xfc, 0x00,	/* 32 */
	0x78, 0xcc, 0x0c, 0x38, 0x0c, 0xcc, 0x78, 0x00,	/* 33 */
	0x1c, 0x3c, 0x6c, 0xcc, 0xfe, 0x0c, 0x1e, 0x00,	/* 34 */
	0xfc, 0xc0, 0xf8, 0x0c, 0x0c, 0xcc, 0x78, 0x00,	/* 35 */
	0x38, 0x60, 0xc0, 0xf8, 0xcc, 0xcc, 0x78, 0x00,	/* 36 */
	0xfc, 0xcc, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x00,	/* 37 */
	0x78, 0xcc, 0xcc, 0x78, 0xcc, 0xcc, 0x78, 0x00,	/* 38 */
	0x78, 0xcc, 0xcc, 0x7c, 0x0c, 0x18, 0x70, 0x00,	/* 39 */
	0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00,	/* 3A */
	0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x60,	/* 3B */
	0x18, 0x30, 0x60, 0xc0, 0x60, 0x30, 0x18, 0x00,	/* 3C */
	0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00,	/* 3D */
	0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00,	/* 3E */
	0x78, 0xcc, 0x0c, 0x18, 0x30, 0x00, 0x30, 0x00,	/* 3F */
	0x7c, 0xc6, 0xde, 0xde, 0xde, 0xc0, 0x78, 0x00,	/* 40 */
	0x30, 0x78, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0x00,	/* 41 */
	0xfc, 0x66, 0x66, 0x7c, 0x66, 0x66, 0xfc, 0x00,	/* 42 */
	0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0x66, 0x3c, 0x00,	/* 43 */
	0xf8, 0x6c, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00,	/* 44 */
	0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00,	/* 45 */
	0xfe, 0x62, 0x68, 0x78, 0x68, 0x60, 0xf0, 0x00,	/* 46 */
	0x3c, 0x66, 0xc0, 0xc0, 0xce, 0x66, 0x3e, 0x00,	/* 47 */
	0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00,	/* 48 */
	0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 49 */
	0x1e, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78, 0x00,	/* 4A */
	0xe6, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0xe6, 0x00,	/* 4B */
	0xf0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00,	/* 4C */
	0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0x00,	/* 4D */
	0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0x00,	/* 4E */
	0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00,	/* 4F */
	0xfc, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00,	/* 50 */
	0x78, 0xcc, 0xcc, 0xcc, 0xdc, 0x78, 0x1c, 0x00,	/* 51 */
	0xfc, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0xe6, 0x00,	/* 52 */
	0x78, 0xcc, 0x60, 0x30, 0x18, 0xcc, 0x78, 0x00,	/* 53 */
	0xfc, 0xb4, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 54 */
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xfc, 0x00,	/* 55 */
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x00,	/* 56 */
	0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00,	/* 57 */
	0xc6, 0xc6, 0x6c, 0x38, 0x38, 0x6c, 0xc6, 0x00,	/* 58 */
	0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x30, 0x78, 0x00,	/* 59 */
	0xfe, 0xc6, 0x8c, 0x18, 0x32, 0x66, 0xfe, 0x00,	/* 5A */
	0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x00,	/* 5B */
	0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x02, 0x00,	/* 5C */
	0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00,	/* 5D */
	0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00,	/* 5E */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* 5F */
	0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 60 */
	0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00,	/* 61 */
	0xe0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0xdc, 0x00,	/* 62 */
	0x00, 0x00, 0x78, 0xcc, 0xc0, 0xcc, 0x78, 0x00,	/* 63 */
	0x1c, 0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0x76, 0x00,	/* 64 */
	0x00, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00,	/* 65 */
	0x38, 0x6c, 0x60, 0xf0, 0x60, 0x60, 0xf0, 0x00,	/* 66 */
	0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8,	/* 67 */
	0xe0, 0x60, 0x6c, 0x76, 0x66, 0x66, 0xe6, 0x00,	/* 68 */
	0x30, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 69 */
	0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78,	/* 6A */
	0xe0, 0x60, 0x66, 0x6c, 0x78, 0x6c, 0xe6, 0x00,	/* 6B */
	0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 6C */
	0x00, 0x00, 0xcc, 0xfe, 0xfe, 0xd6, 0xc6, 0x00,	/* 6D */
	0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0x00,	/* 6E */
	0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00,	/* 6F */
	0x00, 0x00, 0xdc, 0x66, 0x66, 0x7c, 0x60, 0xf0,	/* 70 */
	0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0x1e,	/* 71 */
	0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0xf0, 0x00,	/* 72 */
	0x00, 0x00, 0x7c, 0xc0, 0x78, 0x0c, 0xf8, 0x00,	/* 73 */
	0x10, 0x30, 0x7c, 0x30, 0x30, 0x34, 0x18, 0x00,	/* 74 */
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00,	/* 75 */
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x78, 0x30, 0x00,	/* 76 */
	0x00, 0x00, 0xc6, 0xd6, 0xfe, 0xfe, 0x6c, 0x00,	/* 77 */
	0x00, 0x00, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0x00,	/* 78 */
	0x00, 0x00, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8,	/* 79 */
	0x00, 0x00, 0xfc, 0x98, 0x30, 0x64, 0xfc, 0x00,	/* 7A */
	0x1c, 0x30, 0x30, 0xe0, 0x30, 0x30, 0x1c, 0x00,	/* 7B */
	0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00,	/* 7C */
	0xe0, 0x30, 0x30, 0x1c, 0x30, 0x30, 0xe0, 0x00,	/* 7D */
	0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 7E */
	0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0x00,	/* 7F */
	0x78, 0xcc, 0xc0, 0xcc, 0x78, 0x18, 0x0c, 0x78,	/* 80 */
	0x00, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00,	/* 81 */
	0x1c, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00,	/* 82 */
	0x7e, 0xc3, 0x3c, 0x06, 0x3e, 0x66, 0x3f, 0x00,	/* 83 */
	0xcc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00,	/* 84 */
	0xe0, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00,	/* 85 */
	0x30, 0x30, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00,	/* 86 */
	0x00, 0x00, 0x78, 0xc0, 0xc0, 0x78, 0x0c, 0x38,	/* 87 */
	0x7e, 0xc3, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00,	/* 88 */
	0xcc, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00,	/* 89 */
	0xe0, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00,	/* 8A */
	0xcc, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 8B */
	0x7c, 0xc6, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00,	/* 8C */
	0xe0, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 8D */
	0xc6, 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00,	/* 8E */
	0x30, 0x30, 0x00, 0x78, 0xcc, 0xfc, 0xcc, 0x00,	/* 8F */
	0x1c, 0x00, 0xfc, 0x60, 0x78, 0x60, 0xfc, 0x00,	/* 90 */
	0x00, 0x00, 0x7f, 0x0c, 0x7f, 0xcc, 0x7f, 0x00,	/* 91 */
	0x3e, 0x6c, 0xcc, 0xfe, 0xcc, 0xcc, 0xce, 0x00,	/* 92 */
	0x78, 0xcc, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00,	/* 93 */
	0x00, 0xcc, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00,	/* 94 */
	0x00, 0xe0, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00,	/* 95 */
	0x78, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00,	/* 96 */
	0x00, 0xe0, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00,	/* 97 */
	0x00, 0xcc, 0x00, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8,	/* 98 */
	0xc3, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x00,	/* 99 */
	0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00,	/* 9A */
	0x18, 0x18, 0x7e, 0xc0, 0xc0, 0x7e, 0x18, 0x18,	/* 9B */
	0x38, 0x6c, 0x64, 0xf0, 0x60, 0xe6, 0xfc, 0x00,	/* 9C */
	0xcc, 0xcc, 0x78, 0xfc, 0x30, 0xfc, 0x30, 0x30,	/* 9D */
	0xf8, 0xcc, 0xcc, 0xfa, 0xc6, 0xcf, 0xc6, 0xc7,	/* 9E */
	0x0e, 0x1b, 0x18, 0x3c, 0x18, 0x18, 0xd8, 0x70,	/* 9F */
	0x1c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00,	/* A0 */
	0x38, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00,	/* A1 */
	0x00, 0x1c, 0x00, 0x78, 0xcc, 0xcc, 0x78, 0x00,	/* A2 */
	0x00, 0x1c, 0x00, 0xcc, 0xcc, 0xcc, 0x7e, 0x00,	/* A3 */
	0x00, 0xf8, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0x00,	/* A4 */
	0xfc, 0x00, 0xcc, 0xec, 0xfc, 0xdc, 0xcc, 0x00,	/* A5 */
	0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00,	/* A6 */
	0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00,	/* A7 */
	0x30, 0x00, 0x30, 0x60, 0xc0, 0xcc, 0x78, 0x00,	/* A8 */
	0x00, 0x00, 0x00, 0xfc, 0xc0, 0xc0, 0x00, 0x00,	/* A9 */
	0x00, 0x00, 0x00, 0xfc, 0x0c, 0x0c, 0x00, 0x00,	/* AA */
	0xc3, 0xc6, 0xcc, 0xde, 0x33, 0x66, 0xcc, 0x0f,	/* AB */
	0xc3, 0xc6, 0xcc, 0xdb, 0x37, 0x6f, 0xcf, 0x03,	/* AC */
	0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00,	/* AD */
	0x00, 0x33, 0x66, 0xcc, 0x66, 0x33, 0x00, 0x00,	/* AE */
	0x00, 0xcc, 0x66, 0x33, 0x66, 0xcc, 0x00, 0x00,	/* AF */
	0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88,	/* B0 */
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,	/* B1 */
	0xdb, 0x77, 0xdb, 0xee, 0xdb, 0x77, 0xdb, 0xee,	/* B2 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* B3 */
	0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18,	/* B4 */
	0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18,	/* B5 */
	0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36,	/* B6 */
	0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36,	/* B7 */
	0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18,	/* B8 */
	0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36,	/* B9 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,	/* BA */
	0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36,	/* BB */
	0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00,	/* BC */
	0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00,	/* BD */
	0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00,	/* BE */
	0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18,	/* BF */
	0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00,	/* C0 */
	0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00,	/* C1 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18,	/* C2 */
	0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18,	/* C3 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,	/* C4 */
	0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18,	/* C5 */
	0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18,	/* C6 */
	0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36,	/* C7 */
	0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00,	/* C8 */
	0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36,	/* C9 */
	0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00,	/* CA */
	0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36,	/* CB */
	0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36,	/* CC */
	0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,	/* CD */
	0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36,	/* CE */
	0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,	/* CF */
	0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00,	/* D0 */
	0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18,	/* D1 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36,	/* D2 */
	0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00,	/* D3 */
	0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00,	/* D4 */
	0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18,	/* D5 */
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36,	/* D6 */
	0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36,	/* D7 */
	0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18,	/* D8 */
	0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00,	/* D9 */
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18,	/* DA */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* DB */
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,	/* DC */
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,	/* DD */
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,	/* DE */
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,	/* DF */
	0x00, 0x00, 0x76, 0xdc, 0xc8, 0xdc, 0x76, 0x00,	/* E0 */
	0x00, 0x78, 0xcc, 0xf8, 0xcc, 0xf8, 0xc0, 0xc0,	/* E1 */
	0x00, 0xfc, 0xcc, 0xc0, 0xc0, 0xc0, 0xc0, 0x00,	/* E2 */
	0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00,	/* E3 */
	0xfc, 0xcc, 0x60, 0x30, 0x60, 0xcc, 0xfc, 0x00,	/* E4 */
	0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0x70, 0x00,	/* E5 */
	0x00, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0xc0,	/* E6 */
	0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x00,	/* E7 */
	0xfc, 0x30, 0x78, 0xcc, 0xcc, 0x78, 0x30, 0xfc,	/* E8 */
	0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0x6c, 0x38, 0x00,	/* E9 */
	0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x6c, 0xee, 0x00,	/* EA */
	0x1c, 0x30, 0x18, 0x7c, 0xcc, 0xcc, 0x78, 0x00,	/* EB */
	0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00,	/* EC */
	0x06, 0x0c, 0x7e, 0xdb, 0xdb, 0x7e, 0x60, 0xc0,	/* ED */
	0x38, 0x60, 0xc0, 0xf8, 0xc0, 0x60, 0x38, 0x00,	/* EE */
	0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00,	/* EF */
	0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x00,	/* F0 */
	0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0xfc, 0x00,	/* F1 */
	0x60, 0x30, 0x18, 0x30, 0x60, 0x00, 0xfc, 0x00,	/* F2 */
	0x18, 0x30, 0x60, 0x30, 0x18, 0x00, 0xfc, 0x00,	/* F3 */
	0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18,	/* F4 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x70,	/* F5 */
	0x30, 0x30, 0x00, 0xfc, 0x00, 0x30, 0x30, 0x00,	/* F6 */
	0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00,	/* F7 */
	0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00,	/* F8 */
	0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,	/* F9 */
	0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,	/* FA */
	0x0f, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x3c, 0x1c,	/* FB */
	0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00,	/* FC */
	0x70, 0x18, 0x30, 0x60, 0x78, 0x00, 0x00, 0x00,	/* FD */
	0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00,	/* FE */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	/* FF */
};


/*
 * CGA thin font
 *
 * (from 5788005 ROM at 0x1000)
 */
static
unsigned char cga_font_thin[8 * 256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 00 */
	0x7e, 0x81, 0xa5, 0x81, 0xbd, 0x99, 0x81, 0x7e,	/* 01 */
	0x7e, 0xff, 0xdb, 0xff, 0xc3, 0xe7, 0xff, 0x7e,	/* 02 */
	0x6c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00,	/* 03 */
	0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00,	/* 04 */
	0x38, 0x7c, 0x38, 0xfe, 0xfe, 0xd6, 0x10, 0x38,	/* 05 */
	0x10, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x10, 0x38,	/* 06 */
	0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00,	/* 07 */
	0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff,	/* 08 */
	0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00,	/* 09 */
	0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff,	/* 0A */
	0x0f, 0x03, 0x05, 0x7d, 0x84, 0x84, 0x84, 0x78,	/* 0B */
	0x3c, 0x42, 0x42, 0x42, 0x3c, 0x18, 0x7e, 0x18,	/* 0C */
	0x3f, 0x21, 0x3f, 0x20, 0x20, 0x60, 0xe0, 0xc0,	/* 0D */
	0x3f, 0x21, 0x3f, 0x21, 0x23, 0x67, 0xe6, 0xc0,	/* 0E */
	0x18, 0xdb, 0x3c, 0xe7, 0xe7, 0x3c, 0xdb, 0x18,	/* 0F */
	0x80, 0xe0, 0xf8, 0xfe, 0xf8, 0xe0, 0x80, 0x00,	/* 10 */
	0x02, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x02, 0x00,	/* 11 */
	0x18, 0x3c, 0x7e, 0x18, 0x18, 0x7e, 0x3c, 0x18,	/* 12 */
	0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x24, 0x00,	/* 13 */
	0x7f, 0x92, 0x92, 0x72, 0x12, 0x12, 0x12, 0x00,	/* 14 */
	0x3e, 0x63, 0x38, 0x44, 0x44, 0x38, 0xcc, 0x78,	/* 15 */
	0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x00,	/* 16 */
	0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0xff,	/* 17 */
	0x10, 0x38, 0x7c, 0x54, 0x10, 0x10, 0x10, 0x00,	/* 18 */
	0x10, 0x10, 0x10, 0x54, 0x7c, 0x38, 0x10, 0x00,	/* 19 */
	0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00,	/* 1A */
	0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00,	/* 1B */
	0x00, 0x00, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00,	/* 1C */
	0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00,	/* 1D */
	0x00, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0x00, 0x00,	/* 1E */
	0x00, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00,	/* 1F */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 20 */
	0x10, 0x38, 0x38, 0x10, 0x10, 0x00, 0x10, 0x00,	/* 21 */
	0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 22 */
	0x24, 0x24, 0x7e, 0x24, 0x7e, 0x24, 0x24, 0x00,	/* 23 */
	0x18, 0x3e, 0x40, 0x3c, 0x02, 0x7c, 0x18, 0x00,	/* 24 */
	0x00, 0x62, 0x64, 0x08, 0x10, 0x26, 0x46, 0x00,	/* 25 */
	0x30, 0x48, 0x30, 0x56, 0x88, 0x88, 0x76, 0x00,	/* 26 */
	0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 27 */
	0x10, 0x20, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00,	/* 28 */
	0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00,	/* 29 */
	0x00, 0x44, 0x38, 0xfe, 0x38, 0x44, 0x00, 0x00,	/* 2A */
	0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00,	/* 2B */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20,	/* 2C */
	0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,	/* 2D */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00,	/* 2E */
	0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00,	/* 2F */
	0x3c, 0x42, 0x46, 0x4a, 0x52, 0x62, 0x3c, 0x00,	/* 30 */
	0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x7c, 0x00,	/* 31 */
	0x3c, 0x42, 0x02, 0x0c, 0x30, 0x42, 0x7e, 0x00,	/* 32 */
	0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00,	/* 33 */
	0x08, 0x18, 0x28, 0x48, 0xfe, 0x08, 0x1c, 0x00,	/* 34 */
	0x7e, 0x40, 0x7c, 0x02, 0x02, 0x42, 0x3c, 0x00,	/* 35 */
	0x1c, 0x20, 0x40, 0x7c, 0x42, 0x42, 0x3c, 0x00,	/* 36 */
	0x7e, 0x42, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00,	/* 37 */
	0x3c, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x3c, 0x00,	/* 38 */
	0x3c, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x38, 0x00,	/* 39 */
	0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00,	/* 3A */
	0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x20,	/* 3B */
	0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00,	/* 3C */
	0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00,	/* 3D */
	0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00,	/* 3E */
	0x3c, 0x42, 0x02, 0x04, 0x08, 0x00, 0x08, 0x00,	/* 3F */
	0x3c, 0x42, 0x5e, 0x52, 0x5e, 0x40, 0x3c, 0x00,	/* 40 */
	0x18, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x00,	/* 41 */
	0x7c, 0x22, 0x22, 0x3c, 0x22, 0x22, 0x7c, 0x00,	/* 42 */
	0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00,	/* 43 */
	0x78, 0x24, 0x22, 0x22, 0x22, 0x24, 0x78, 0x00,	/* 44 */
	0x7e, 0x22, 0x28, 0x38, 0x28, 0x22, 0x7e, 0x00,	/* 45 */
	0x7e, 0x22, 0x28, 0x38, 0x28, 0x20, 0x70, 0x00,	/* 46 */
	0x1c, 0x22, 0x40, 0x40, 0x4e, 0x22, 0x1e, 0x00,	/* 47 */
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00,	/* 48 */
	0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00,	/* 49 */
	0x0e, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00,	/* 4A */
	0x62, 0x24, 0x28, 0x30, 0x28, 0x24, 0x63, 0x00,	/* 4B */
	0x70, 0x20, 0x20, 0x20, 0x20, 0x22, 0x7e, 0x00,	/* 4C */
	0x63, 0x55, 0x49, 0x41, 0x41, 0x41, 0x41, 0x00,	/* 4D */
	0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x00,	/* 4E */
	0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00,	/* 4F */
	0x7c, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x70, 0x00,	/* 50 */
	0x3c, 0x42, 0x42, 0x42, 0x4a, 0x3c, 0x03, 0x00,	/* 51 */
	0x7c, 0x22, 0x22, 0x3c, 0x28, 0x24, 0x72, 0x00,	/* 52 */
	0x3c, 0x42, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00,	/* 53 */
	0x7f, 0x49, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00,	/* 54 */
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00,	/* 55 */
	0x41, 0x41, 0x41, 0x41, 0x22, 0x14, 0x08, 0x00,	/* 56 */
	0x41, 0x41, 0x41, 0x49, 0x49, 0x49, 0x36, 0x00,	/* 57 */
	0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00,	/* 58 */
	0x41, 0x22, 0x14, 0x08, 0x08, 0x08, 0x1c, 0x00,	/* 59 */
	0x7f, 0x42, 0x04, 0x08, 0x10, 0x21, 0x7f, 0x00,	/* 5A */
	0x78, 0x40, 0x40, 0x40, 0x40, 0x40, 0x78, 0x00,	/* 5B */
	0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00,	/* 5C */
	0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00,	/* 5D */
	0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00,	/* 5E */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* 5F */
	0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 60 */
	0x00, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x3f, 0x00,	/* 61 */
	0x60, 0x20, 0x20, 0x2e, 0x31, 0x31, 0x2e, 0x00,	/* 62 */
	0x00, 0x00, 0x3c, 0x42, 0x40, 0x42, 0x3c, 0x00,	/* 63 */
	0x06, 0x02, 0x02, 0x3a, 0x46, 0x46, 0x3b, 0x00,	/* 64 */
	0x00, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00,	/* 65 */
	0x0c, 0x12, 0x10, 0x38, 0x10, 0x10, 0x38, 0x00,	/* 66 */
	0x00, 0x00, 0x3d, 0x42, 0x42, 0x3e, 0x02, 0x7c,	/* 67 */
	0x60, 0x20, 0x2c, 0x32, 0x22, 0x22, 0x62, 0x00,	/* 68 */
	0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00,	/* 69 */
	0x02, 0x00, 0x06, 0x02, 0x02, 0x42, 0x42, 0x3c,	/* 6A */
	0x60, 0x20, 0x24, 0x28, 0x30, 0x28, 0x26, 0x00,	/* 6B */
	0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00,	/* 6C */
	0x00, 0x00, 0x76, 0x49, 0x49, 0x49, 0x49, 0x00,	/* 6D */
	0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x00,	/* 6E */
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x00,	/* 6F */
	0x00, 0x00, 0x6c, 0x32, 0x32, 0x2c, 0x20, 0x70,	/* 70 */
	0x00, 0x00, 0x36, 0x4c, 0x4c, 0x34, 0x04, 0x0e,	/* 71 */
	0x00, 0x00, 0x6c, 0x32, 0x22, 0x20, 0x70, 0x00,	/* 72 */
	0x00, 0x00, 0x3e, 0x40, 0x3c, 0x02, 0x7c, 0x00,	/* 73 */
	0x10, 0x10, 0x7c, 0x10, 0x10, 0x12, 0x0c, 0x00,	/* 74 */
	0x00, 0x00, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00,	/* 75 */
	0x00, 0x00, 0x41, 0x41, 0x22, 0x14, 0x08, 0x00,	/* 76 */
	0x00, 0x00, 0x41, 0x49, 0x49, 0x49, 0x36, 0x00,	/* 77 */
	0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00,	/* 78 */
	0x00, 0x00, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x7c,	/* 79 */
	0x00, 0x00, 0x7c, 0x08, 0x10, 0x20, 0x7c, 0x00,	/* 7A */
	0x0c, 0x10, 0x10, 0x60, 0x10, 0x10, 0x0c, 0x00,	/* 7B */
	0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00,	/* 7C */
	0x30, 0x08, 0x08, 0x06, 0x08, 0x08, 0x30, 0x00,	/* 7D */
	0x32, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 7E */
	0x00, 0x08, 0x14, 0x22, 0x41, 0x41, 0x7f, 0x00,	/* 7F */
	0x3c, 0x42, 0x40, 0x42, 0x3c, 0x0c, 0x02, 0x3c,	/* 80 */
	0x00, 0x44, 0x00, 0x44, 0x44, 0x44, 0x3e, 0x00,	/* 81 */
	0x0c, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00,	/* 82 */
	0x3c, 0x42, 0x38, 0x04, 0x3c, 0x44, 0x3e, 0x00,	/* 83 */
	0x42, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3e, 0x00,	/* 84 */
	0x30, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3e, 0x00,	/* 85 */
	0x10, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3e, 0x00,	/* 86 */
	0x00, 0x00, 0x3c, 0x40, 0x40, 0x3c, 0x06, 0x1c,	/* 87 */
	0x3c, 0x42, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00,	/* 88 */
	0x42, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00,	/* 89 */
	0x30, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00,	/* 8A */
	0x24, 0x00, 0x18, 0x08, 0x08, 0x08, 0x1c, 0x00,	/* 8B */
	0x7c, 0x82, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00,	/* 8C */
	0x30, 0x00, 0x18, 0x08, 0x08, 0x08, 0x1c, 0x00,	/* 8D */
	0x42, 0x18, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x00,	/* 8E */
	0x18, 0x18, 0x00, 0x3c, 0x42, 0x7e, 0x42, 0x00,	/* 8F */
	0x0c, 0x00, 0x7c, 0x20, 0x38, 0x20, 0x7c, 0x00,	/* 90 */
	0x00, 0x00, 0x33, 0x0c, 0x3f, 0x44, 0x3b, 0x00,	/* 91 */
	0x1f, 0x24, 0x44, 0x7f, 0x44, 0x44, 0x47, 0x00,	/* 92 */
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x00,	/* 93 */
	0x00, 0x42, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x00,	/* 94 */
	0x20, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x00,	/* 95 */
	0x18, 0x24, 0x00, 0x42, 0x42, 0x42, 0x3c, 0x00,	/* 96 */
	0x20, 0x10, 0x00, 0x42, 0x42, 0x42, 0x3c, 0x00,	/* 97 */
	0x00, 0x42, 0x00, 0x42, 0x42, 0x3e, 0x02, 0x3c,	/* 98 */
	0x42, 0x18, 0x24, 0x42, 0x42, 0x24, 0x18, 0x00,	/* 99 */
	0x42, 0x00, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00,	/* 9A */
	0x08, 0x08, 0x3e, 0x40, 0x40, 0x3e, 0x08, 0x08,	/* 9B */
	0x18, 0x24, 0x20, 0x70, 0x20, 0x42, 0x7c, 0x00,	/* 9C */
	0x44, 0x28, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x00,	/* 9D */
	0xf8, 0x4c, 0x78, 0x44, 0x4f, 0x44, 0x45, 0xe6,	/* 9E */
	0x1c, 0x12, 0x10, 0x7c, 0x10, 0x10, 0x90, 0x60,	/* 9F */
	0x0c, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3e, 0x00,	/* A0 */
	0x0c, 0x00, 0x18, 0x08, 0x08, 0x08, 0x1c, 0x00,	/* A1 */
	0x04, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x00,	/* A2 */
	0x00, 0x04, 0x08, 0x42, 0x42, 0x42, 0x3c, 0x00,	/* A3 */
	0x32, 0x4c, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x00,	/* A4 */
	0x34, 0x4c, 0x00, 0x62, 0x52, 0x4a, 0x46, 0x00,	/* A5 */
	0x3c, 0x44, 0x44, 0x3e, 0x00, 0x7e, 0x00, 0x00,	/* A6 */
	0x38, 0x44, 0x44, 0x38, 0x00, 0x7c, 0x00, 0x00,	/* A7 */
	0x10, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3c, 0x00,	/* A8 */
	0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x00, 0x00,	/* A9 */
	0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x00, 0x00,	/* AA */
	0x42, 0xc4, 0x48, 0xf6, 0x29, 0x43, 0x8c, 0x1f,	/* AB */
	0x42, 0xc4, 0x4a, 0xf6, 0x2a, 0x5f, 0x82, 0x02,	/* AC */
	0x00, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00,	/* AD */
	0x00, 0x12, 0x24, 0x48, 0x24, 0x12, 0x00, 0x00,	/* AE */
	0x00, 0x48, 0x24, 0x12, 0x24, 0x48, 0x00, 0x00,	/* AF */
	0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88,	/* B0 */
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,	/* B1 */
	0xdb, 0x77, 0xdb, 0xee, 0xdb, 0x77, 0xdb, 0xee,	/* B2 */
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,	/* B3 */
	0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10,	/* B4 */
	0x10, 0x10, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10,	/* B5 */
	0x14, 0x14, 0x14, 0x14, 0xf4, 0x14, 0x14, 0x14,	/* B6 */
	0x00, 0x00, 0x00, 0x00, 0xfc, 0x14, 0x14, 0x14,	/* B7 */
	0x00, 0x00, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10,	/* B8 */
	0x14, 0x14, 0xf4, 0x04, 0xf4, 0x14, 0x14, 0x14,	/* B9 */
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,	/* BA */
	0x00, 0x00, 0xfc, 0x04, 0xf4, 0x14, 0x14, 0x14,	/* BB */
	0x14, 0x14, 0xf4, 0x04, 0xfc, 0x00, 0x00, 0x00,	/* BC */
	0x14, 0x14, 0x14, 0x14, 0xfc, 0x00, 0x00, 0x00,	/* BD */
	0x10, 0x10, 0xf0, 0x10, 0xf0, 0x00, 0x00, 0x00,	/* BE */
	0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10,	/* BF */
	0x10, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00,	/* C0 */
	0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00,	/* C1 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x10, 0x10,	/* C2 */
	0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x10,	/* C3 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,	/* C4 */
	0x10, 0x10, 0x10, 0x10, 0xff, 0x10, 0x10, 0x10,	/* C5 */
	0x10, 0x10, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10,	/* C6 */
	0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x14, 0x14,	/* C7 */
	0x14, 0x14, 0x17, 0x10, 0x1f, 0x00, 0x00, 0x00,	/* C8 */
	0x00, 0x00, 0x1f, 0x10, 0x17, 0x14, 0x14, 0x14,	/* C9 */
	0x14, 0x14, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00,	/* CA */
	0x00, 0x00, 0xff, 0x00, 0xf7, 0x14, 0x14, 0x14,	/* CB */
	0x14, 0x14, 0x17, 0x10, 0x17, 0x14, 0x14, 0x14,	/* CC */
	0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,	/* CD */
	0x14, 0x14, 0xf7, 0x00, 0xf7, 0x14, 0x14, 0x14,	/* CE */
	0x10, 0x10, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,	/* CF */
	0x14, 0x14, 0x14, 0x14, 0xff, 0x00, 0x00, 0x00,	/* D0 */
	0x00, 0x00, 0xff, 0x00, 0xff, 0x10, 0x10, 0x10,	/* D1 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x14, 0x14, 0x14,	/* D2 */
	0x14, 0x14, 0x14, 0x14, 0x1f, 0x00, 0x00, 0x00,	/* D3 */
	0x10, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, 0x00,	/* D4 */
	0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10,	/* D5 */
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x14, 0x14, 0x14,	/* D6 */
	0x14, 0x14, 0x14, 0x14, 0xff, 0x14, 0x14, 0x14,	/* D7 */
	0x10, 0x10, 0xff, 0x10, 0xff, 0x10, 0x10, 0x10,	/* D8 */
	0x10, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00,	/* D9 */
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10,	/* DA */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* DB */
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,	/* DC */
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,	/* DD */
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,	/* DE */
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,	/* DF */
	0x00, 0x00, 0x31, 0x4a, 0x44, 0x4a, 0x31, 0x00,	/* E0 */
	0x00, 0x3c, 0x42, 0x7c, 0x42, 0x7c, 0x40, 0x40,	/* E1 */
	0x00, 0x7e, 0x42, 0x40, 0x40, 0x40, 0x40, 0x00,	/* E2 */
	0x00, 0x3f, 0x54, 0x14, 0x14, 0x14, 0x14, 0x00,	/* E3 */
	0x7e, 0x42, 0x20, 0x18, 0x20, 0x42, 0x7e, 0x00,	/* E4 */
	0x00, 0x00, 0x3e, 0x48, 0x48, 0x48, 0x30, 0x00,	/* E5 */
	0x00, 0x44, 0x44, 0x44, 0x7a, 0x40, 0x40, 0x80,	/* E6 */
	0x00, 0x33, 0x4c, 0x08, 0x08, 0x08, 0x08, 0x00,	/* E7 */
	0x7c, 0x10, 0x38, 0x44, 0x44, 0x38, 0x10, 0x7c,	/* E8 */
	0x18, 0x24, 0x42, 0x7e, 0x42, 0x24, 0x18, 0x00,	/* E9 */
	0x18, 0x24, 0x42, 0x42, 0x24, 0x24, 0x66, 0x00,	/* EA */
	0x1c, 0x20, 0x18, 0x3c, 0x42, 0x42, 0x3c, 0x00,	/* EB */
	0x00, 0x62, 0x95, 0x89, 0x95, 0x62, 0x00, 0x00,	/* EC */
	0x02, 0x04, 0x3c, 0x4a, 0x52, 0x3c, 0x40, 0x80,	/* ED */
	0x0c, 0x10, 0x20, 0x3c, 0x20, 0x10, 0x0c, 0x00,	/* EE */
	0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00,	/* EF */
	0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00,	/* F0 */
	0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x7c, 0x00,	/* F1 */
	0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x7e, 0x00,	/* F2 */
	0x08, 0x10, 0x20, 0x10, 0x08, 0x00, 0x7e, 0x00,	/* F3 */
	0x0c, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10,	/* F4 */
	0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x90, 0x60,	/* F5 */
	0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00,	/* F6 */
	0x00, 0x32, 0x4c, 0x00, 0x32, 0x4c, 0x00, 0x00,	/* F7 */
	0x30, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00,	/* F8 */
	0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,	/* F9 */
	0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,	/* FA */
	0x0f, 0x08, 0x08, 0x08, 0x08, 0xc8, 0x28, 0x18,	/* FB */
	0x78, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00,	/* FC */
	0x30, 0x48, 0x10, 0x20, 0x78, 0x00, 0x00, 0x00,	/* FD */
	0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00,	/* FE */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	/* FF */
};


#endif
