/*****************************************************************************
 * pce                                                                       *
 *****************************************************************************/

/*****************************************************************************
 * File name:   src/devices/video/mda_font.h                                 *
 * Created:     2008-10-29 by Hampa Hug <hampa@hampa.ch>                     *
 *****************************************************************************/

/* $Id$ */


#ifndef PCE_VIDEO_MDA_FONT_H
#define PCE_VIDEO_MDA_FONT_H 1


/*
 * MDA 8*14 font
 *
 * (from 5788005 ROM at 0x0000)
 */
static
unsigned char mda_font_8x14[256 * 14] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 00 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd,	/* 01 */
	0x99, 0x81, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3,	/* 02 */
	0xe7, 0xff, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f,	/* 03 */
	0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x3e,	/* 04 */
	0x1c, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7,	/* 05 */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e,	/* 06 */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c,	/* 07 */
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3,	/* 08 */
	0xe7, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42,	/* 09 */
	0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd,	/* 0A */
	0x99, 0xc3, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x0f, 0x07, 0x0d, 0x19, 0x3c, 0x66,	/* 0B */
	0x66, 0x66, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18,	/* 0C */
	0x7e, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0x33, 0x3f, 0x30, 0x30, 0x30,	/* 0D */
	0x70, 0xf0, 0xe0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x63,	/* 0E */
	0x67, 0xe7, 0xe6, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7, 0x3c,	/* 0F */
	0xdb, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x60, 0x70, 0x7c, 0x7f, 0x7c,	/* 10 */
	0x70, 0x60, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x03, 0x07, 0x1f, 0x7f, 0x1f,	/* 11 */
	0x07, 0x03, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,	/* 12 */
	0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,	/* 13 */
	0x00, 0x33, 0x33, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b,	/* 14 */
	0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x3e, 0x63, 0x30, 0x1c, 0x36, 0x63, 0x63,	/* 15 */
	0x36, 0x1c, 0x06, 0x63, 0x3e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 16 */
	0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,	/* 17 */
	0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,	/* 18 */
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* 19 */
	0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x7f, 0x06,	/* 1A */
	0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x7f, 0x30,	/* 1B */
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60,	/* 1C */
	0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0x66,	/* 1D */
	0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e,	/* 1E */
	0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e, 0x1c,	/* 1F */
	0x1c, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 20 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18,	/* 21 */
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x63, 0x63, 0x63, 0x22, 0x00, 0x00, 0x00,	/* 22 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x36,	/* 23 */
	0x7f, 0x36, 0x36, 0x00, 0x00, 0x00,
	0x0c, 0x0c, 0x3e, 0x63, 0x61, 0x60, 0x3e, 0x03,	/* 24 */
	0x43, 0x63, 0x3e, 0x0c, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x61, 0x63, 0x06, 0x0c,	/* 25 */
	0x18, 0x33, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x3b, 0x6e,	/* 26 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00,	/* 27 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30,	/* 28 */
	0x30, 0x18, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x0c, 0x06, 0x06, 0x06, 0x06,	/* 29 */
	0x06, 0x0c, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff, 0x3c,	/* 2A */
	0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0xff, 0x18,	/* 2B */
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 2C */
	0x18, 0x18, 0x18, 0x30, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,	/* 2D */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 2E */
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x03, 0x06, 0x0c, 0x18, 0x30,	/* 2F */
	0x60, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x67, 0x6f, 0x7b, 0x73,	/* 30 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x1c, 0x3c, 0x0c, 0x0c, 0x0c,	/* 31 */
	0x0c, 0x0c, 0x3f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x03, 0x06, 0x0c, 0x18,	/* 32 */
	0x30, 0x63, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x1e, 0x03,	/* 33 */
	0x03, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x0e, 0x1e, 0x36, 0x66, 0x7f,	/* 34 */
	0x06, 0x06, 0x0f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0x7e, 0x03,	/* 35 */
	0x03, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x30, 0x60, 0x60, 0x7e, 0x63,	/* 36 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x63, 0x03, 0x06, 0x0c, 0x18,	/* 37 */
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x3e, 0x63,	/* 38 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x3f, 0x03,	/* 39 */
	0x03, 0x06, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,	/* 3A */
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,	/* 3B */
	0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30,	/* 3C */
	0x18, 0x0c, 0x06, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00,	/* 3D */
	0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c,	/* 3E */
	0x18, 0x30, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x0c, 0x0c,	/* 3F */
	0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x63, 0x6f, 0x6f, 0x6f,	/* 40 */
	0x6e, 0x60, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f,	/* 41 */
	0x63, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x33, 0x33, 0x33, 0x3e, 0x33,	/* 42 */
	0x33, 0x33, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x33, 0x61, 0x60, 0x60, 0x60,	/* 43 */
	0x61, 0x33, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x36, 0x33, 0x33, 0x33, 0x33,	/* 44 */
	0x33, 0x36, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x33, 0x31, 0x34, 0x3c, 0x34,	/* 45 */
	0x31, 0x33, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x33, 0x31, 0x34, 0x3c, 0x34,	/* 46 */
	0x30, 0x30, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x33, 0x61, 0x60, 0x60, 0x6f,	/* 47 */
	0x63, 0x33, 0x1d, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63,	/* 48 */
	0x63, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,	/* 49 */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x06,	/* 4A */
	0x66, 0x66, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x73, 0x33, 0x36, 0x36, 0x3c, 0x36,	/* 4B */
	0x36, 0x33, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30,	/* 4C */
	0x31, 0x33, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xe7, 0xff, 0xdb, 0xc3, 0xc3,	/* 4D */
	0xc3, 0xc3, 0xc3, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x63, 0x73, 0x7b, 0x7f, 0x6f, 0x67,	/* 4E */
	0x63, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x63,	/* 4F */
	0x63, 0x36, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x33, 0x33, 0x33, 0x3e, 0x30,	/* 50 */
	0x30, 0x30, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x6b,	/* 51 */
	0x6f, 0x3e, 0x06, 0x07, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x33, 0x33, 0x33, 0x3e, 0x36,	/* 52 */
	0x33, 0x33, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x63, 0x63, 0x30, 0x1c, 0x06,	/* 53 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xdb, 0x99, 0x18, 0x18, 0x18,	/* 54 */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,	/* 55 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3,	/* 56 */
	0x66, 0x3c, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xdb, 0xdb,	/* 57 */
	0xff, 0x66, 0x66, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x3c,	/* 58 */
	0x66, 0xc3, 0xc3, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18,	/* 59 */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xc3, 0x86, 0x0c, 0x18, 0x30,	/* 5A */
	0x61, 0xc3, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30,	/* 5B */
	0x30, 0x30, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x60, 0x70, 0x38, 0x1c, 0x0e,	/* 5C */
	0x07, 0x03, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,	/* 5D */
	0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00,
	0x08, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00,	/* 5E */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 5F */
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
	0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 60 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x06, 0x3e,	/* 61 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x70, 0x30, 0x30, 0x3c, 0x36, 0x33,	/* 62 */
	0x33, 0x33, 0x6e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x60,	/* 63 */
	0x60, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x06, 0x06, 0x1e, 0x36, 0x66,	/* 64 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x7f,	/* 65 */
	0x60, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x36, 0x32, 0x30, 0x7c, 0x30,	/* 66 */
	0x30, 0x30, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66,	/* 67 */
	0x66, 0x3e, 0x06, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0x70, 0x30, 0x30, 0x36, 0x3b, 0x33,	/* 68 */
	0x33, 0x33, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1c, 0x0c, 0x0c,	/* 69 */
	0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06,	/* 6A */
	0x06, 0x06, 0x66, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0x70, 0x30, 0x30, 0x33, 0x36, 0x3c,	/* 6B */
	0x36, 0x33, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,	/* 6C */
	0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xdb,	/* 6D */
	0xdb, 0xdb, 0xdb, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x33, 0x33,	/* 6E */
	0x33, 0x33, 0x33, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63,	/* 6F */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x33, 0x33,	/* 70 */
	0x33, 0x3e, 0x30, 0x30, 0x78, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66,	/* 71 */
	0x66, 0x3e, 0x06, 0x06, 0x0f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x33,	/* 72 */
	0x30, 0x30, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x38,	/* 73 */
	0x0e, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x18, 0x18, 0x7e, 0x18, 0x18,	/* 74 */
	0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,	/* 75 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0xc3,	/* 76 */
	0x66, 0x3c, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0xdb,	/* 77 */
	0xdb, 0xff, 0x66, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c,	/* 78 */
	0x1c, 0x36, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63,	/* 79 */
	0x63, 0x3f, 0x03, 0x06, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x66, 0x0c,	/* 7A */
	0x18, 0x33, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18,	/* 7B */
	0x18, 0x18, 0x0e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18,	/* 7C */
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18,	/* 7D */
	0x18, 0x18, 0x70, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3b, 0x6e, 0x00, 0x00, 0x00, 0x00,	/* 7E */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63,	/* 7F */
	0x63, 0x7f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x33, 0x61, 0x60, 0x60, 0x61,	/* 80 */
	0x33, 0x1e, 0x06, 0x03, 0x3e, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x00, 0x66, 0x66, 0x66,	/* 81 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x7f,	/* 82 */
	0x60, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x1c, 0x36, 0x00, 0x3c, 0x06, 0x3e,	/* 83 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x00, 0x3c, 0x06, 0x3e,	/* 84 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x18, 0x0c, 0x00, 0x3c, 0x06, 0x3e,	/* 85 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0x36, 0x1c, 0x00, 0x3c, 0x06, 0x3e,	/* 86 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60, 0x66,	/* 87 */
	0x3c, 0x0c, 0x06, 0x3c, 0x00, 0x00,
	0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x7f,	/* 88 */
	0x60, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x00, 0x3e, 0x63, 0x7f,	/* 89 */
	0x60, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x7f,	/* 8A */
	0x60, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18,	/* 8B */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x3c, 0x66, 0x00, 0x38, 0x18, 0x18,	/* 8C */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18,	/* 8D */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x63, 0x63, 0x08, 0x1c, 0x36, 0x63, 0x63,	/* 8E */
	0x7f, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x1c, 0x36, 0x1c, 0x00, 0x1c, 0x36, 0x63, 0x63,	/* 8F */
	0x7f, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x0c, 0x18, 0x30, 0x00, 0x7f, 0x33, 0x30, 0x3e,	/* 90 */
	0x30, 0x33, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x1b, 0x7e,	/* 91 */
	0xd8, 0xdc, 0x77, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0x36, 0x66, 0x66, 0x7f, 0x66,	/* 92 */
	0x66, 0x66, 0x67, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63,	/* 93 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x63, 0x63, 0x00, 0x3e, 0x63, 0x63,	/* 94 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63,	/* 95 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x3c, 0x66, 0x00, 0x66, 0x66, 0x66,	/* 96 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x18, 0x0c, 0x00, 0x66, 0x66, 0x66,	/* 97 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x63, 0x63, 0x00, 0x63, 0x63, 0x63,	/* 98 */
	0x63, 0x3f, 0x03, 0x06, 0x3c, 0x00,
	0x00, 0x63, 0x63, 0x1c, 0x36, 0x63, 0x63, 0x63,	/* 99 */
	0x63, 0x36, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x63, 0x63, 0x00, 0x63, 0x63, 0x63, 0x63,	/* 9A */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x7e, 0xc3, 0xc0, 0xc0, 0xc3,	/* 9B */
	0x7e, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0x36, 0x32, 0x30, 0x78, 0x30, 0x30,	/* 9C */
	0x30, 0x73, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0x66, 0x3c, 0x18, 0xff, 0x18,	/* 9D */
	0xff, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0x66, 0x66, 0x7c, 0x62, 0x66, 0x6f,	/* 9E */
	0x66, 0x66, 0xf3, 0x00, 0x00, 0x00,
	0x00, 0x0e, 0x1b, 0x18, 0x18, 0x18, 0x7e, 0x18,	/* 9F */
	0x18, 0x18, 0x18, 0xd8, 0x70, 0x00,
	0x00, 0x0c, 0x18, 0x30, 0x00, 0x3c, 0x06, 0x3e,	/* A0 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x18, 0x30, 0x00, 0x38, 0x18, 0x18,	/* A1 */
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x18, 0x30, 0x00, 0x3e, 0x63, 0x63,	/* A2 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x18, 0x30, 0x00, 0x66, 0x66, 0x66,	/* A3 */
	0x66, 0x66, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3b, 0x6e, 0x00, 0x6e, 0x33, 0x33,	/* A4 */
	0x33, 0x33, 0x33, 0x00, 0x00, 0x00,
	0x3b, 0x6e, 0x00, 0x63, 0x73, 0x7b, 0x7f, 0x6f,	/* A5 */
	0x67, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00,	/* A6 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00,	/* A7 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x30,	/* A8 */
	0x63, 0x63, 0x3e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60,	/* A9 */
	0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03,	/* AA */
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0xe0, 0x63, 0x66, 0x6c, 0x18, 0x30,	/* AB */
	0x6e, 0xc3, 0x06, 0x0c, 0x1f, 0x00,
	0x00, 0x60, 0xe0, 0x63, 0x66, 0x6c, 0x18, 0x33,	/* AC */
	0x67, 0xcf, 0x1f, 0x03, 0x03, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x3c,	/* AD */
	0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c, 0x36,	/* AE */
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x36, 0x1b, 0x36,	/* AF */
	0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44,	/* B0 */
	0x11, 0x44, 0x11, 0x44, 0x11, 0x44,
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,	/* B1 */
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
	0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77,	/* B2 */
	0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* B3 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,	/* B4 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8,	/* B5 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6,	/* B6 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,	/* B7 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8,	/* B8 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xf6,	/* B9 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,	/* BA */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0xf6,	/* BB */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe,	/* BC */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe,	/* BD */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8,	/* BE */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,	/* BF */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,	/* C0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,	/* C1 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* C2 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,	/* C3 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* C4 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,	/* C5 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f,	/* C6 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37,	/* C7 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f,	/* C8 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x37,	/* C9 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xff,	/* CA */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7,	/* CB */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37,	/* CC */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,	/* CD */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xf7,	/* CE */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff,	/* CF */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff,	/* D0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,	/* D1 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* D2 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3f,	/* D3 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f,	/* D4 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f,	/* D5 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,	/* D6 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff,	/* D7 */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff,	/* D8 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,	/* D9 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,	/* DA */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* DB */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* DC */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,	/* DD */
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,	/* DE */
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,	/* DF */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x6c,	/* E0 */
	0x6c, 0x6e, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x7e, 0x63,	/* E1 */
	0x63, 0x7e, 0x60, 0x60, 0x20, 0x00,
	0x00, 0x00, 0x7f, 0x63, 0x63, 0x60, 0x60, 0x60,	/* E2 */
	0x60, 0x60, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0x36, 0x36, 0x36,	/* E3 */
	0x36, 0x36, 0x36, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x63, 0x30, 0x18, 0x0c, 0x18,	/* E4 */
	0x30, 0x63, 0x7f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6c, 0x6c,	/* E5 */
	0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33,	/* E6 */
	0x3e, 0x30, 0x30, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x0c, 0x0c,	/* E7 */
	0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x18, 0x3c, 0x66, 0x66, 0x66,	/* E8 */
	0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63,	/* E9 */
	0x63, 0x36, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x36,	/* EA */
	0x36, 0x36, 0x77, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x30, 0x18, 0x0c, 0x3e, 0x66,	/* EB */
	0x66, 0x66, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb,	/* EC */
	0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x06, 0x7e, 0xdb, 0xdb, 0xf3,	/* ED */
	0x7e, 0x60, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x30, 0x60, 0x60, 0x7c, 0x60,	/* EE */
	0x60, 0x30, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63,	/* EF */
	0x63, 0x63, 0x63, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00,	/* F0 */
	0x00, 0x7f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18,	/* F1 */
	0x18, 0x00, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18,	/* F2 */
	0x30, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18,	/* F3 */
	0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18,	/* F4 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* F5 */
	0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0xff, 0x00,	/* F6 */
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x00, 0x3b,	/* F7 */
	0x6e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00,	/* F8 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,	/* F9 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,	/* FA */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xec,	/* FB */
	0x6c, 0x3c, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0xd8, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00,	/* FC */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x70, 0xd8, 0x30, 0x60, 0xc8, 0xf8, 0x00,	/* FD */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e,	/* FE */
	0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* FF */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#endif
