﻿// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

public class FileData
{
    public String Name { get; set; }
    public String FullName { get; set; }
    public long Length { get; set; }
    public String CRC { get; set; }
    public DateTime LastModifiedDate { get; set; }
    public bool IsFile { get; set; }
    public bool IsFolder { get; set; }
    public String OrigFolder { get; set; }

    public override string ToString()
    {
        return FullName;
    }

    public static List<FileData> Files { get; private set; }

    public static FileData GetFile(String Path)
    {
        return Files.Where(f => String.Equals(System.IO.Path.Combine(f.OrigFolder, f.FullName), Path, StringComparison.OrdinalIgnoreCase)).First();
    }

    public static List<FileData> InPath(String Path)
    {
        return Files.Where(f => String.Equals(f.OrigFolder, Path, StringComparison.OrdinalIgnoreCase)).ToList();
    }

    static FileData()
    {
        Files = new List<FileData>() {
                new FileData() { CRC = "0", FullName = "docProps", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010376583695), Length = 0, Name = "docProps", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "0", FullName = "xl", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010378287507), Length = 0, Name = "xl", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "379087996", FullName = "[Content_Types].xml", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 1440, Name = "[Content_Types].xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "0", FullName = "_rels", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010378707560), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "3251282338", FullName = Path.Combine("docProps", "app.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 860, Name = "app.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "4066709247", FullName = Path.Combine("docProps", "core.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 629, Name = "core.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "3490344669", FullName = Path.Combine("xl", "sharedStrings.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 205, Name = "sharedStrings.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "2487798992", FullName = Path.Combine("xl", "styles.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 1260, Name = "styles.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "0", FullName = Path.Combine("xl", "theme"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010377077464), Length = 0, Name = "theme", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "2695761957", FullName = Path.Combine("xl", "workbook.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 626, Name = "workbook.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "0", FullName = Path.Combine("xl", "worksheets"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010378077475), Length = 0, Name = "worksheets", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "0", FullName = Path.Combine("xl", "_rels"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010378337506), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "1839555323", FullName = Path.Combine("xl", "theme", "theme1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 7079, Name = "theme1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "2266702202", FullName = Path.Combine("xl", "worksheets", "sheet1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 948, Name = "sheet1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "3851075966", FullName = Path.Combine("xl", "worksheets", "sheet2.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 628, Name = "sheet2.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "3851075966", FullName = Path.Combine("xl", "worksheets", "sheet3.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 628, Name = "sheet3.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "687671774", FullName = Path.Combine("xl", "_rels", "workbook.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 980, Name = "workbook.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "590370229", FullName = Path.Combine("_rels", ".rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 588, Name = ".rels", OrigFolder = Path.Combine("ZipTestData", "compat", "excel") },
                new FileData() { CRC = "0", FullName = "Content", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010379007586), Length = 0, Name = "Content", OrigFolder = Path.Combine("ZipTestData", "compat", "packaging") },
                new FileData() { CRC = "3771965933", FullName = "[Content_Types].xml", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 175, Name = "[Content_Types].xml", OrigFolder = Path.Combine("ZipTestData", "compat", "packaging") },
                new FileData() { CRC = "0", FullName = Path.Combine("Content", "Document.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 0, Name = "Document.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "packaging") },
                new FileData() { CRC = "0", FullName = "docProps", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010761346891), Length = 0, Name = "docProps", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = "ppt", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010761456904), Length = 0, Name = "ppt", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4112043231", FullName = "[Content_Types].xml", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 3142, Name = "[Content_Types].xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = "_rels", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762721055), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "2713108320", FullName = Path.Combine("docProps", "app.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 1141, Name = "app.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "991546153", FullName = Path.Combine("docProps", "core.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 697, Name = "core.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1281192996", FullName = Path.Combine("docProps", "thumbnail.jpeg"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 9216, Name = "thumbnail.jpeg", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4082892623", FullName = Path.Combine("ppt", "presentation.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 3228, Name = "presentation.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "2930715919", FullName = Path.Combine("ppt", "presProps.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 651, Name = "presProps.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "slideLayouts"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010761686922), Length = 0, Name = "slideLayouts", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "slideMasters"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762379616), Length = 0, Name = "slideMasters", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "slides"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762429772), Length = 0, Name = "slides", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "2408447448", FullName = Path.Combine("ppt", "tableStyles.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 182, Name = "tableStyles.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "theme"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762479645), Length = 0, Name = "theme", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1651499418", FullName = Path.Combine("ppt", "viewProps.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 828, Name = "viewProps.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "_rels"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762509649), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "988293525", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 4360, Name = "slideLayout1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1979367683", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout10.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 3023, Name = "slideLayout10.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1135098451", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout11.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 3248, Name = "slideLayout11.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "3955818837", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout2.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 2968, Name = "slideLayout2.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1678476793", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout3.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 4444, Name = "slideLayout3.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "3353951328", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout4.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 4715, Name = "slideLayout4.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "3664659459", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout5.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 7226, Name = "slideLayout5.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "3638428791", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout6.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 2236, Name = "slideLayout6.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "2808899162", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout7.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 1898, Name = "slideLayout7.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1098595834", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout8.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 4805, Name = "slideLayout8.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "89131868", FullName = Path.Combine("ppt", "slideLayouts", "slideLayout9.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 4660, Name = "slideLayout9.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "slideLayouts", "_rels"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010761916977), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout1.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout1.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout10.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout10.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout11.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout11.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout2.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout2.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout3.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout3.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout4.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout4.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout5.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout5.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout6.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout6.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout7.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout7.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout8.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout8.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "4052931029", FullName = Path.Combine("ppt", "slideLayouts", "_rels", "slideLayout9.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slideLayout9.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "306118570", FullName = Path.Combine("ppt", "slideMasters", "slideMaster1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 12250, Name = "slideMaster1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "slideMasters", "_rels"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762399639), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "559915625", FullName = Path.Combine("ppt", "slideMasters", "_rels", "slideMaster1.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 1991, Name = "slideMaster1.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "3837614064", FullName = Path.Combine("ppt", "slides", "slide1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 1502, Name = "slide1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "0", FullName = Path.Combine("ppt", "slides", "_rels"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010762449644), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "3022216291", FullName = Path.Combine("ppt", "slides", "_rels", "slide1.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 311, Name = "slide1.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "1945010105", FullName = Path.Combine("ppt", "theme", "theme1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 7088, Name = "theme1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "120925723", FullName = Path.Combine("ppt", "_rels", "presentation.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 976, Name = "presentation.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "2708797544", FullName = Path.Combine("_rels", ".rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384680000000), Length = 738, Name = ".rels", OrigFolder = Path.Combine("ZipTestData", "compat", "powerpoint") },
                new FileData() { CRC = "2804111955", FullName = "AppManifest.xaml", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 377, Name = "AppManifest.xaml", OrigFolder = Path.Combine("ZipTestData", "compat", "silverlight") },
                new FileData() { CRC = "2907260237", FullName = "sampleSilverlight.dll", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 7680, Name = "sampleSilverlight.dll", OrigFolder = Path.Combine("ZipTestData", "compat", "silverlight") },
                new FileData() { CRC = "0", FullName = "docProps", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010384845969), Length = 0, Name = "docProps", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "0", FullName = "word", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010385739590), Length = 0, Name = "word", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "2189894665", FullName = "[Content_Types].xml", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 1422, Name = "[Content_Types].xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "0", FullName = "_rels", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010386053356), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "3583731484", FullName = Path.Combine("docProps", "app.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 732, Name = "app.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "3784706252", FullName = Path.Combine("docProps", "core.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 657, Name = "core.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "101526815", FullName = Path.Combine("word", "document.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 1583, Name = "document.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "4093991586", FullName = Path.Combine("word", "fontTable.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 1492, Name = "fontTable.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "1717747992", FullName = Path.Combine("word", "settings.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 2182, Name = "settings.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "3373748758", FullName = Path.Combine("word", "styles.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 14960, Name = "styles.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "386542124", FullName = Path.Combine("word", "stylesWithEffects.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 15713, Name = "stylesWithEffects.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "0", FullName = Path.Combine("word", "theme"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010385508281), Length = 0, Name = "theme", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "1310105623", FullName = Path.Combine("word", "webSettings.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 428, Name = "webSettings.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "0", FullName = Path.Combine("word", "_rels"), IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010385779585), Length = 0, Name = "_rels", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "692313392", FullName = Path.Combine("word", "theme", "theme1.xml"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 7076, Name = "theme1.xml", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "966212476", FullName = Path.Combine("word", "_rels", "document.xml.rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 953, Name = "document.xml.rels", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "3071971614", FullName = Path.Combine("_rels", ".rels"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170384700000000), Length = 590, Name = ".rels", OrigFolder = Path.Combine("ZipTestData", "compat", "word") },
                new FileData() { CRC = "230944024", FullName = "added.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634170420720000000), Length = 55, Name = "added.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "740169638", FullName = "binary.wmv", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635622023629545932), Length = 2703788, Name = "binary.wmv", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140180740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634170420720000000), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "3837213049", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241740000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010860858103), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241920000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "addFile") },
                new FileData() { CRC = "740169638", FullName = "binary.wmv", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635622023629545932), Length = 2703788, Name = "binary.wmv", OrigFolder = Path.Combine("ZipTestData", "modified", "append") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140180740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "modified", "append") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634170420720000000), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "modified", "append") },
                new FileData() { CRC = "1948807612", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634141042380000000), Length = 83, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "append") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010861923530), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "modified", "append") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241920000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "append") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140180740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "modified", "deleteMove") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634170420740000000), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "modified", "deleteMove") },
                new FileData() { CRC = "3837213049", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241740000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "deleteMove") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010862173564), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "modified", "deleteMove") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "secondnewname.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241920000000), Length = 34, Name = "secondnewname.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "deleteMove") },
                new FileData() { CRC = "740169638", FullName = "binary.wmv", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635622023629545932), Length = 2703788, Name = "binary.wmv", OrigFolder = Path.Combine("ZipTestData", "modified", "overwrite") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140180740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "modified", "overwrite") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634170420740000000), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "modified", "overwrite") },
                new FileData() { CRC = "3143804092", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634141906380000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "overwrite") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010863243705), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "modified", "overwrite") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241920000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "modified", "overwrite") },
                new FileData() { CRC = "2681708200", FullName = "text.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140142900000000), Length = 1277, Name = "text.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "appended") },
                new FileData() { CRC = "0", FullName = "empty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634877996085623086), Length = 0, Name = "empty", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "emptydir") },
                new FileData() { CRC = "0", FullName = "subdir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634877996086238966), Length = 0, Name = "subdir", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "explicitdir1") },
                new FileData() { CRC = "1774992399", FullName = Path.Combine("subdir", "small.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140208640000000), Length = 59, Name = "small.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "explicitdir1") },
                new FileData() { CRC = "0", FullName = "subdir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634877996086589013), Length = 0, Name = "subdir", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "explicitdir2") },
                new FileData() { CRC = "1774992399", FullName = Path.Combine("subdir", "small.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140208640000000), Length = 59, Name = "small.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "explicitdir2") },
                new FileData() { CRC = "0", FullName = "subdir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634877996088225180), Length = 0, Name = "subdir", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "noexplicitdir") },
                new FileData() { CRC = "1774992399", FullName = Path.Combine("subdir", "small.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140208640000000), Length = 59, Name = "small.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "noexplicitdir") },
                new FileData() { CRC = "740169638", FullName = "binary.wmv", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635622023629545932), Length = 2703788, Name = "binary.wmv", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "normal") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140144740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "normal") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634877996089255333), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "normal") },
                new FileData() { CRC = "3837213049", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140205740000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "normal") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634877996089395357), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "normal") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140205920000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "normal") },
                new FileData() { CRC = "2681708200", FullName = "text.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140142900000000), Length = 1277, Name = "text.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "prepended") },
                new FileData() { CRC = "2681708200", FullName = "text.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140142900000000), Length = 1277, Name = "text.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "small") },
                new FileData() { CRC = "1868100414", FullName = "\uD55C\uAE00.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140229300000000), Length = 1420, Name = "\uD55C\uAE00.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfiles", "unicode") },
                new FileData() { CRC = "0", FullName = "empty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634145569520000000), Length = 0, Name = "empty", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "emptydir") },
                new FileData() { CRC = "0", FullName = "subdir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010859117381), Length = 0, Name = "subdir", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "explicitdir") },
                new FileData() { CRC = "1774992399", FullName = Path.Combine("subdir", "small.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140244640000000), Length = 59, Name = "small.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "explicitdir") },
                new FileData() { CRC = "740169638", FullName = "binary.wmv", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635622023629545932), Length = 2703788, Name = "binary.wmv", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normal") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140180740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normal") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634140181780000000), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normal") },
                new FileData() { CRC = "3837213049", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241740000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normal") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010864271799), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normal") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241920000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normal") },
                new FileData() { CRC = "740169638", FullName = "binary.wmv", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635622023629545932), Length = 2703788, Name = "binary.wmv", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutEmptyDir") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635433642420000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutEmptyDir") },
                new FileData() { CRC = "3837213049", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635433642420000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutEmptyDir") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010865429721), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutEmptyDir") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(635433642420000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutEmptyDir") },
                new FileData() { CRC = "2681708200", FullName = "text.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140178900000000), Length = 1277, Name = "text.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "small") },
                new FileData() { CRC = "1868100414", FullName = "\uD55C\uAE00.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140229300000000), Length = 1420, Name = "\uD55C\uAE00.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "unicode") },
                new FileData() { CRC = "3082125467", FullName = "small.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634110746340000000), Length = 26, Name = "small.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "verysmall") },
                new FileData() { CRC = "0", FullName = "empty.file", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140180740000000), Length = 0, Name = "empty.file", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutBinary") },
                new FileData() { CRC = "0", FullName = "emptydir", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634140181780000000), Length = 0, Name = "emptydir", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutBinary") },
                new FileData() { CRC = "3837213049", FullName = "first.txt", IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241740000000), Length = 34, Name = "first.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutBinary") },
                new FileData() { CRC = "0", FullName = "notempty", IsFile = false, IsFolder = true, LastModifiedDate = new DateTime(634878010864271799), Length = 0, Name = "notempty", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutBinary") },
                new FileData() { CRC = "3520234574", FullName = Path.Combine("notempty", "second.txt"), IsFile = true, IsFolder = false, LastModifiedDate = new DateTime(634140241920000000), Length = 34, Name = "second.txt", OrigFolder = Path.Combine("ZipTestData", "refzipfolders", "normalWithoutBinary") },
            };
    }
}
