// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using System;
using System.ComponentModel;

namespace Microsoft.CSharp.RuntimeBinder
{
    /// <summary>
    /// Represents information about C# dynamic operations that are specific to particular arguments at a call site.
    /// Instances of this class are generated by the C# compiler.
    /// </summary>
    [Flags, EditorBrowsable(EditorBrowsableState.Never)]
    public enum CSharpArgumentInfoFlags
    {
        /// <summary>
        /// No additional information to represent.
        /// </summary>
        None = 0x00000000,

        /// <summary>
        /// The argument's compile-time type should be considered during binding.
        /// </summary>
        UseCompileTimeType = 0x00000001,

        /// <summary>
        /// The argument is a constant.
        /// </summary>
        Constant = 0x00000002,

        /// <summary>
        /// The argument is a named argument.
        /// </summary>
        NamedArgument = 0x00000004,

        /// <summary>
        /// The argument is passed to a ref parameter.
        /// </summary>
        IsRef = 0x00000008,

        /// <summary>
        /// The argument is passed to an out parameter.
        /// </summary>
        IsOut = 0x00000010,

        /// <summary>
        /// The argument is a <see cref="System.Type"/> indicating an actual typename used in source. Used only for target objects in static calls.
        /// </summary>
        IsStaticType = 0x00000020,
    }
}
