# Guides

```{eval-rst}
.. toctree::
  :maxdepth: 2
  :hidden:

  overview
  reactivity
  interactivity
  outputs
  expensive_notebooks
  coming_from/jupyter
  working_with_data/index
  editor_features/index
  configuration/index
  apps
  scripts
  coming_from/index
  integrating_with_marimo/index
  state
  wasm
  exporting
  deploying/index
  best_practices
  troubleshooting
```

These guides cover marimo's core concepts.

```{admonition} Learn by doing!
:class: tip

Prefer a hands-on learning experience? marimo comes packaged with interactive
tutorials that you can launch with `marimo tutorial` at the command line.
```

| Guide                                | Description                                                  |
| :----------------------------------- | :----------------------------------------------------------- |
| {doc}`overview`                      | An overview of basic concepts                                |
| {doc}`reactivity`                    | How marimo runs cells                                        |
| {doc}`interactivity`                 | Using interactive UI elements                                |
| {doc}`outputs`                       | Creating markdown, plots, and other visual outputs           |
| {doc}`expensive_notebooks`           | Tips for working with expensive notebooks                    |
| {doc}`/guides/coming_from/jupyter`   | Tips for transitioning from Jupyter                          |
| {doc}`working_with_data/index`       | Using SQL cells, no-code dataframe tools, and reactive plots |
| {doc}`editor_features/index`         | View variables, dataframe schemas, docstrings, and more      |
| {doc}`configuration/index`           | Configure various settings                                   |
| {doc}`apps`                          | Running notebooks as apps                                    |
| {doc}`scripts`                       | Running notebooks as scripts                                 |
| {doc}`coming_from/index`             | Transitioning from Jupyter and other tools                   |
| {doc}`integrating_with_marimo/index` | Rich displays of objects, custom UI plugins                  |
| {doc}`state`                         | Advanced: mutable reactive state                             |
| {doc}`wasm`                          | Create notebooks in our online playground                    |
| {doc}`exporting`                     | Exporting notebooks to HTML and flat scripts                 |
| {doc}`deploying/index`               | Deploying marimo notebooks and apps                          |
| {doc}`best_practices`                | Best practices to help you get the most out of marimo        |
| {doc}`troubleshooting`               | Troubleshooting notebooks                                    |
