<h1 align="center"> OWASP BLT </h1>


<p align="center"><a href="https://github.com/OWASP/BLT/actions" rel="noopener noreferrer" target="__blank"><img alt="Build" src="https://github.com/OWASP/BLT/actions/workflows/auto-merge.yml/badge.svg"></a> <a href="https://github.com/OWASP/BLT/blob/main/LICENSE.md" rel="noopener noreferrer"><img src="https://img.shields.io/badge/license-AGPL--3.0-blue"></a>
<a href="https://github.com/OWASP/BLT" rel="noopener noreferrer" target="__blank"><img alt="GitHub stars" src="https://img.shields.io/github/stars/OWASP/BLT?style=social"></a></p>

------

  

**Report issues and get points, companies are held accountable.**

  

- OWASP BLT is a bug logging tool to report issues and get points, companies are held accountable.

  

- Users will get rewards/points for reporting bugs on Organizations / Companies.

  

- Organizations / Companies can launch their bug hunt programs with prize pools.

  

- Read more about [BLT](https://owasp.org/www-project-bug-logging-tool/)


- Watch this [Video](https://www.youtube.com/watch?v=jNp3J6HLpqc) to get detailed motives and features of project BLT.
  

# Development

Make sure to run pre-commit before committing so it formats the code.  

### Setting Up Development Server

  

  

Please follow the development server setup procedure [here](https://github.com/OWASP/BLT/blob/main/Setup.md). Currently, development server can be installed using docker or vagrant. You can also use virtualenv or pipenv install, pipenv shell and then continue with the remaining instructions.

  

  

### Documentation

  

  

- use the [Installation Docs ](https://github.com/OWASP/BLT/blob/main/Setup.md) to get started.

  

- Swagger API Documentations can be found at the root domain /swagger/

  

- Postman API Documentations: [Postman Docs](https://documenter.getpostman.com/view/19782933/VUqpscyV).

  

  

### Resources

  

  
- Communicate with us on slack #project-blt [Join OWASP Slack Channel](https://owasp.org/slack/invite)

  

- Github activity can be seen in Slack **#blt-github**.

  

- #### Figma designs: 
  - [New Tailwind Website Designs](https://www.figma.com/file/JE0QlQ95FVpk0wG9HyFw4D/BLT-Website?type=design&node-id=0%3A1&t=9aPMxdjUDBIUirAz-1)
  - [New Mobile Designs](https://www.figma.com/file/NYD5WZzJywnO338lchnece/Bug-Logging-Tool?type=design&node-id=0%3A1&t=k0Hx6qW4Ue9iZvbH-1)
  - [Old Website and Mobile Designs](https://www.figma.com/file/s0xuxeU6O2guoWEfA9OElZ/Design)

  

  

### Other BLT Projects

  

- [OWASP/BLT](https://www.github.com/OWASP/BLT)

  

- [OWASP/BLT-Flutter](https://www.github.com/OWASP/BLT-Flutter)

  

- [OWASP/BLT-Extension](https://www.github.com/OWASP/BLT-Extension)

  

- [OWASP/BLT-Bacon](https://www.github.com/OWASP/BLT-Bacon)

  

- [OWASP/BLT-Action](https://www.github.com/OWASP/BLT-Action)

  

  

### Coding style guide

  

  

Please follow the [black](https://github.com/psf/black) code style for the project. It helps us in keeping the codebase consistent and improves readability for other developers.
Use `pre-commit run` command to make sure your changes comply with the standards.

  

  

### License

  

The BLT code is released under [GNU Affero General Public License v3.0 (AGPL-3.0)](https://github.com/OWASP/BLT/blob/master/LICENSE).

  

  

## Notes

  

  

- If you find a bug or have an improvement, use BLT to report it!

  

- for each new issue, create a new branch with issue-382 or similar matching the issue number - when you commit add fixes #288 to link the issue to the pull request

  

- to take a github issue type a comment that says "assign to me" or /assign and it will assign it to you.
