# Generated by Django 5.1.1 on 2024-11-10 04:05

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0143_contributorstats_last_updated_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.DeleteModel(
            name="ContributorStats",
        ),
        migrations.AddField(
            model_name="contribution",
            name="contribution_type",
            field=models.CharField(
                choices=[
                    ("commit", "Commit"),
                    ("issue_opened", "Issue Opened"),
                    ("issue_closed", "Issue Closed"),
                    ("issue_assigned", "Issue Assigned"),
                    ("pull_request", "Pull Request"),
                    ("comment", "Comment"),
                ],
                default="commit",
                max_length=20,
            ),
        ),
        migrations.AddField(
            model_name="contribution",
            name="github_id",
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name="contribution",
            name="github_url",
            field=models.URLField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="contribution",
            name="repository",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="website.project",
            ),
        ),
        migrations.AlterField(
            model_name="contribution",
            name="created",
            field=models.DateTimeField(),
        ),
        migrations.AddIndex(
            model_name="contribution",
            index=models.Index(fields=["github_id"], name="website_con_github__0ac410_idx"),
        ),
        migrations.AddIndex(
            model_name="contribution",
            index=models.Index(fields=["user", "created"], name="website_con_user_id_0a46de_idx"),
        ),
        migrations.AddIndex(
            model_name="contribution",
            index=models.Index(fields=["repository", "created"], name="website_con_reposit_9a7e49_idx"),
        ),
    ]
