# Generated by Django 5.1.3 on 2024-11-23 19:15

from django.db import migrations


def replace_blt_contributors_tag(apps, schema_editor):
    # Get the models dynamically to avoid dependency issues
    Tag = apps.get_model("website", "Tag")
    UserProfile = apps.get_model("website", "UserProfile")

    # Get or create the "BLT Contributors" tag
    blt_contributors_tag, _ = Tag.objects.get_or_create(name="BLT Contributors", slug="blt_contributors")

    try:
        # Get the "BLT-Contributors" tag
        blt_contributors_old_tag = Tag.objects.get(name="BLT-Contributors")

        # Move users from the old tag to the new tag
        for user_profile in UserProfile.objects.filter(tags=blt_contributors_old_tag):
            user_profile.tags.add(blt_contributors_tag)

        # Delete the old tag
        blt_contributors_old_tag.delete()

    except Tag.DoesNotExist:
        print("The 'BLT-Contributors' tag does not exist. No changes made.")


class Migration(migrations.Migration):
    dependencies = [
        (
            "website",
            "0154_contributors_to_users_20241123_1836",
        ),
    ]

    operations = [
        migrations.RunPython(replace_blt_contributors_tag),
    ]
