# Generated by Django 5.1.3 on 2024-11-27 19:45

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0156_merge_20241124_0722"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Badge",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=100)),
                ("description", models.TextField()),
                (
                    "icon",
                    models.ImageField(blank=True, null=True, upload_to="badges/icons/"),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("automatic", "Automatic"), ("manual", "Manual")],
                        default="automatic",
                        max_length=10,
                    ),
                ),
                ("criteria", models.JSONField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="UserBadge",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("awarded_at", models.DateTimeField(auto_now_add=True)),
                ("reason", models.TextField(blank=True, null=True)),
                (
                    "awarded_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="awarded_badges",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "badge",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="website.badge"),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
