# Generated by Django 5.1.3 on 2024-12-01 17:18

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0163_merge_0161_merge_20241201_1619_0162_add_new_badges"),
    ]

    operations = [
        migrations.CreateModel(
            name="Integration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "service_name",
                    models.CharField(
                        blank=True,
                        choices=[("slack", "SLACK")],
                        max_length=20,
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "company",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="company_integrations",
                        to="website.company",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="company",
            name="integrations",
            field=models.ManyToManyField(related_name="companies", to="website.integration"),
        ),
        migrations.CreateModel(
            name="SlackIntegration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "bot_access_token",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "workspace_name",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "default_channel_name",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "default_channel_id",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("daily_updates", models.BooleanField(default=False)),
                (
                    "daily_update_time",
                    models.IntegerField(
                        blank=True,
                        help_text="The hour of the day (0-23) to send daily updates",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(23),
                        ],
                    ),
                ),
                (
                    "integration",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="slack_integration",
                        to="website.integration",
                    ),
                ),
            ],
        ),
    ]
