# Generated by Django 5.1.3 on 2024-12-18 19:42

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0172_merge_20241218_0505"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.RemoveField(
            model_name="company",
            name="admin",
        ),
        migrations.RemoveField(
            model_name="company",
            name="integrations",
        ),
        migrations.RemoveField(
            model_name="company",
            name="managers",
        ),
        migrations.RemoveField(
            model_name="company",
            name="subscription",
        ),
        migrations.RemoveField(
            model_name="company",
            name="tags",
        ),
        migrations.RemoveField(
            model_name="integration",
            name="company",
        ),
        migrations.RemoveField(
            model_name="domain",
            name="company",
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "description",
                    models.CharField(blank=True, max_length=500, null=True),
                ),
                (
                    "logo",
                    models.ImageField(blank=True, null=True, upload_to="organization_logos"),
                ),
                ("url", models.URLField(unique=True)),
                ("email", models.EmailField(blank=True, max_length=254, null=True)),
                ("twitter", models.CharField(blank=True, max_length=30, null=True)),
                ("facebook", models.URLField(blank=True, null=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("is_active", models.BooleanField(default=False)),
                ("trademark_count", models.IntegerField(default=0)),
                ("trademark_check_date", models.DateTimeField(blank=True, null=True)),
                ("team_points", models.IntegerField(default=0)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("organization", "ORGANIZATION"),
                            ("individual", "INDIVIDUAL"),
                            ("team", "TEAM"),
                        ],
                        default="organization",
                        max_length=15,
                    ),
                ),
                (
                    "admin",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "integrations",
                    models.ManyToManyField(related_name="organizations", to="website.integration"),
                ),
                (
                    "managers",
                    models.ManyToManyField(related_name="user_organizations", to=settings.AUTH_USER_MODEL),
                ),
                (
                    "subscription",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="website.subscription",
                    ),
                ),
                ("tags", models.ManyToManyField(blank=True, to="website.tag")),
            ],
        ),
        migrations.AddField(
            model_name="domain",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="website.organization",
            ),
        ),
        migrations.AddField(
            model_name="integration",
            name="organization",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="organization_integrations",
                to="website.organization",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="joinrequest",
            name="team",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="website.organization",
            ),
        ),
        migrations.AlterField(
            model_name="timelog",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="time_logs",
                to="website.organization",
            ),
        ),
        migrations.AlterField(
            model_name="userprofile",
            name="team",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="user_profiles",
                to="website.organization",
            ),
        ),
        migrations.CreateModel(
            name="OrganizationAdmin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "role",
                    models.IntegerField(choices=[(0, "Admin"), (1, "Moderator")], default=0),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "domain",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="website.domain",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="website.organization",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.DeleteModel(
            name="CompanyAdmin",
        ),
        migrations.DeleteModel(
            name="Company",
        ),
    ]
