# Generated by Django 5.1.3 on 2025-01-06 13:17

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0178_alter_ip_agent"),
    ]

    operations = [
        migrations.CreateModel(
            name="ContributorStats",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateField()),
                ("commits", models.PositiveIntegerField(default=0)),
                ("issues_opened", models.PositiveIntegerField(default=0)),
                ("issues_closed", models.PositiveIntegerField(default=0)),
                ("pull_requests", models.PositiveIntegerField(default=0)),
                ("comments", models.PositiveIntegerField(default=0)),
                (
                    "granularity",
                    models.CharField(
                        choices=[("day", "Day"), ("month", "Month")],
                        default="day",
                        max_length=10,
                    ),
                ),
                (
                    "contributor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="stats",
                        to="website.contributor",
                    ),
                ),
                (
                    "repo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="stats",
                        to="website.repo",
                    ),
                ),
            ],
            options={
                "unique_together": {("contributor", "repo", "date", "granularity")},
            },
        ),
    ]
