# Generated by Django 5.1.4 on 2025-02-20 08:05

from django.db import migrations, models


def set_is_owasp_repo(apps, schema_editor):
    Repo = apps.get_model("website", "Repo")
    Repo.objects.all().update(is_owasp_repo=True)


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0203_remove_organization_unique_organization_slug_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="OsshArticle",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255)),
                ("author", models.CharField(max_length=255)),
                ("author_profile_image", models.URLField(blank=True, max_length=500, null=True)),
                ("description", models.TextField()),
                ("publication_date", models.DateTimeField()),
                ("source", models.CharField(help_text="Source API (DEV Community, LinkedIn etc)", max_length=255)),
                ("external_id", models.CharField(help_text="Server ID from the platform", max_length=100, unique=True)),
                ("url", models.URLField(blank=True, max_length=1000, null=True)),
                ("cover_image", models.URLField(blank=True, max_length=1000, null=True)),
                ("reading_time_minutes", models.PositiveIntegerField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="OsshCommunity",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255, unique=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("website", models.URLField(help_text="Direct link to the community", unique=True)),
                ("source", models.CharField(help_text="Source API (GitHub, Dev.to, etc.)", max_length=100)),
                (
                    "category",
                    models.CharField(
                        choices=[("forum", "Forum"), ("community", "Community"), ("mentorship", "Mentorship Program")],
                        default="community",
                        max_length=20,
                    ),
                ),
                (
                    "external_id",
                    models.CharField(
                        blank=True, help_text="ID from external source", max_length=255, null=True, unique=True
                    ),
                ),
                ("metadata", models.JSONField(default=dict, help_text="Additional API-specific metadata")),
                ("contributors_count", models.IntegerField(default=0, help_text="Approximate number of contributors")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="OsshDiscussionChannel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=200)),
                ("description", models.TextField(blank=True, null=True)),
                ("source", models.CharField(help_text="Source API (Discord, Slack etc)", max_length=100)),
                ("external_id", models.CharField(help_text="Server ID from the platform", max_length=100, unique=True)),
                ("member_count", models.PositiveIntegerField(default=0)),
                ("invite_url", models.URLField(blank=True, null=True)),
                ("logo_url", models.URLField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.AddField(
            model_name="repo",
            name="is_owasp_repo",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="ossharticle",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="articles", to="website.tag"),
        ),
        migrations.AddField(
            model_name="osshcommunity",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="communities", to="website.tag"),
        ),
        migrations.AddField(
            model_name="osshdiscussionchannel",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="channels", to="website.tag"),
        ),
        migrations.RunPython(set_is_owasp_repo),
    ]
