# Generated by Django 5.1.6 on 2025-03-10 04:29

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0224_githubissue_sponsors_tx_id"),
    ]

    operations = [
        migrations.CreateModel(
            name="Hackathon",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255)),
                ("slug", models.SlugField(blank=True, max_length=255, unique=True)),
                ("description", models.TextField()),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField()),
                ("banner_image", models.ImageField(blank=True, null=True, upload_to="hackathon_banners")),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("is_active", models.BooleanField(default=True)),
                ("rules", models.TextField(blank=True, null=True)),
                ("registration_open", models.BooleanField(default=True)),
                ("max_participants", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="hackathons",
                        to="website.organization",
                    ),
                ),
                ("repositories", models.ManyToManyField(blank=True, related_name="hackathons", to="website.repo")),
            ],
            options={
                "ordering": ["-start_time"],
            },
        ),
        migrations.CreateModel(
            name="HackathonSponsor",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "sponsor_level",
                    models.CharField(
                        choices=[
                            ("platinum", "Platinum"),
                            ("gold", "Gold"),
                            ("silver", "Silver"),
                            ("bronze", "Bronze"),
                            ("partner", "Partner"),
                        ],
                        default="partner",
                        max_length=20,
                    ),
                ),
                ("logo", models.ImageField(blank=True, null=True, upload_to="hackathon_sponsor_logos")),
                ("website", models.URLField(blank=True, null=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "hackathon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="sponsors", to="website.hackathon"
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sponsored_hackathons",
                        to="website.organization",
                    ),
                ),
            ],
            options={
                "ordering": ["sponsor_level", "created"],
            },
        ),
        migrations.CreateModel(
            name="HackathonPrize",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "position",
                    models.PositiveIntegerField(
                        choices=[(1, "First Place"), (2, "Second Place"), (3, "Third Place"), (4, "Special Prize")]
                    ),
                ),
                ("title", models.CharField(max_length=255)),
                ("description", models.TextField()),
                ("value", models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                (
                    "hackathon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="prizes", to="website.hackathon"
                    ),
                ),
                (
                    "sponsor",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="prizes",
                        to="website.hackathonsponsor",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
            },
        ),
        migrations.AddIndex(
            model_name="hackathon",
            index=models.Index(fields=["start_time"], name="hackathon_start_idx"),
        ),
        migrations.AddIndex(
            model_name="hackathon",
            index=models.Index(fields=["organization"], name="hackathon_org_idx"),
        ),
        migrations.AddConstraint(
            model_name="hackathon",
            constraint=models.UniqueConstraint(fields=("slug",), name="unique_hackathon_slug"),
        ),
        migrations.AlterUniqueTogether(
            name="hackathonsponsor",
            unique_together={("hackathon", "organization")},
        ),
        migrations.AlterUniqueTogether(
            name="hackathonprize",
            unique_together={("hackathon", "position")},
        ),
    ]
