# Generated by Django 5.1.7 on 2025-03-14 01:10

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0230_queue_txid_queue_url"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name="organization",
            name="check_ins_enabled",
            field=models.BooleanField(default=False, help_text="Indicates if the organization has check-ins enabled"),
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("message", models.TextField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("is_read", models.BooleanField(default=False)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "notification_type",
                    models.CharField(
                        choices=[
                            ("general", "General"),
                            ("alert", "Alert"),
                            ("reminder", "Reminder"),
                            ("promo", "Promotional"),
                            ("reward", "Rewards"),
                        ],
                        default="general",
                        max_length=50,
                    ),
                ),
                ("link", models.CharField(blank=True, max_length=200, null=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["is_read", "-created_at"],
            },
        ),
    ]
