# Generated by Django 5.1.7 on 2025-03-13 09:33

import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0231_organization_check_ins_enabled_notification"),
    ]

    operations = [
        migrations.CreateModel(
            name="BannedApp",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("country_name", models.CharField(max_length=100)),
                ("country_code", models.CharField(max_length=2)),
                ("app_name", models.CharField(max_length=100)),
                (
                    "app_type",
                    models.CharField(
                        choices=[
                            ("social", "Social Media"),
                            ("messaging", "Messaging"),
                            ("gaming", "Gaming"),
                            ("streaming", "Streaming"),
                            ("other", "Other"),
                        ],
                        max_length=20,
                    ),
                ),
                ("ban_reason", models.TextField()),
                ("ban_date", models.DateField(default=django.utils.timezone.now)),
                ("source_url", models.URLField(blank=True)),
                ("is_active", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Banned App",
                "verbose_name_plural": "Banned Apps",
                "ordering": ["country_name", "app_name"],
                "indexes": [
                    models.Index(fields=["country_name"], name="website_ban_country_980b5d_idx"),
                    models.Index(fields=["country_code"], name="website_ban_country_119ba5_idx"),
                ],
            },
        ),
    ]
