COMMON_TECHNOLOGIES = [
    "react",
    "angular",
    "vue.js",
    "node.js",
    "django",
    "flask",
    "spring",
    "laravel",
    "ruby on rails",
    "express.js",
    "asp.net",
    "tensorflow",
    "pytorch",
    "keras",
    "docker",
    "kubernetes",
    "ansible",
    "terraform",
    "jenkins",
    "git",
    "github",
    "gitlab",
    "bitbucket",
    "aws",
    "azure",
    "google cloud",
    "firebase",
    "heroku",
    "postgresql",
    "mysql",
    "mongodb",
    "redis",
    "elasticsearch",
    "apache kafka",
    "rabbitmq",
    "graphql",
    "rest api",
    "grpc",
    "flutter",
    "react native",
    "xamarin",
    "electron",
    "webpack",
    "babel",
    "sass",
    "less",
    "tailwind css",
    "bootstrap",
    "jquery",
    "redux",
    "mobx",
    "jest",
    "mocha",
    "cypress",
    "selenium",
    "puppeteer",
    "linux",
    "windows",
    "macos",
    "android",
    "ios",
    "arduino",
    "raspberry pi",
    "blockchain",
    "ethereum",
    "solidity",
    "bitcoin",
    "machine learning",
    "artificial intelligence",
    "big data",
    "hadoop",
    "spark",
    "tableau",
    "power bi",
    "agile",
    "scrum",
    "kanban",
    "devops",
    "ci/cd",
    "microservices",
    "serverless",
    "edge computing",
    "quantum computing",
    "augmented reality",
    "virtual reality",
    "iot",
    "5g",
    "numpy",
    "pandas",
    "matplotlib",
    "seaborn",
    "scikit-learn",
    "opencv",
    "unity",
    "unreal engine",
    "blender",
    "figma",
    "sketch",
    "adobe xd",
    "zeplin",
    "invision",
    "jira",
    "trello",
]

PROGRAMMING_LANGUAGES = [
    "python",
    "javascript",
    "java",
    "c",
    "c++",
    "c#",
    "php",
    "ruby",
    "swift",
    "go",
    "rust",
    "typescript",
    "kotlin",
    "r",
    "bash",
    "perl",
    "scala",
    "dart",
    "html",
    "css",
    "sql",
]

COMMON_TOPICS = [
    "algorithms",
    "data structures",
    "object-oriented programming",
    "functional programming",
    "networking",
    "databases",
    "cloud computing",
    "software engineering",
    "cybersecurity",
    "cryptography",
    "data science",
    "machine learning",
    "deep learning",
    "artificial intelligence",
    "natural language processing",
    "computer vision",
    "data mining",
    "big data",
    "data analytics",
    "web development",
    "mobile development",
    "embedded systems",
    "robotics",
    "operating systems",
    "compilers",
    "distributed systems",
    "parallel computing",
    "devops",
    "agile methodologies",
    "scrum",
    "kanban",
    "software testing",
    "unit testing",
    "integration testing",
    "continuous integration",
    "continuous deployment",
    "version control",
    "code reviews",
    "design patterns",
    "software architecture",
    "system design",
    "user experience",
    "user interface design",
    "human-computer interaction",
    "data visualization",
    "internet of things",
    "blockchain",
    "virtual reality",
    "augmented reality",
    "edge computing",
    "quantum computing",
    "game development",
    "computer graphics",
    "network security",
    "performance optimization",
    "cloud architecture",
    "microservices",
    "serverless computing",
    "API development",
    "test-driven development",
    "behavior-driven development",
    "clean code",
    "refactoring",
    "open source",
    "software licensing",
    "data privacy",
    "information security",
    "protocols",
    "REST",
    "SOAP",
    "gRPC",
    "GraphQL",
    "authentication",
    "authorization",
    "encryption",
    "real-time systems",
    "load balancing",
    "scalability",
    "fault tolerance",
    "containerization",
    "automation",
    "scripting",
    "deployment pipelines",
]

TAG_NORMALIZATION = {
    # Programming Languages
    "py": "python",
    "python3": "python",
    "python2": "python",
    "js": "javascript",
    "javascript": "javascript",
    "ts": "typescript",
    "typescript": "typescript",
    "cs": "csharp",
    "csharp": "c#",
    "c#": "c#",
    "cpp": "c++",
    "cplusplus": "c++",
    "c++": "c++",
    "rb": "ruby",
    "ruby": "ruby",
    "pl": "perl",
    "perl": "perl",
    "php5": "php",
    "php7": "php",
    "php8": "php",
    "php": "php",
    "go lang": "go",
    "golang": "go",
    "go": "go",
    "rs": "rust",
    "rust": "rust",
    "sc": "scala",
    "scala": "scala",
    "kt": "kotlin",
    "kotlin": "kotlin",
    "swiftui": "swift",
    "swift": "swift",
    "objc": "objective-c",
    "obj-c": "objective-c",
    "objectivec": "objective-c",
    "f#": "fsharp",
    "fsharp": "f#",
    "vb": "visual basic",
    "vb.net": "visual basic",
    "vba": "visual basic",
    "visualbasic": "visual basic",
    "dartlang": "dart",
    "dart": "dart",
    "r-lang": "r",
    "rlang": "r",
    "r": "r",
    "bash": "bash",
    "shell": "bash",
    "powershell": "powershell",
    # Frameworks and Libraries
    "reactjs": "react",
    "react.js": "react",
    "react": "react",
    "angularjs": "angular",
    "angular.js": "angular",
    "angular": "angular",
    "vuejs": "vue.js",
    "vue.js": "vue.js",
    "vue": "vue.js",
    "nextjs": "next.js",
    "next.js": "next.js",
    "next": "next.js",
    "nuxtjs": "nuxt.js",
    "nuxt.js": "nuxt.js",
    "nuxt": "nuxt.js",
    "sveltejs": "svelte",
    "svelte": "svelte",
    "nodejs": "node.js",
    "node.js": "node.js",
    "node": "node.js",
    "expressjs": "express",
    "express.js": "express",
    "express": "express",
    "djangorest": "django",
    "djangoframework": "django",
    "django": "django",
    "flaskweb": "flask",
    "flask": "flask",
    "fastapi": "fastapi",
    "springboot": "spring",
    "springframework": "spring",
    "spring": "spring",
    "laravelframework": "laravel",
    "laravel": "laravel",
    "rails": "ruby on rails",
    "rubyonrails": "ruby on rails",
    "ror": "ruby on rails",
    "ruby on rails": "ruby on rails",
    "aspnet": "asp.net",
    "asp.netcore": "asp.net",
    "asp.net": "asp.net",
    "dotnet": ".net",
    ".netcore": ".net",
    ".net": ".net",
    "symfony": "symfony",
    "codeigniter": "codeigniter",
    "cakephp": "cakephp",
    "zend": "zend framework",
    "meteorjs": "meteor.js",
    "meteor": "meteor.js",
    "emberjs": "ember.js",
    "ember": "ember.js",
    "backbonejs": "backbone.js",
    "backbone": "backbone.js",
    # Databases
    "postgres": "postgresql",
    "postgresql": "postgresql",
    "postgre": "postgresql",
    "mysqlserver": "mysql",
    "mysql": "mysql",
    "mariadb": "mysql",
    "mongodb": "mongodb",
    "mongo": "mongodb",
    "redisdb": "redis",
    "redis": "redis",
    "sqlite3": "sqlite",
    "sqlite": "sqlite",
    "sqlserver": "sql server",
    "mssql": "sql server",
    "oracle": "oracle",
    "firebase": "firebase",
    "dynamodb": "dynamodb",
    "cassandra": "cassandra",
    "couchdb": "couchdb",
    "couchbase": "couchbase",
    "neodb": "neo4j",
    "neo4j": "neo4j",
    "elasticsearch": "elasticsearch",
    # Tools and Platforms
    "awscloud": "aws",
    "amazonwebservices": "aws",
    "aws": "aws",
    "azurecloud": "azure",
    "azure": "azure",
    "gcp": "google cloud",
    "googlecloud": "google cloud",
    "google cloud platform": "google cloud",
    "herokuplatform": "heroku",
    "heroku": "heroku",
    "dockercontainer": "docker",
    "docker": "docker",
    "kubernetescluster": "kubernetes",
    "kubernetes": "kubernetes",
    "k8s": "kubernetes",
    "gitversioncontrol": "git",
    "git": "git",
    "githubrepo": "github",
    "github": "github",
    "gitlabci": "gitlab",
    "gitlab": "gitlab",
    "bitbucketrepo": "bitbucket",
    "bitbucket": "bitbucket",
    "jenkinspipeline": "jenkins",
    "jenkins": "jenkins",
    "ansibleautomation": "ansible",
    "ansible": "ansible",
    "terraformiac": "terraform",
    "terraform": "terraform",
    "puppet": "puppet",
    "chef": "chef",
    "vagrant": "vagrant",
    "travisci": "travis ci",
    "travis": "travis ci",
    "circleci": "circle ci",
    "teamcity": "teamcity",
    "bamboo": "bamboo",
    "npm": "npm",
    "yarn": "yarn",
    "pnpm": "pnpm",
    "webpack": "webpack",
    "gulp": "gulp",
    "grunt": "grunt",
    "babel": "babel",
    "eslint": "eslint",
    "prettier": "prettier",
    # AI/ML/DL
    "tensorflow2": "tensorflow",
    "tf": "tensorflow",
    "tensorflow": "tensorflow",
    "pytorchlib": "pytorch",
    "pytorch": "pytorch",
    "keraslib": "keras",
    "keras": "keras",
    "scikitlearn": "scikit-learn",
    "sklearn": "scikit-learn",
    "scikit learn": "scikit-learn",
    "opencvlib": "opencv",
    "opencv": "opencv",
    "numpylib": "numpy",
    "numpy": "numpy",
    "pandaslib": "pandas",
    "pandas": "pandas",
    "matplotliblib": "matplotlib",
    "matplotlib": "matplotlib",
    "seabornlib": "seaborn",
    "seaborn": "seaborn",
    "xgboost": "xgboost",
    "lightgbm": "lightgbm",
    "nlp": "natural language processing",
    # Mobile Development
    "reactnative": "react native",
    "react native": "react native",
    "flutterapp": "flutter",
    "flutter": "flutter",
    "xamarinforms": "xamarin",
    "xamarin": "xamarin",
    "androidstudio": "android",
    "android": "android",
    "iosdev": "ios",
    "ios": "ios",
    # Web Development
    "html5": "html",
    "html": "html",
    "css3": "css",
    "css": "css",
    "sasscss": "sass",
    "sass": "sass",
    "scss": "sass",
    "lesscss": "less",
    "less": "less",
    "tailwindcss": "tailwind css",
    "tailwind": "tailwind css",
    "bootstrapcss": "bootstrap",
    "bootstrap": "bootstrap",
    "jqueryjs": "jquery",
    "jquery": "jquery",
    "webpackjs": "webpack",
    "babeljs": "babel",
    "gulpjs": "gulp",
    "gruntjs": "grunt",
    "pugjs": "pug",
    "pug": "pug",
    "handlebarsjs": "handlebars",
    "handlebars": "handlebars",
    "ejs": "ejs",
    # Markup and Formatting Languages
    "markdown": "markdown",
    "md": "markdown",
    "yaml": "yaml",
    "json": "json",
    "xml": "xml",
    "toml": "toml",
    "ini": "ini",
    # Operating Systems
    "linux": "linux",
    "ubuntu": "linux",
    "debian": "linux",
    "centos": "linux",
    "redhat": "linux",
    "fedora": "linux",
    "archlinux": "linux",
    "kalilinux": "linux",
    "windows": "windows",
    "win": "windows",
    "macos": "macos",
    "osx": "macos",
    # Other Technologies
    "arduino": "arduino",
    "raspberrypi": "raspberry pi",
    "raspberry pi": "raspberry pi",
    "blockchaintech": "blockchain",
    "blockchain": "blockchain",
    "ethereumchain": "ethereum",
    "ethereum": "ethereum",
    "soliditylang": "solidity",
    "solidity": "solidity",
    "bitcoincrypto": "bitcoin",
    "bitcoin": "bitcoin",
    "machinelearning": "machine learning",
    "ml": "machine learning",
    "artificialintelligence": "artificial intelligence",
    "ai": "artificial intelligence",
    "deeplearning": "deep learning",
    "dl": "deep learning",
    "bigdata": "big data",
    "big data": "big data",
    "virtualreality": "virtual reality",
    "vr": "virtual reality",
    "augmentedreality": "augmented reality",
    "ar": "augmented reality",
    "internetofthings": "iot",
    "iot": "iot",
    "devopspractice": "devops",
    "devops": "devops",
    "cicd": "ci/cd",
    "ci/cd": "ci/cd",
    "microservicesarch": "microservices",
    "microservices": "microservices",
    "serverlessarch": "serverless",
    "serverless": "serverless",
    "robotics": "robotics",
    "automl": "automl",
    "datascience": "data science",
    "data science": "data science",
    "dataanalysis": "data analysis",
    "data analysis": "data analysis",
    "datavisualization": "data visualization",
    "data visualization": "data visualization",
    "chatbot": "chatbot",
    "automation": "automation",
    "graphql": "graphql",
    "restapi": "rest api",
    "rest api": "rest api",
    "grpc": "grpc",
    "dockercompose": "docker compose",
    "docker-compose": "docker compose",
    "kafka": "apache kafka",
    "apachekafka": "apache kafka",
    "hadoop": "hadoop",
    "spark": "apache spark",
    "apache spark": "apache spark",
    "tableau": "tableau",
    "powerbi": "power bi",
    "jira": "jira",
    "trello": "trello",
    "slack": "slack",
    "microsoftteams": "microsoft teams",
    "microsoft teams": "microsoft teams",
    "zoom": "zoom",
    "vscode": "visual studio code",
    "visualstudiocode": "visual studio code",
    "intellij": "intellij idea",
    "intellijidea": "intellij idea",
    "pycharm": "pycharm",
    "sublime": "sublime text",
    "atom": "atom",
    "emacs": "emacs",
    "vim": "vim",
    "nano": "nano",
    "notepad++": "notepad++",
    "unity3d": "unity",
    "unrealengine": "unreal engine",
    "blender3d": "blender",
    "figma": "figma",
    "adobexd": "adobe xd",
    "sketchapp": "sketch",
    "kibana": "kibana",
    "grafana": "grafana",
    "prometheus": "prometheus",
    "selenium": "selenium",
    "cypress": "cypress",
    "jest": "jest",
    "mocha": "mocha",
    "chai": "chai",
    "enzyme": "enzyme",
    "puppeteer": "puppeteer",
    "pytest": "pytest",
    "junit": "junit",
    "maven": "maven",
    "gradle": "gradle",
    "ant": "ant",
}

GSOC25_PROJECTS = {
    "BLT": [
        "OWASP-BLT/BLT",
        "OWASP-BLT/BLT-Flutter",
        "OWASP-BLT/BLT-Bacon",
        "OWASP-BLT/BLT-Action",
        "OWASP-BLT/BLT-Extension",
    ],
    "NEST": ["OWASP/Nest"],
    "NETTACKER": ["OWASP/Nettacker"],
    "JUICE-SHOP": ["juice-shop/juice-shop", "juice-shop/multi-juicer"],
    "DSOMM": ["devsecopsmaturitymodel/DevSecOps-MaturityModel"],
    "PYGOAT": ["adeyosemanputra/PyGoat"],
    "OpenCRE": ["OWASP/OpenCRE"],
}
