---
title: "Compiler Error CS0304 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0304"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0304"
ms.assetid: 22dc7211-57a8-4c92-96f6-fc1cf0263b68
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0304
Cannot create an instance of the variable type 'type' because it does not have the new() constraint  
  
 When you implement a generic class, and you want to use the `new` keyword to create a new instance of any type that is supplied for a type parameter `T`, you must apply the [new() constraint](../../../csharp/language-reference/keywords/new.md) to `T` in the class declaration, as shown in the following example.  
  
```cs  
class C<T> where T : new()  
```  
  
 The `new()` constraint enforces type safety by guaranteeing that any concrete type that is supplied for `T` has a default, parameterless constructor. CS0304 occurs if you attempt to use the `new` operator in the body of the class to create an instance of type parameter `T` when `T` does not specify the `new()` constraint. On the client side, if code attempts to instantiate the generic class with a type that has no default constructor, that code will generate [Compiler Error CS0310](../../../csharp/language-reference/compiler-messages/cs0310.md).  
  
 The following example generates CS0304.  
  
```cs  
  
// CS0304.cs  
// Compile with: /target:library.  
class C<T>  
{  
    // The following line generates CS0304.  
    T t = new T();  
}  
  
```  
  
 The `new` operator also is not allowed in methods of the class.  
  
```cs  
  
// Compile with: /target:library.  
class C<T>  
{  
    public void ExampleMethod()  
    {  
        // The following line generates CS0304.  
        T t = new T();  
    }  
}  
  
```  
  
 To avoid the error, declare the class by using the `new()` constraint, as shown in the following example.  
  
```cs  
  
// Compile with: /target:library.  
class C<T> where T : new()  
{  
    T t = new T();  
  
    public void ExampleMethod()  
    {  
        T t = new T();  
    }  
}  
  
```  
  
## See Also  
 [C# Compiler Errors](../../../csharp/language-reference/compiler-messages/index.md)