---
title: "Compiler Error CS1061 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1061"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1061"
ms.assetid: 10ba0509-d541-43da-acf5-eaa7987e41d4
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1061
'type' does not contain a definition for 'member' and no extension method 'name' accepting a first argument of type 'type' could be found (are you missing a using directive or an assembly reference?).  
  
 This error occurs when you try to call a method or access a class member that does not exist.  
  
## Example  
 The following example generates CS1061 because `TestClass1` does not have a `DisplaySomething` method. It does have a method that is called `WriteSomething`. Perhaps that is what the author of this source code meant to write.  
  
```cs  
// cs1061.cs  
public class TestClass1  
{  
    // TestClass1 has one method, called WriteSomething.  
    public void WriteSomething(string s)  
    {  
        System.Console.WriteLine(s);  
    }  
}  
  
public class TestClass2  
{  
    // TestClass2 has one method, called DisplaySomething.  
    public void DisplaySomething(string s)  
    {  
        System.Console.WriteLine(s);  
    }  
}  
  
public class TestTheClasses  
{  
    public static void Main()  
    {  
        TestClass1 tc1 = new TestClass1();  
        TestClass2 tc2 = new TestClass2();  
        // The following call fails because TestClass1 does not have   
        // a method called DisplaySomething.  
        tc1.DisplaySomething("Hello");      // CS1061  
  
        // To correct the error, change the method call to either   
        // tc1.WriteSomething or tc2.DisplaySomething.  
        tc1.WriteSomething("Hello from TestClass1");  
        tc2.DisplaySomething("Hello from TestClass2");  
    }  
}  
```  
  
## See Also  
 [Classes and Structs](../../../csharp/programming-guide/classes-and-structs/index.md)   
 [Extension Methods](../../../csharp/programming-guide/classes-and-structs/extension-methods.md)