---
title: "-debug (C# Compiler Options) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "/debug"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "debug compiler option [C#]"
  - "-debug compiler option [C#]"
  - "/debug compiler option [C#]"
ms.assetid: e2b48c07-01bc-45cc-a52c-92e9085eb969
caps.latest.revision: 19
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# /debug (C# Compiler Options)
The **/debug** option causes the compiler to generate debugging information and place it in the output file or files.  
  
## Syntax  
  
```  
/debug[+ | -]  
/debug:{full | pdbonly}  
```  
  
## Arguments  
 `+` &#124; `-`  
 Specifying `+`, or just **/debug**, causes the compiler to generate debugging information and place it in a program database (.pdb file). Specifying `-`, which is in effect if you do not specify **/debug**, causes no debug information to be created.  
  
 `full` &#124; `pdbonly`  
 Specifies the type of debugging information generated by the compiler. The full argument, which is in effect if you do not specify **/debug:pdbonly**, enables attaching a debugger to the running program. Specifying pdbonly allows source code debugging when the program is started in the debugger but will only display assembler when the running program is attached to the debugger.  
  
## Remarks  
 Use this option to create debug builds. If **/debug**, **/debug+**, or **/debug:full** is not specified, you will not be able to debug the output file of your program.  
  
 If you use **/debug:full**, be aware that there is some impact on the speed and size of JIT optimized code and a small impact on code quality with **/debug:full**. We recommend **/debug:pdbonly** or no PDB for generating release code.  
  
> [!NOTE]
>  One difference between **/debug:pdbonly** and **/debug:full** is that with **/debug:full** the compiler emits a <xref:System.Diagnostics.DebuggableAttribute>, which is used to tell the JIT compiler that debug information is available. Therefore, you will get an error if your code contains the <xref:System.Diagnostics.DebuggableAttribute> set to false if you use **/debug:full**.  
  
 For more information on how to configure the debug performance of an application, see [Making an Image Easier to Debug](http://msdn.microsoft.com/library/7d90ea7a-150f-4f97-98a7-f9c26541b9a3).  
  
 To change the location of the .pdb file, see [/pdb (C# Compiler Options)](../../../csharp/language-reference/compiler-options/pdb-compiler-option.md).  
  
### To set this compiler option in the Visual Studio development environment  
  
1.  Open the project's **Properties** page.  
  
2.  Click the **Build** property page.  
  
3.  Click the **Advanced** button.  
  
4.  Modify the **Debug Info** property.  
  
 For information on how to set this compiler option programmatically, see <xref:VSLangProj80.CSharpProjectConfigurationProperties3.DebugSymbols%2A>.  
  
## Example  
 Place debugging information in output file `app.pdb`:  
  
```  
csc /debug /pdb:app.pdb test.cs  
```  
  
## See Also  
 [C# Compiler Options](../../../csharp/language-reference/compiler-options/index.md)   
 [NIB How to: Modify Project Properties and Configuration Settings](http://msdn.microsoft.com/en-us/e7184bc5-2f2b-4b4f-aa9a-3ecfcbc48b67)