# [C# Keywords](index.md)
## [Types](types.md)
### [Value Types](value-types.md)
#### [bool](bool.md)
#### [byte](byte.md)
#### [char](char.md)
#### [decimal](decimal.md)
#### [double](double.md)
#### [enum](enum.md)
#### [float](float.md)
#### [int](int.md)
#### [long](long.md)
#### [sbyte](sbyte.md)
#### [short](short.md)
#### [struct](struct.md)
#### [uint](uint.md)
#### [ulong](ulong.md)
#### [ushort](ushort.md)
### [Reference Types](reference-types.md)
#### [class](class.md)
#### [delegate](delegate.md)
#### [dynamic](dynamic.md)
#### [interface](interface.md)
#### [object](object.md)
#### [string](string.md)
#### [Interpolated Strings (C# and Visual Basic Reference)](interpolated-strings.md)
### [void](void.md)
### [var](var.md)
### [Reference Tables for Types](reference-tables-for-types.md)
#### [Built-In Types Table](built-in-types-table.md)
#### [Integral Types Table](integral-types-table.md)
#### [Floating-Point Types Table](floating-point-types-table.md)
#### [Default Values Table](default-values-table.md)
#### [Value Types Table](value-types-table.md)
#### [Implicit Numeric Conversions Table](implicit-numeric-conversions-table.md)
#### [Explicit Numeric Conversions Table](explicit-numeric-conversions-table.md)
#### [Formatting Numeric Results Table](formatting-numeric-results-table.md)
## [Modifiers](modifiers.md)
### [Access Modifiers](access-modifiers.md)
#### [Accessibility Levels](accessibility-levels.md)
#### [Accessibility Domain](accessibility-domain.md)
#### [Restrictions on Using Accessibility Levels](restrictions-on-using-accessibility-levels.md)
#### [internal](internal.md)
#### [private](private.md)
#### [protected](protected.md)
#### [public](public.md)
### [abstract](abstract.md)
### [async](async.md)
### [const](const.md)
### [event](event.md)
### [extern](extern.md)
### [in (Generic Modifier)](in-generic-modifier.md)
### [out (Generic Modifier)](out-generic-modifier.md)
### [override](override.md)
### [readonly](readonly.md)
### [sealed](sealed.md)
### [static](static.md)
### [unsafe](unsafe.md)
### [virtual](virtual.md)
### [volatile](volatile.md)
## [Statement Keywords](statement-keywords.md)
### [Selection Statements](selection-statements.md)
#### [if-else](if-else.md)
#### [switch](switch.md)
### [Iteration Statements](iteration-statements.md)
#### [do](do.md)
#### [for](for.md)
#### [foreach, in](foreach-in.md)
#### [while](while.md)
### [Jump Statements](jump-statements.md)
#### [break](break.md)
#### [continue](continue.md)
#### [goto](goto.md)
#### [return](return.md)
### [Exception Handling Statements](exception-handling-statements.md)
#### [throw](throw.md)
#### [try-catch](try-catch.md)
#### [try-finally](try-finally.md)
#### [try-catch-finally](try-catch-finally.md)
### [Checked and Unchecked](checked-and-unchecked.md)
#### [checked](checked.md)
#### [unchecked](unchecked.md)
### [fixed Statement](fixed-statement.md)
### [lock Statement](lock-statement.md)
## [Method Parameters](method-parameters.md)
### [params](params.md)
### [ref](ref.md)
### [out (Parameter Modifier)](out-parameter-modifier.md)
## [Namespace Keywords](namespace-keywords.md)
### [namespace](namespace.md)
### [using](using.md)
#### [using Directive](using-directive.md)
#### [using Statement](using-statement.md)
### [extern alias](extern-alias.md)
## [Operator Keywords](operator-keywords.md)
### [as](as.md)
### [await](await.md)
### [is](is.md)
### [new](new.md)
#### [new Operator](new-operator.md)
#### [new Modifier](new-modifier.md)
#### [new Constraint](new-constraint.md)
### [sizeof](sizeof.md)
### [typeof](typeof.md)
### [true](true.md)
#### [true Operator](true-operator.md)
#### [true Literal](true-literal.md)
### [false](false.md)
#### [false Operator](false-operator.md)
#### [false Literal](false-literal.md)
### [stackalloc](stackalloc.md)
### [nameof (C# and Visual Basic Reference)](nameof.md)
## [Conversion Keywords](conversion-keywords.md)
### [explicit](explicit.md)
### [implicit](implicit.md)
### [operator2](operator.md)
## [Access Keywords](access-keywords.md)
### [base](base.md)
### [this](this.md)
## [Literal Keywords](literal-keywords.md)
### [null](null.md)
### [default](default.md)
## [Contextual Keywords](contextual-keywords.md)
### [add](add.md)
### [get](get.md)
### [global](global.md)
### [partial (Type)](partial-type.md)
### [partial (Method)](partial-method.md)
### [remove](remove.md)
### [set](set.md)
### [when (filter condition)](when.md)
### [where (generic type constraint)](where-generic-type-constraint.md)
### [value](value.md)
### [yield](yield.md)
## [Query Keywords](query-keywords.md)
### [from clause](from-clause.md)
### [where clause](where-clause.md)
### [select clause](select-clause.md)
### [group clause](group-clause.md)
### [into](into.md)
### [orderby clause](orderby-clause.md)
### [join clause](join-clause.md)
### [let clause](let-clause.md)
### [ascending](ascending.md)
### [descending](descending.md)
### [on](on.md)
### [equals](equals.md)
### [by](by.md)
### [in](in.md)

