---
title: "Compiler Error CS0073 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0073"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0073"
ms.assetid: 579ae534-59ab-4fc5-ad7e-f87639f3f9cd
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0073
An add or remove accessor must have a body  
  
 An **add** or **remove** keyword in an [event](../../csharp/language-reference/keywords/event.md) definition must have a body. For more information, see [Events](../../csharp/programming-guide/events/index.md).  
  
 The following sample generates CS0073:  
  
```  
// CS0073.cs  
delegate void del();  
  
class Test  
{  
   public event del MyEvent  
   {  
      add;   // CS0073  
      // try the following lines instead  
      // add  
      // {  
      //    MyEvent += value;  
      // }  
      remove  
      {  
         MyEvent -= value;  
      }  
  
   }  
  
   public static void Main()  
   {  
   }  
}  
```