---
title: "Compiler Error CS1569 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1569"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1569"
ms.assetid: 1d5e89d6-0a05-4e4f-b472-9089146696bb
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1569
Error generating XML documentation file 'Filename' ('reason')  
  
 When attempting to write the XML documentation to the file named in the message, an error occurred for the reason specified. The reason may be something like "network drive not found," or "access denied." Often, the reason will suggest what needs to be done to correct the error. For example, if the error says "access denied," you would verify that you have write permission on the file.  
  
## Example  
  
```  
// 1569a.cs  
// compile with: /doc:CS1569.xml  
// post-build command: attrib +r CS1569.xml  
class Test  
{  
   /// <summary>Test.</summary>  
   public static void Main() {}  
}  
```  
  
## Example  
 The previous sample generated an .xml file that was then set to read only. This sample attempts to write to the same file. The following sample generates CS1569.  
  
```  
// CS1569.cs  
// compile with: /doc:CS1569.xml  
// CS1569 expected  
class Test  
{  
   /// <summary>Test.</summary>  
   public static void Main() {}  
}  
  
```