---
title: "Compiler Error CS1940 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1940"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1940"
ms.assetid: 546e9bba-725d-4ea9-826f-37ec9d832add
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1940
Multiple implementations of the query pattern were found for source type 'type'. Ambiguous call to 'method'.  
  
 This error is generated when multiple implementations of a query method are defined and the compiler cannot disambiguate which one is best to use for the query. In the following example, both versions of `Select` have the same signature, because they both accept one `int` as an input parameter and have `int` as a return value.  
  
## To correct this error  
  
1.  Provide only one implementation for each method.  
  
## Example  
 The following code generates CS1940:  
  
```  
// cs1940.cs  
using System; //must include explicitly for types defined in 3.5  
class Test  
{  
    public delegate int Dele(int x);  
    int num = 0;  
    public int Select(Func<int, int> d)  
    {  
        return d(this.num);  
    }  
    public int Select(Dele d) // CS1940  
    {  
        return d(this.num) + 1;  
    }  
    public static void Main()  
    {  
        var q = from x in new Test()  
        select x;  
    }  
}  
```  
  
## See Also  
 [Standard Query Operators Overview](http://msdn.microsoft.com/library/24cda21e-8af8-4632-b519-c404a839b9b2)