---
title: "Programming Concepts (C#) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
ms.assetid: 3227afd5-4794-484b-b83b-0f1f94a0476b
caps.latest.revision: 4
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Programming Concepts (C#)
This section explains programming concepts in the C# language.  
  
## In This Section  
  
|Title|Description|  
|-----------|-----------------|  
|[Assemblies and the Global Assembly Cache (C#)](../../../csharp/programming-guide/concepts/assemblies-gac/index.md)|Describes how to create and use assemblies.|  
|[Asynchronous Programming with async and await (C#)](../../../csharp/programming-guide/concepts/async/index.md)|Describes how to write asynchronous solutions by using the [async](../../../csharp/language-reference/keywords/async.md) and [await](../../../csharp/language-reference/keywords/await.md) keywords in C#. Includes a walkthrough.|  
|[Attributes (C#)](../../../csharp/programming-guide/concepts/attributes/index.md)|Discusses how to provide additional information about programming elements such as types, fields, methods, and properties by using attributes.|  
|[Caller Information (C#)](../../../csharp/programming-guide/concepts/caller-information.md)|Describes how to obtain information about the caller of a method. This information includes the file path and the line number of the source code and the member name of the caller.|  
|[Collections (C#)](../../../csharp/programming-guide/concepts/collections.md)|Describes some of the types of collections provided by the .NET Framework. Demonstrates how to use simple collections and collections of key/value pairs.|  
|[Covariance and Contravariance (C#)](../../../csharp/programming-guide/concepts/covariance-contravariance/index.md)|Shows how to enable implicit conversion of generic type parameters in interfaces and delegates.|  
|[Expression Trees (C#)](../../../csharp/programming-guide/concepts/expression-trees/index.md)|Explains how you can use expression trees to enable dynamic modification of executable code.|  
|[Iterators (C#)](../../../csharp/programming-guide/concepts/iterators.md)|Describes iterators, which are used to step through collections and return elements one at a time.|  
|[Language-Integrated Query (LINQ) (C#)](../../../csharp/programming-guide/concepts/linq/index.md)|Discusses the powerful query capabilities in the language syntax of C#, and the model for querying relational databases, XML documents, datasets, and in-memory collections.|  
|[Object-Oriented Programming (C#)](../../../csharp/programming-guide/concepts/object-oriented-programming.md)|Describes common object-oriented concepts, including encapsulation, inheritance, and polymorphism.|  
|[Reflection (C#)](../../../csharp/programming-guide/concepts/reflection.md)|Explains how to use reflection to dynamically create an instance of a type, bind the type to an existing object, or get the type from an existing object and invoke its methods or access its fields and properties.|  
|[Serialization (C# )](../../../csharp/programming-guide/concepts/serialization/index.md)|Describes key concepts in binary, XML, and SOAP serialization.|  
|[Threading (C#)](../../../csharp/programming-guide/concepts/threading/index.md)|Provides an overview of the .NET threading model and shows how to write code that performs multiple tasks at the same time to improve the performance and responsiveness of your applications.|  
  
## Related Sections  
  
|||  
|---|---|  
|[Performance Tips](https://msdn.microsoft.com/library/ms173196(VS.110).aspx) | Discusses several basic rules that may help you increase the performance of your application.|