---
title: Samples and Tutorials
description: Samples and Tutorials
keywords: .NET
author: BillWagner
ms.author: wiwagn
ms.date: 06/25/2016
ms.topic: article
ms.prod: .net
ms.devlang: dotnet
ms.assetid: 617310e7-336b-4864-8dab-7e2021512929
---

# Samples and Tutorials

We've got a rich catalog of samples and tutorials that you can use
to learn more about .NET. This area contains samples and tutorials
for .NET Core, and the C# Language.

You can find great resources to learn the F# programming language
on the [F# Foundation's site](http://fsharp.org/learn.html). 

You can find great resources for learning ASP.NET Core on the
[ASP.NET site](https://docs.microsoft.com/aspnet/core/tutorials/).

In addition, if you are interested in exploring C# using an
online playground, try these [interactive tutorials](http://go.microsoft.com/fwlink/?LinkId=817234).

## General

### Samples

**[Unit Testing in .NET Core using dotnet test](../core/testing/unit-testing-with-dotnet-test.md)**

This guide shows how to create an ASP.NET Core web application and the associated unit tests. It will start by creating a simple web service application and then add tests, and continue by creating more tests to guide implementing new features. The completed code is available [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/core/getting-started/unit-testing-using-dotnet-test).

### Tutorials

**[Writing .NET Core console apps using the CLI tools: A step-by-step guide](../core/tutorials/using-with-xplat-cli.md)**

This guide will show you how to use the .NET Core CLI tooling to build cross-platform console apps.  It will start with the most basic console app and eventually span multiple projects, including testing. You'll add these features step-by-step, building on what you've already seen and built. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/core/console-apps).

**[Writing Libraries with Cross Platform Tools](../core/tutorials/libraries.md)**

This sample covers how you can write libraries for .NET using cross-platform CLI tools.  They provide an efficient and low-level experience that works across any supported OS.
The completed code is available [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/framework/libraries/frameworks-library).

## C# Language

### Samples

**[Iterators](../csharp/iterators.md)**

This sample demonstrates the syntax and features for creating and consuming C# iterators. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/iterators).

**[Indexers](../csharp/indexers.md)**

This sample demonstrates the syntax and features for C# indexers. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/indexers).

**[Delegates and Events](../csharp/delegates-events.md)**

This sample demonstrates the syntax and features for C# delegates and events. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/delegates-and-events). A second sample, focused on events is also in the
[same repository](https://github.com/dotnet/docs/tree/master/samples/csharp/events).

**[Expression Trees](../csharp/expression-trees.md)**

This sample demonstrates many of the problems that can be solved by using Expression Trees. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/expression-trees).

**LINQ Samples**

These series of samples demonstrate many of the features of Language Integrated Query.  A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/core/linq/csharp).

### Tutorials

**[Console Application](../csharp/tutorials/console-teleprompter.md)**

This tutorial demonstrates Console I/O, the structure of a Console application, and
the basics of the Task based asynchronous programming model. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/getting-started/console-teleprompter).

**[REST Client](../csharp/tutorials/console-webapiclient.md)**

This tutorial demonstrates web communications, JSON serialization, and Object Oriented
features in the C# language. A finished version of the code you'll build is located
[in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/getting-started/console-webapiclient).

**[Working with LINQ](../csharp/tutorials/working-with-linq.md)**

This tutorial demonstrates many of the features of LINQ and the language elements that support it. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/getting-started/console-linq).

**[Microservices hosted in Docker](../csharp/tutorials/microservices.md)**

This tutorial demonstrates building an ASP.NET Core microservice and hosting it in Docker. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/csharp/getting-started/WeatherMicroservice).

## Deploying to Containers

**[Running ASP.NET MVC Applications in Windows Docker Containers](../framework/docker/aspnetmvc.md)**

This tutorial demonstrates how to deploy an existing ASP.NET MVC application in a Windows Docker Container.
A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/framework/docker/MVCRandomAnswerGenerator).

**[Running .NET Framework Console Applications in Windows Containers](../framework/docker/console.md)**

This tutorial demonstrates how to deploy and existing console application in a Windows container. A finished version of the code you'll build is located [in the core-docs repository on GitHub](https://github.com/dotnet/docs/tree/master/samples/framework/docker/ConsoleRandomAnswerGenerator).