---
title: "Namespace declaration with prefix cannot have an empty value in XML literals | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31184"
  - "vbc31184"
helpviewer_keywords: 
  - "BC31184"
ms.assetid: dde656b4-df3b-4a2e-8871-4e14832ca778
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Namespace declaration with prefix cannot have an empty value in XML literals
An XML namespace declaration in an XML literal does not include a namespace value. For example, the following code will cause this error:  
  
```vb  
Dim book = <book xmlns:ns=""/>  
```  
  
 **Error ID:** BC31184  
  
## To correct this error  
  
-   Include a valid namespace in the XML namespace declaration, or remove the XML namespace declaration from the XML literal.  
  
     As an alternative, you can use the `Imports` statement to identify a namespace prefix for the empty namespace. For example:  
  
```vb  
Imports <xmlns:ns="">  
```  
  
## See Also  
 [XML Literals](../../visual-basic/language-reference/xml-literals/index.md)   
 [XML](../../visual-basic/programming-guide/language-features/xml/index.md)   
 [Imports Statement (XML Namespace)](../../visual-basic/language-reference/statements/imports-statement-xml-namespace.md)