---
title: "Member &#39;&lt;membername&gt;&#39; implicitly defines a member &#39;&lt;implicitmembername&gt;&#39; which has the same name as a type parameter | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC32070"
  - "vbc32070"
helpviewer_keywords: 
  - "BC32070"
ms.assetid: cc0b3fcf-c141-47e2-9b33-d2b91c8bf2d6
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Member &#39;&lt;membername&gt;&#39; implicitly defines a member &#39;&lt;implicitmembername&gt;&#39; which has the same name as a type parameter
A member of a generic class generates an implicit member with the same name as a type parameter for the class.  
  
 The [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] compiler creates implicit members corresponding to certain programming elements you declare. The following table summarizes these implicit, or *synthetic*, members.  
  
|Declared element|Implicitly created members|  
|----------------------|--------------------------------|  
|Enumeration|`value__` member|  
|Event|`add_<eventname>` procedure<br /><br /> `remove_<eventname>` procedure<br /><br /> `<eventname>Event` field<br /><br /> `<eventname>EventHandler` delegate|  
|Property|`get_<propertyname>` procedure<br /><br /> `set_<propertyname>` procedure|  
|`My.` collection variable|`m_<variablename>` `Static` variable<br /><br /> `<variablename>` property<br /><br /> `get_<variablename>` procedure<br /><br /> `set_<variablename>` procedure|  
|`WithEvents` variable|`_<variablename>` variable<br /><br /> `<variablename>` property<br /><br /> `get_<variablename>` procedure<br /><br /> `set_<variablename>` procedure|  
  
 Because of the possibility of name conflicts, you should avoid naming any declared programming element using the same form as any of these implicit members. For example, you should avoid any element name that begins with `get_` or `set_`.  
  
 **Error ID:** BC32070  
  
## To correct this error  
  
-   If the name of the type parameter is flexible, change it to avoid conflicts with the names listed in the preceding table.  
  
-   If the type parameter must retain its name, change the name of the class member to avoid conflicts with the names listed in the preceding table.  
  
## See Also  
 [Declared Element Names](../../visual-basic/programming-guide/language-features/declared-elements/declared-element-names.md)   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Type List](../../visual-basic/language-reference/statements/type-list.md)