---
title: "Operators must be declared &#39;Shared&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33012"
  - "bc33012"
helpviewer_keywords: 
  - "BC33012"
ms.assetid: 5ad97616-4032-46cd-aaf7-517db5d1195f
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Operators must be declared &#39;Shared&#39;
An [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md) does not include the [Shared](../../visual-basic/language-reference/modifiers/shared.md) keyword.  
  
 An `Operator` procedure requires both the [Public](../../visual-basic/language-reference/modifiers/public.md) and `Shared` keywords, and a conversion operator also requires either the [Widening](../../visual-basic/language-reference/modifiers/widening.md) or the [Narrowing](../../visual-basic/language-reference/modifiers/narrowing.md) keyword.  
  
 **Error ID:** BC33012  
  
## To correct this error  
  
-   Add the `Shared` keyword to the `Operator` statement.  
  
## See Also  
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)   
 [How to: Define an Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-an-operator.md)   
 [How to: Define a Conversion Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-a-conversion-operator.md)