---
title: "&#39;AddressOf&#39; expressions are not valid in the first expression of a &#39;Select Case&#39; statement | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36636"
  - "vbc36636"
helpviewer_keywords: 
  - "BC36636"
ms.assetid: 2ccc0ccc-d4d0-4910-8859-dedfa57c8126
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;AddressOf&#39; expressions are not valid in the first expression of a &#39;Select Case&#39; statement
You cannot use an `AddressOf` expression for the test expression in a `Select Case` statement. `AddressOf` expressions return function delegates, and the test expression of a `Select Case` statement must be an elementary data type.  
  
 **Error ID:** BC36636  
  
## To correct this error  
  
-   Examine your code to determine whether a different conditional construction, such as an `If...Then...Else` statement, would work for you.  
  
## See Also  
 [AddressOf Operator](../../visual-basic/language-reference/operators/addressof-operator.md)   
 [If...Then...Else Statement](../../visual-basic/language-reference/statements/if-then-else-statement.md)   
 [Select...Case Statement](../../visual-basic/language-reference/statements/select-case-statement.md)