(in-package #:geb.seqn.spec)

(defmacro easy-printer (class-name)
  `(defmethod print-object ((obj ,class-name) stream)
     (format stream "~A"
             (cons ',class-name
                   (mapcar #'cdr (geb.mixins:to-pointwise-list obj))))))

(easy-printer composition)
(easy-printer id)
(easy-printer parallel-seq)
(easy-printer fork-seq)
(easy-printer drop-nil)
(easy-printer remove-right)
(easy-printer remove-left)
(easy-printer drop-width)
(easy-printer inj-length-left)
(easy-printer inj-length-right)
(easy-printer inj-size)
(easy-printer branch-seq)
(easy-printer shift-front)
(easy-printer zero-bit)
(easy-printer one-bit)
(easy-printer seqn-add)
(easy-printer seqn-subtract)
(easy-printer seqn-multiply)
(easy-printer seqn-divide)
(easy-printer seqn-nat)
(easy-printer seqn-concat)
(easy-printer seqn-decompose)
(easy-printer seqn-eq)
(easy-printer seqn-lt)
(easy-printer seqn-mod)
