package keeper

import (
	"context"

	sdk "github.com/cosmos/cosmos-sdk/types"

	"ollo/x/claim/types"
)

type msgServer struct {
	Keeper
}

// NewMsgServerImpl returns an implementation of the MsgServer interface
// for the provided Keeper.
func NewMsgServerImpl(keeper Keeper) types.MsgServer {
	return &msgServer{Keeper: keeper}
}

var _ types.MsgServer = msgServer{}

// Claim defines a method to claim the claimable amount of coins.
func (m msgServer) Claim(goCtx context.Context, msg *types.MsgClaim) (*types.MsgClaimResponse, error) {
	ctx := sdk.UnwrapSDKContext(goCtx)

	if _, err := m.Keeper.Claim(ctx, msg); err != nil {
		return nil, err
	}

	return &types.MsgClaimResponse{}, nil
}
