// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ollo/liquidity/liquidity.proto

package types

import (
	fmt "fmt"
	github_com_cosmos_cosmos_sdk_types "github.com/cosmos/cosmos-sdk/types"
	types "github.com/cosmos/cosmos-sdk/types"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/timestamppb"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type OrderType int32

const (
	OrderTypeUnspecified  OrderType = 0
	OrderTypeMarket       OrderType = 1
	OrderTypeLimit        OrderType = 2
	OrderTypeMarketMaking OrderType = 3
)

var OrderType_name = map[int32]string{
	0: "ORDER_TYPE_UNSPECIFIED",
	1: "ORDER_TYPE_MARKET",
	2: "ORDER_TYPE_LIMIT",
	3: "ORDER_TYPE_MARKET_MAKING",
}

var OrderType_value = map[string]int32{
	"ORDER_TYPE_UNSPECIFIED":   0,
	"ORDER_TYPE_MARKET":        1,
	"ORDER_TYPE_LIMIT":         2,
	"ORDER_TYPE_MARKET_MAKING": 3,
}

func (x OrderType) String() string {
	return proto.EnumName(OrderType_name, int32(x))
}

func (OrderType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{0}
}

type OrderStatus int32

const (
	OrderStatusInvalidated  OrderStatus = 0
	OrderStatusMatching     OrderStatus = 1
	OrderStatusMatched      OrderStatus = 2
	OrderStatusNoMatch      OrderStatus = 3
	OrderStatusUnmatched    OrderStatus = 4
	OrderStatusPartialMatch OrderStatus = 5
	OrderStatusUnspecified  OrderStatus = 6
	OrderStatusExpired      OrderStatus = 7
	OrderStatusCanceled     OrderStatus = 8
)

var OrderStatus_name = map[int32]string{
	0: "ORDER_STATUS_INVALIDATED",
	1: "ORDER_STATUS_MATCHING",
	2: "ORDER_STATUS_MATCHED",
	3: "ORDER_STATUS_NO_MATCH",
	4: "ORDER_STATUS_UNMATCHED",
	5: "ORDER_STATUS_PARTIAL_MATCH",
	6: "ORDER_STATUS_UNSPECIFIED",
	7: "ORDER_STATUS_EXPIRED",
	8: "ORDER_STATUS_CANCELED",
}

var OrderStatus_value = map[string]int32{
	"ORDER_STATUS_INVALIDATED":   0,
	"ORDER_STATUS_MATCHING":      1,
	"ORDER_STATUS_MATCHED":       2,
	"ORDER_STATUS_NO_MATCH":      3,
	"ORDER_STATUS_UNMATCHED":     4,
	"ORDER_STATUS_PARTIAL_MATCH": 5,
	"ORDER_STATUS_UNSPECIFIED":   6,
	"ORDER_STATUS_EXPIRED":       7,
	"ORDER_STATUS_CANCELED":      8,
}

func (x OrderStatus) String() string {
	return proto.EnumName(OrderStatus_name, int32(x))
}

func (OrderStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{1}
}

type RequestStatus int32

const (
	RequestStatusUnspecified RequestStatus = 0
	RequestStatusPending     RequestStatus = 1
	RequestStatusExecuted    RequestStatus = 2
	RequestStatusSuccess     RequestStatus = 3
	RequestStatusFail        RequestStatus = 4
)

var RequestStatus_name = map[int32]string{
	0: "REQUEST_STATUS_UNSPECIFIED",
	1: "REQUEST_STATUS_PENDING",
	2: "REQUEST_STATUS_EXECUTED",
	3: "REQUEST_STATUS_SUCCESS",
	4: "REQUEST_STATUS_FAIL",
}

var RequestStatus_value = map[string]int32{
	"REQUEST_STATUS_UNSPECIFIED": 0,
	"REQUEST_STATUS_PENDING":     1,
	"REQUEST_STATUS_EXECUTED":    2,
	"REQUEST_STATUS_SUCCESS":     3,
	"REQUEST_STATUS_FAIL":        4,
}

func (x RequestStatus) String() string {
	return proto.EnumName(RequestStatus_name, int32(x))
}

func (RequestStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{2}
}

type OrderDirection int32

const (
	OrderDirectionUnspecified OrderDirection = 0
	OrderDirectionBuy         OrderDirection = 1
	OrderDirectionSell        OrderDirection = 2
)

var OrderDirection_name = map[int32]string{
	0: "ORDER_DIRECTION_UNSPECIFIED",
	1: "ORDER_DIRECTION_BUY",
	2: "ORDER_DIRECTION_SELL",
}

var OrderDirection_value = map[string]int32{
	"ORDER_DIRECTION_UNSPECIFIED": 0,
	"ORDER_DIRECTION_BUY":         1,
	"ORDER_DIRECTION_SELL":        2,
}

func (x OrderDirection) String() string {
	return proto.EnumName(OrderDirection_name, int32(x))
}

func (OrderDirection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{3}
}

type Pair struct {
	Id             uint64                                  `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	BaseDenom      string                                  `protobuf:"bytes,2,opt,name=base_denom,json=baseDenom,proto3" json:"base_denom,omitempty"`
	QuoteDenom     string                                  `protobuf:"bytes,3,opt,name=quote_denom,json=quoteDenom,proto3" json:"quote_denom,omitempty"`
	EscrowAddr     string                                  `protobuf:"bytes,4,opt,name=escrow_addr,json=escrowAddr,proto3" json:"escrow_addr,omitempty"`
	LastOrderId    uint64                                  `protobuf:"varint,5,opt,name=last_order_id,json=lastOrderId,proto3" json:"last_order_id,omitempty"`
	LastPrice      *github_com_cosmos_cosmos_sdk_types.Dec `protobuf:"bytes,6,opt,name=last_price,json=lastPrice,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"last_price,omitempty"`
	CurrentBatchId uint64                                  `protobuf:"varint,7,opt,name=current_batch_id,json=currentBatchId,proto3" json:"current_batch_id,omitempty"`
}

func (m *Pair) Reset()         { *m = Pair{} }
func (m *Pair) String() string { return proto.CompactTextString(m) }
func (*Pair) ProtoMessage()    {}
func (*Pair) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{0}
}
func (m *Pair) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Pair) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Pair.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Pair) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Pair.Merge(m, src)
}
func (m *Pair) XXX_Size() int {
	return m.Size()
}
func (m *Pair) XXX_DiscardUnknown() {
	xxx_messageInfo_Pair.DiscardUnknown(m)
}

var xxx_messageInfo_Pair proto.InternalMessageInfo

type PoolType struct {
	Id          uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty" yaml:"id"`
	Name        string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	CreatorAddr string `protobuf:"bytes,4,opt,name=creator_addr,json=creatorAddr,proto3" json:"creator_addr,omitempty" yaml:"creator_addr"`
}

func (m *PoolType) Reset()         { *m = PoolType{} }
func (m *PoolType) String() string { return proto.CompactTextString(m) }
func (*PoolType) ProtoMessage()    {}
func (*PoolType) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{1}
}
func (m *PoolType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PoolType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PoolType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PoolType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PoolType.Merge(m, src)
}
func (m *PoolType) XXX_Size() int {
	return m.Size()
}
func (m *PoolType) XXX_DiscardUnknown() {
	xxx_messageInfo_PoolType.DiscardUnknown(m)
}

var xxx_messageInfo_PoolType proto.InternalMessageInfo

type PoolReserve struct {
	// Reserve coins deposited
	Supply    types.Coin                              `protobuf:"bytes,1,opt,name=supply,proto3" json:"totalSupply" yaml:"total_supply"`
	Addr      string                                  `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty" yaml:"creator_addr"`
	Denom     string                                  `protobuf:"bytes,3,opt,name=denom,proto3" json:"denom,omitempty" yaml:"creator_addr"`
	MinSupply *github_com_cosmos_cosmos_sdk_types.Int `protobuf:"bytes,4,opt,name=min_supply,json=minSupply,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Int" json:"min_supply,omitempty"`
	MaxSupply *github_com_cosmos_cosmos_sdk_types.Int `protobuf:"bytes,5,opt,name=max_supply,json=maxSupply,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Int" json:"max_supply,omitempty"`
}

func (m *PoolReserve) Reset()         { *m = PoolReserve{} }
func (m *PoolReserve) String() string { return proto.CompactTextString(m) }
func (*PoolReserve) ProtoMessage()    {}
func (*PoolReserve) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{2}
}
func (m *PoolReserve) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PoolReserve) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PoolReserve.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PoolReserve) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PoolReserve.Merge(m, src)
}
func (m *PoolReserve) XXX_Size() int {
	return m.Size()
}
func (m *PoolReserve) XXX_DiscardUnknown() {
	xxx_messageInfo_PoolReserve.DiscardUnknown(m)
}

var xxx_messageInfo_PoolReserve proto.InternalMessageInfo

type Pool struct {
	Id                uint64       `protobuf:"varint,1,opt,name=id,proto3" json:"id" yaml:"id"`
	PairId            uint64       `protobuf:"varint,2,opt,name=pair_id,json=pairId,proto3" json:"pairId" yaml:"pair_id"`
	TypeId            uint64       `protobuf:"varint,3,opt,name=type_id,json=typeId,proto3" json:"typeId" yaml:"type_id"`
	CreatorAddr       string       `protobuf:"bytes,4,opt,name=creator_addr,json=creatorAddr,proto3" json:"creatorAddr" yaml:"creator_addr"`
	Reserve           *PoolReserve `protobuf:"bytes,5,opt,name=reserve,proto3" json:"state" yaml:"state"`
	Supply            types.Coin   `protobuf:"bytes,6,opt,name=supply,proto3" json:"totalSupply" yaml:"total_supply"`
	PrevDepositReqId  uint64       `protobuf:"varint,7,opt,name=prev_deposit_req_id,json=prevDepositReqId,proto3" json:"prev_deposit_req_id,omitempty"`
	PrevWithdrawReqId uint64       `protobuf:"varint,8,opt,name=prev_withdraw_req_id,json=prevWithdrawReqId,proto3" json:"prev_withdraw_req_id,omitempty"`
	Disabled          bool         `protobuf:"varint,9,opt,name=disabled,proto3" json:"disabled,omitempty"`
	PriceRange        *PriceRange  `protobuf:"bytes,10,opt,name=price_range,json=priceRange,proto3" json:"price_range,omitempty" yaml:"range"`
}

func (m *Pool) Reset()         { *m = Pool{} }
func (m *Pool) String() string { return proto.CompactTextString(m) }
func (*Pool) ProtoMessage()    {}
func (*Pool) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{3}
}
func (m *Pool) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Pool) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Pool.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Pool) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Pool.Merge(m, src)
}
func (m *Pool) XXX_Size() int {
	return m.Size()
}
func (m *Pool) XXX_DiscardUnknown() {
	xxx_messageInfo_Pool.DiscardUnknown(m)
}

var xxx_messageInfo_Pool proto.InternalMessageInfo

type PoolState struct {
	// Pool coin issued
	Supply            types.Coin  `protobuf:"bytes,1,opt,name=supply,proto3" json:"totalSupply" yaml:"total_supply"`
	PrevDepositReqId  uint64      `protobuf:"varint,2,opt,name=prev_deposit_req_id,json=prevDepositReqId,proto3" json:"prev_deposit_req_id,omitempty" yaml:"prev_deposit_req_id"`
	PrevWithdrawReqId uint64      `protobuf:"varint,3,opt,name=prev_withdraw_req_id,json=prevWithdrawReqId,proto3" json:"prev_withdraw_req_id,omitempty" yaml:"prev_withdraw_req_id"`
	Disabled          bool        `protobuf:"varint,4,opt,name=disabled,proto3" json:"disabled,omitempty"`
	PriceRange        *PriceRange `protobuf:"bytes,5,opt,name=price_range,json=priceRange,proto3" json:"price_range,omitempty" yaml:"range"`
}

func (m *PoolState) Reset()         { *m = PoolState{} }
func (m *PoolState) String() string { return proto.CompactTextString(m) }
func (*PoolState) ProtoMessage()    {}
func (*PoolState) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{4}
}
func (m *PoolState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PoolState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PoolState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PoolState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PoolState.Merge(m, src)
}
func (m *PoolState) XXX_Size() int {
	return m.Size()
}
func (m *PoolState) XXX_DiscardUnknown() {
	xxx_messageInfo_PoolState.DiscardUnknown(m)
}

var xxx_messageInfo_PoolState proto.InternalMessageInfo

type PriceRange struct {
	Min *github_com_cosmos_cosmos_sdk_types.Dec `protobuf:"bytes,1,opt,name=min,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"min,omitempty"`
	Max *github_com_cosmos_cosmos_sdk_types.Dec `protobuf:"bytes,2,opt,name=max,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"max,omitempty"`
}

func (m *PriceRange) Reset()         { *m = PriceRange{} }
func (m *PriceRange) String() string { return proto.CompactTextString(m) }
func (*PriceRange) ProtoMessage()    {}
func (*PriceRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{5}
}
func (m *PriceRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PriceRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PriceRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PriceRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PriceRange.Merge(m, src)
}
func (m *PriceRange) XXX_Size() int {
	return m.Size()
}
func (m *PriceRange) XXX_DiscardUnknown() {
	xxx_messageInfo_PriceRange.DiscardUnknown(m)
}

var xxx_messageInfo_PriceRange proto.InternalMessageInfo

type PoolBatch struct {
	Id         uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	PoolId     uint64 `protobuf:"varint,2,opt,name=pool_id,json=poolId,proto3" json:"pool_id,omitempty"`
	Height     uint64 `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`
	DepositId  uint64 `protobuf:"varint,4,opt,name=deposit_id,json=depositId,proto3" json:"deposit_id,omitempty"`
	WithdrawId uint64 `protobuf:"varint,5,opt,name=withdraw_id,json=withdrawId,proto3" json:"withdraw_id,omitempty"`
	SwapId     uint64 `protobuf:"varint,6,opt,name=swap_id,json=swapId,proto3" json:"swap_id,omitempty"`
	Executed   bool   `protobuf:"varint,7,opt,name=executed,proto3" json:"executed,omitempty" yaml:"executed"`
}

func (m *PoolBatch) Reset()         { *m = PoolBatch{} }
func (m *PoolBatch) String() string { return proto.CompactTextString(m) }
func (*PoolBatch) ProtoMessage()    {}
func (*PoolBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{6}
}
func (m *PoolBatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PoolBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PoolBatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PoolBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PoolBatch.Merge(m, src)
}
func (m *PoolBatch) XXX_Size() int {
	return m.Size()
}
func (m *PoolBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_PoolBatch.DiscardUnknown(m)
}

var xxx_messageInfo_PoolBatch proto.InternalMessageInfo

type RequestDeposit struct {
	Id            uint64                                   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	PoolId        uint64                                   `protobuf:"varint,2,opt,name=pool_id,json=poolId,proto3" json:"pool_id,omitempty"`
	DepositorAddr string                                   `protobuf:"bytes,3,opt,name=depositor_addr,json=depositorAddr,proto3" json:"depositor_addr,omitempty"`
	PoolCoin      types.Coin                               `protobuf:"bytes,4,opt,name=pool_coin,json=poolCoin,proto3" json:"pool_coin"`
	MsgHeight     int64                                    `protobuf:"varint,5,opt,name=msg_height,json=msgHeight,proto3" json:"msg_height,omitempty"`
	DepositAmt    github_com_cosmos_cosmos_sdk_types.Coins `protobuf:"bytes,6,rep,name=deposit_amt,json=depositAmt,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.Coins" json:"deposit_amt"`
	AcceptedAmt   github_com_cosmos_cosmos_sdk_types.Coins `protobuf:"bytes,7,rep,name=accepted_amt,json=acceptedAmt,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.Coins" json:"accepted_amt"`
	Status        RequestStatus                            `protobuf:"varint,8,opt,name=status,proto3,enum=ollo.liquidity.RequestStatus" json:"status,omitempty"`
}

func (m *RequestDeposit) Reset()         { *m = RequestDeposit{} }
func (m *RequestDeposit) String() string { return proto.CompactTextString(m) }
func (*RequestDeposit) ProtoMessage()    {}
func (*RequestDeposit) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{7}
}
func (m *RequestDeposit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestDeposit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestDeposit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestDeposit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestDeposit.Merge(m, src)
}
func (m *RequestDeposit) XXX_Size() int {
	return m.Size()
}
func (m *RequestDeposit) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestDeposit.DiscardUnknown(m)
}

var xxx_messageInfo_RequestDeposit proto.InternalMessageInfo

type RequestWithdraw struct {
	Id           uint64                                   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	PoolId       uint64                                   `protobuf:"varint,2,opt,name=pool_id,json=poolId,proto3" json:"pool_id,omitempty"`
	WithdrawAddr string                                   `protobuf:"bytes,3,opt,name=withdraw_addr,json=withdrawAddr,proto3" json:"withdraw_addr,omitempty"`
	PoolCoin     types.Coin                               `protobuf:"bytes,4,opt,name=pool_coin,json=poolCoin,proto3" json:"pool_coin"`
	MsgHeight    int64                                    `protobuf:"varint,5,opt,name=msg_height,json=msgHeight,proto3" json:"msg_height,omitempty"`
	WithdrawAmt  github_com_cosmos_cosmos_sdk_types.Coins `protobuf:"bytes,6,rep,name=withdraw_amt,json=withdrawAmt,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.Coins" json:"withdraw_amt"`
	Status       RequestStatus                            `protobuf:"varint,7,opt,name=status,proto3,enum=ollo.liquidity.RequestStatus" json:"status,omitempty"`
}

func (m *RequestWithdraw) Reset()         { *m = RequestWithdraw{} }
func (m *RequestWithdraw) String() string { return proto.CompactTextString(m) }
func (*RequestWithdraw) ProtoMessage()    {}
func (*RequestWithdraw) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{8}
}
func (m *RequestWithdraw) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestWithdraw) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestWithdraw.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestWithdraw) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestWithdraw.Merge(m, src)
}
func (m *RequestWithdraw) XXX_Size() int {
	return m.Size()
}
func (m *RequestWithdraw) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestWithdraw.DiscardUnknown(m)
}

var xxx_messageInfo_RequestWithdraw proto.InternalMessageInfo

type Order struct {
	Id          uint64                                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	PairId      uint64                                 `protobuf:"varint,2,opt,name=pair_id,json=pairId,proto3" json:"pair_id,omitempty"`
	CreatorAddr string                                 `protobuf:"bytes,3,opt,name=creator_addr,json=creatorAddr,proto3" json:"creator_addr,omitempty"`
	MsgHeight   int64                                  `protobuf:"varint,4,opt,name=msg_height,json=msgHeight,proto3" json:"msg_height,omitempty"`
	Type        OrderType                              `protobuf:"varint,5,opt,name=type,proto3,enum=ollo.liquidity.OrderType" json:"type,omitempty"`
	Direction   OrderDirection                         `protobuf:"varint,6,opt,name=direction,proto3,enum=ollo.liquidity.OrderDirection" json:"direction,omitempty"`
	Status      OrderStatus                            `protobuf:"varint,7,opt,name=status,proto3,enum=ollo.liquidity.OrderStatus" json:"status,omitempty"`
	BatchId     uint64                                 `protobuf:"varint,8,opt,name=batch_id,json=batchId,proto3" json:"batch_id,omitempty"`
	Offer       types.Coin                             `protobuf:"bytes,9,opt,name=offer,proto3" json:"offer"`
	Remaining   types.Coin                             `protobuf:"bytes,10,opt,name=remaining,proto3" json:"remaining"`
	Received    types.Coin                             `protobuf:"bytes,11,opt,name=received,proto3" json:"received"`
	Price       github_com_cosmos_cosmos_sdk_types.Dec `protobuf:"bytes,12,opt,name=price,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"price"`
	Amt         github_com_cosmos_cosmos_sdk_types.Int `protobuf:"bytes,13,opt,name=amt,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Int" json:"amt"`
	OpenAmt     github_com_cosmos_cosmos_sdk_types.Int `protobuf:"bytes,14,opt,name=open_amt,json=openAmt,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Int" json:"open_amt"`
	Expires     time.Time                              `protobuf:"bytes,15,opt,name=expires,proto3,stdtime" json:"expires"`
}

func (m *Order) Reset()         { *m = Order{} }
func (m *Order) String() string { return proto.CompactTextString(m) }
func (*Order) ProtoMessage()    {}
func (*Order) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{9}
}
func (m *Order) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Order) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Order.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Order) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Order.Merge(m, src)
}
func (m *Order) XXX_Size() int {
	return m.Size()
}
func (m *Order) XXX_DiscardUnknown() {
	xxx_messageInfo_Order.DiscardUnknown(m)
}

var xxx_messageInfo_Order proto.InternalMessageInfo

type MarketMakingOrderId struct {
	PairId      uint64   `protobuf:"varint,1,opt,name=pair_id,json=pairId,proto3" json:"pair_id,omitempty"`
	CreatorAddr string   `protobuf:"bytes,2,opt,name=creator_addr,json=creatorAddr,proto3" json:"creator_addr,omitempty"`
	OrderIds    []uint64 `protobuf:"varint,3,rep,packed,name=order_ids,json=orderIds,proto3" json:"order_ids,omitempty"`
}

func (m *MarketMakingOrderId) Reset()         { *m = MarketMakingOrderId{} }
func (m *MarketMakingOrderId) String() string { return proto.CompactTextString(m) }
func (*MarketMakingOrderId) ProtoMessage()    {}
func (*MarketMakingOrderId) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b7a4dc83f6a707a, []int{10}
}
func (m *MarketMakingOrderId) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MarketMakingOrderId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MarketMakingOrderId.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MarketMakingOrderId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarketMakingOrderId.Merge(m, src)
}
func (m *MarketMakingOrderId) XXX_Size() int {
	return m.Size()
}
func (m *MarketMakingOrderId) XXX_DiscardUnknown() {
	xxx_messageInfo_MarketMakingOrderId.DiscardUnknown(m)
}

var xxx_messageInfo_MarketMakingOrderId proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("ollo.liquidity.OrderType", OrderType_name, OrderType_value)
	proto.RegisterEnum("ollo.liquidity.OrderStatus", OrderStatus_name, OrderStatus_value)
	proto.RegisterEnum("ollo.liquidity.RequestStatus", RequestStatus_name, RequestStatus_value)
	proto.RegisterEnum("ollo.liquidity.OrderDirection", OrderDirection_name, OrderDirection_value)
	proto.RegisterType((*Pair)(nil), "ollo.liquidity.Pair")
	proto.RegisterType((*PoolType)(nil), "ollo.liquidity.PoolType")
	proto.RegisterType((*PoolReserve)(nil), "ollo.liquidity.PoolReserve")
	proto.RegisterType((*Pool)(nil), "ollo.liquidity.Pool")
	proto.RegisterType((*PoolState)(nil), "ollo.liquidity.PoolState")
	proto.RegisterType((*PriceRange)(nil), "ollo.liquidity.PriceRange")
	proto.RegisterType((*PoolBatch)(nil), "ollo.liquidity.PoolBatch")
	proto.RegisterType((*RequestDeposit)(nil), "ollo.liquidity.RequestDeposit")
	proto.RegisterType((*RequestWithdraw)(nil), "ollo.liquidity.RequestWithdraw")
	proto.RegisterType((*Order)(nil), "ollo.liquidity.Order")
	proto.RegisterType((*MarketMakingOrderId)(nil), "ollo.liquidity.MarketMakingOrderId")
}

func init() { proto.RegisterFile("ollo/liquidity/liquidity.proto", fileDescriptor_2b7a4dc83f6a707a) }

var fileDescriptor_2b7a4dc83f6a707a = []byte{
	// 2174 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0xb7, 0xbe, 0xa5, 0x91, 0xa3, 0x68, 0xc7, 0x89, 0x23, 0xcb, 0x8d, 0xa4, 0xb2, 0x1f, 0x30,
	0x82, 0xb5, 0x2c, 0xcb, 0x1f, 0x89, 0xb3, 0xe9, 0xa2, 0x94, 0x44, 0x77, 0x99, 0xb5, 0x1d, 0x95,
	0x92, 0xda, 0xdd, 0x45, 0x01, 0x81, 0x26, 0xc7, 0xca, 0x34, 0x12, 0x49, 0x93, 0x94, 0x63, 0xb7,
	0xe8, 0xbd, 0xd0, 0x29, 0xc8, 0xa9, 0x17, 0x01, 0x41, 0x7a, 0x28, 0xd0, 0xbf, 0xa0, 0xe8, 0xb9,
	0x40, 0x73, 0xdc, 0x43, 0x51, 0x14, 0x45, 0xa1, 0x6d, 0x93, 0x4b, 0x11, 0xa0, 0x17, 0x9f, 0xda,
	0x53, 0x8b, 0x99, 0x21, 0x25, 0xea, 0xa3, 0x59, 0x3b, 0xc8, 0x5e, 0xd6, 0x17, 0x8b, 0x33, 0xef,
	0xf7, 0xde, 0xcc, 0xef, 0xf7, 0xde, 0xcc, 0x23, 0x41, 0x46, 0x6f, 0xb7, 0xf5, 0xb5, 0x36, 0x3e,
	0xee, 0x62, 0x15, 0xdb, 0x67, 0xa3, 0x5f, 0x79, 0xc3, 0xd4, 0x6d, 0x1d, 0x26, 0xc8, 0x7c, 0x7e,
	0x38, 0x9a, 0xbe, 0xd6, 0xd2, 0x5b, 0x3a, 0x9d, 0x5a, 0x23, 0xbf, 0x98, 0x55, 0x3a, 0xdb, 0xd2,
	0xf5, 0x56, 0x1b, 0xad, 0xd1, 0xa7, 0xc3, 0xee, 0xd1, 0x9a, 0x8d, 0x3b, 0xc8, 0xb2, 0xe5, 0x8e,
	0xe1, 0x18, 0x64, 0x26, 0x0d, 0xd4, 0xae, 0x29, 0xdb, 0x58, 0xd7, 0x9c, 0xf9, 0x1b, 0x8a, 0x6e,
	0x75, 0x74, 0xab, 0xc9, 0x3c, 0x2b, 0x3a, 0x76, 0x27, 0xd8, 0x3f, 0x65, 0xb5, 0x85, 0xb4, 0x55,
	0xdd, 0x40, 0x9a, 0x6c, 0xe0, 0x93, 0xe2, 0x9a, 0x6e, 0x10, 0xac, 0xb5, 0x26, 0x6b, 0x9a, 0x6e,
	0x53, 0x3f, 0x16, 0x33, 0xe4, 0x9e, 0xf8, 0x41, 0xb0, 0x2a, 0x63, 0x13, 0x26, 0x80, 0x1f, 0xab,
	0x29, 0x5f, 0xce, 0xb7, 0x12, 0x94, 0xfc, 0x58, 0x85, 0x37, 0x01, 0x38, 0x94, 0x2d, 0xd4, 0x54,
	0x91, 0xa6, 0x77, 0x52, 0xfe, 0x9c, 0x6f, 0x25, 0x26, 0xc5, 0xc8, 0x48, 0x85, 0x0c, 0xc0, 0x2c,
	0x88, 0x1f, 0x77, 0x75, 0xdb, 0x9d, 0x0f, 0xd0, 0x79, 0x40, 0x87, 0x86, 0x06, 0xc8, 0x52, 0x4c,
	0xfd, 0x71, 0x53, 0x56, 0x55, 0x33, 0x15, 0x64, 0x06, 0x6c, 0x88, 0x57, 0x55, 0x13, 0x72, 0xe0,
	0x4a, 0x5b, 0xb6, 0xec, 0xa6, 0x6e, 0xaa, 0xc8, 0x6c, 0x62, 0x35, 0x15, 0xa2, 0xb1, 0xe3, 0x64,
	0xf0, 0x01, 0x19, 0x13, 0x55, 0x28, 0x02, 0x40, 0x6d, 0x0c, 0x13, 0x2b, 0x28, 0x15, 0x26, 0x3e,
	0x4a, 0xb7, 0xfe, 0x3a, 0xc8, 0x7e, 0xb7, 0x85, 0xed, 0x87, 0xdd, 0xc3, 0xbc, 0xa2, 0x77, 0xd6,
	0x18, 0x13, 0xce, 0xbf, 0x55, 0x4b, 0x7d, 0xb4, 0x66, 0x9f, 0x19, 0xc8, 0xca, 0x57, 0x90, 0x22,
	0xc5, 0x08, 0xba, 0x4a, 0xc0, 0x70, 0x05, 0x24, 0x95, 0xae, 0x69, 0x22, 0xcd, 0x6e, 0x1e, 0xca,
	0xb6, 0xf2, 0x90, 0x44, 0x8c, 0xd0, 0x88, 0x09, 0x67, 0xbc, 0x44, 0x86, 0x45, 0x95, 0xfb, 0xa3,
	0x1f, 0x44, 0xab, 0xba, 0xde, 0xae, 0x9f, 0x19, 0x08, 0xe6, 0x47, 0xb4, 0x94, 0x32, 0x4f, 0xf9,
	0xc4, 0xfd, 0x00, 0xb7, 0xce, 0x3d, 0xf7, 0x87, 0xbb, 0x58, 0xb3, 0xb7, 0x37, 0xcf, 0x07, 0xd9,
	0xd8, 0x99, 0xdc, 0x69, 0xdf, 0xe5, 0xb0, 0xca, 0x51, 0xda, 0x04, 0x10, 0xd4, 0xe4, 0x0e, 0x62,
	0x84, 0x95, 0xd6, 0x9f, 0xf2, 0xf9, 0xfb, 0x71, 0x66, 0x41, 0x86, 0xb9, 0xe7, 0xfe, 0x0c, 0x57,
	0xd6, 0x35, 0xcb, 0x96, 0x35, 0xbb, 0x6a, 0xea, 0x6a, 0x57, 0xb1, 0xf7, 0xdc, 0x5c, 0x21, 0x31,
	0x39, 0x89, 0xc2, 0x61, 0x0d, 0xc4, 0x55, 0xc2, 0x15, 0xa6, 0xc2, 0x31, 0x7a, 0xdf, 0xc6, 0x9b,
	0xd7, 0x0b, 0xc4, 0x60, 0x5e, 0x31, 0x91, 0x6c, 0xeb, 0xa6, 0x47, 0x93, 0xd2, 0xee, 0x53, 0xfe,
	0xfd, 0xfb, 0x4b, 0x1c, 0xc9, 0xdb, 0xf5, 0x6d, 0x55, 0x3d, 0x46, 0x96, 0xfd, 0xb8, 0xfb, 0xe8,
	0xa4, 0xf0, 0xd3, 0x9f, 0x29, 0x67, 0x47, 0x1b, 0xdc, 0x73, 0x7f, 0xc2, 0x52, 0x1f, 0xe5, 0x79,
	0x45, 0x21, 0xaa, 0x21, 0xcb, 0x3a, 0x1f, 0x64, 0x17, 0xd8, 0x1a, 0xbc, 0xce, 0x38, 0x29, 0xee,
	0x3c, 0x12, 0xb3, 0xbb, 0xc1, 0x7f, 0x3e, 0xcb, 0xfa, 0xb8, 0xdf, 0x07, 0x41, 0x9c, 0xac, 0x43,
	0x42, 0x16, 0x32, 0x4f, 0x10, 0xfc, 0x93, 0x0f, 0x84, 0xad, 0xae, 0x61, 0xb4, 0xcf, 0x28, 0xa3,
	0xf1, 0xe2, 0x52, 0x9e, 0xc9, 0x96, 0x27, 0x89, 0x95, 0x3f, 0x59, 0x3f, 0x44, 0xb6, 0xbc, 0x9e,
	0x2f, 0xeb, 0x58, 0x2b, 0x3d, 0xf3, 0x3d, 0xe5, 0xad, 0xfb, 0x47, 0x3f, 0xe7, 0x68, 0x82, 0x71,
	0x77, 0x73, 0x9c, 0xa1, 0xeb, 0xed, 0xca, 0xc6, 0x16, 0x5f, 0x28, 0x97, 0xd7, 0xb7, 0x05, 0x61,
	0x6b, 0xe7, 0xce, 0xee, 0x4e, 0xa1, 0x54, 0xd8, 0xdc, 0x2c, 0x0b, 0xc5, 0x9d, 0x6d, 0x7e, 0xb3,
	0xb0, 0x55, 0xe2, 0x77, 0xca, 0x1b, 0x77, 0xd6, 0x85, 0x8d, 0x3b, 0x77, 0x36, 0x6e, 0x6f, 0xed,
	0xec, 0x54, 0x76, 0xb6, 0x77, 0x8b, 0xbb, 0xb7, 0x0b, 0xe5, 0xe2, 0x6e, 0xa1, 0xc8, 0x17, 0x37,
	0xf8, 0x4d, 0xee, 0xfd, 0x1c, 0x27, 0x77, 0xf4, 0xae, 0x66, 0x13, 0x8f, 0xeb, 0x05, 0xfa, 0xc7,
	0xfd, 0xe2, 0xb9, 0x3f, 0x4a, 0x36, 0x49, 0x02, 0xbf, 0x18, 0x64, 0xe7, 0x5e, 0x0f, 0xb2, 0x71,
	0x5b, 0xb7, 0xe5, 0x76, 0x8d, 0x2e, 0x76, 0xb4, 0x63, 0x3a, 0xd8, 0x64, 0x5b, 0xe0, 0x24, 0x67,
	0x2f, 0xf0, 0x33, 0x10, 0xa4, 0x7c, 0xfa, 0xdf, 0x29, 0x9f, 0xd4, 0x27, 0xfc, 0x09, 0x08, 0x79,
	0x2a, 0xec, 0x9d, 0x39, 0x67, 0x4e, 0x49, 0x7d, 0x75, 0xb0, 0xe6, 0x6c, 0xc8, 0xc9, 0x87, 0x8b,
	0xd6, 0x97, 0xa8, 0xd9, 0x52, 0xac, 0x83, 0x35, 0xc6, 0x11, 0x75, 0x25, 0x9f, 0xba, 0xae, 0x42,
	0x6f, 0xe1, 0x4a, 0x3e, 0x65, 0xae, 0x9c, 0xe4, 0xf9, 0x43, 0x18, 0x04, 0x49, 0xf2, 0xc0, 0x4d,
	0x4f, 0x09, 0x7e, 0x7b, 0xaa, 0x04, 0x5f, 0x0f, 0xb2, 0x7e, 0xac, 0x4e, 0x17, 0xe2, 0x2e, 0x88,
	0x18, 0x32, 0xa6, 0x07, 0x8b, 0x9f, 0x42, 0x57, 0x67, 0x41, 0xc3, 0xc4, 0x46, 0x24, 0xf0, 0x04,
	0x83, 0x3b, 0x18, 0x4e, 0x72, 0x66, 0x88, 0x1f, 0xb2, 0x48, 0xe2, 0x27, 0xf0, 0x06, 0x3f, 0xc4,
	0xc6, 0xeb, 0xc7, 0xc1, 0x70, 0x92, 0x33, 0x03, 0x4f, 0x67, 0x16, 0x5f, 0xe3, 0x92, 0x7a, 0x92,
	0xcc, 0xf4, 0xd4, 0xd9, 0x45, 0x6a, 0x11, 0x56, 0x41, 0xc4, 0x64, 0x05, 0x48, 0x65, 0x89, 0x17,
	0x97, 0xf3, 0xe3, 0x97, 0x54, 0xde, 0x53, 0xa3, 0xa5, 0xa5, 0xd7, 0x83, 0x6c, 0xc8, 0xb2, 0x65,
	0x1b, 0x9d, 0x0f, 0xb2, 0xf3, 0xcc, 0x39, 0x7d, 0xe4, 0x24, 0xd7, 0x8d, 0xb7, 0x8e, 0xc3, 0x5f,
	0xa3, 0x3a, 0x5e, 0x05, 0x0b, 0x86, 0x89, 0x4e, 0x9a, 0x2a, 0x32, 0x74, 0x0b, 0xdb, 0x4d, 0x13,
	0x1d, 0x8f, 0x6e, 0x89, 0x24, 0x99, 0xaa, 0xb0, 0x19, 0x09, 0x1d, 0x8b, 0x2a, 0x5c, 0x03, 0xd7,
	0xa8, 0xf9, 0x63, 0x6c, 0x3f, 0x54, 0x4d, 0xf9, 0xb1, 0x6b, 0x1f, 0xa5, 0xf6, 0xef, 0x91, 0xb9,
	0x1f, 0x3b, 0x53, 0x0c, 0x90, 0x06, 0x51, 0x15, 0x5b, 0xf2, 0x61, 0x1b, 0xa9, 0xa9, 0x58, 0xce,
	0xb7, 0x12, 0x95, 0x86, 0xcf, 0x70, 0x1f, 0xc4, 0xe9, 0x25, 0xd7, 0x34, 0x65, 0xad, 0x85, 0x52,
	0x80, 0xd2, 0x9a, 0x9e, 0x12, 0x8a, 0x98, 0x48, 0xc4, 0xa2, 0x94, 0x1c, 0xc9, 0x43, 0x21, 0x9c,
	0x04, 0x8c, 0xe1, 0xec, 0xdd, 0xe8, 0xaf, 0x9e, 0x65, 0x7d, 0xb4, 0x8c, 0xfe, 0x1d, 0x00, 0x31,
	0xa2, 0x6f, 0x8d, 0x68, 0xf8, 0x75, 0x3d, 0x81, 0xf7, 0x67, 0x2b, 0xc7, 0x0a, 0x3f, 0x73, 0x3e,
	0xc8, 0xa6, 0x9d, 0xea, 0x9e, 0x36, 0xe2, 0x66, 0x28, 0x5b, 0xfd, 0x3f, 0xca, 0xb2, 0x03, 0x20,
	0x7b, 0x3e, 0xc8, 0x2e, 0x7b, 0xfc, 0x4d, 0x58, 0x71, 0x5f, 0x26, 0x7d, 0xf0, 0xcd, 0xd2, 0x87,
	0xde, 0x99, 0xf4, 0x4f, 0x7d, 0x00, 0x8c, 0x60, 0xf0, 0x1e, 0x08, 0x74, 0xb0, 0x46, 0x75, 0xbf,
	0x5c, 0x17, 0x45, 0x60, 0x14, 0x2d, 0x9f, 0x3a, 0x77, 0xdc, 0xe5, 0xd0, 0xf2, 0xa9, 0x67, 0x51,
	0x7f, 0xf6, 0xb1, 0x7c, 0xa4, 0xdd, 0xd6, 0x54, 0xd7, 0x79, 0x03, 0x44, 0x48, 0x92, 0x0d, 0xc5,
	0x93, 0xc2, 0xe4, 0x51, 0x54, 0xe1, 0x22, 0x08, 0x3f, 0x44, 0xb8, 0xf5, 0xd0, 0x66, 0x22, 0x48,
	0xce, 0x13, 0x69, 0x53, 0x5d, 0x3d, 0x31, 0xa3, 0x36, 0x28, 0xc5, 0x9c, 0x11, 0x51, 0x25, 0x5d,
	0xe8, 0x50, 0x9e, 0x61, 0x8b, 0x09, 0xdc, 0x21, 0x91, 0x06, 0xb4, 0x1e, 0xcb, 0x06, 0x99, 0x0c,
	0x33, 0xc7, 0xe4, 0x91, 0x56, 0x77, 0x14, 0x9d, 0x22, 0xa5, 0x6b, 0x23, 0x76, 0x02, 0x44, 0x4b,
	0x0b, 0xe7, 0x83, 0xec, 0x55, 0x46, 0xbb, 0x3b, 0xc3, 0x49, 0x43, 0x23, 0xee, 0x6f, 0x01, 0x90,
	0x90, 0xd0, 0x71, 0x17, 0x59, 0xb6, 0x93, 0x4c, 0x17, 0xdf, 0xdd, 0x77, 0x40, 0xc2, 0x59, 0xb3,
	0x7b, 0x3d, 0xb0, 0x86, 0xfa, 0xca, 0x70, 0x94, 0x9e, 0xe4, 0xf7, 0x40, 0x8c, 0xe2, 0x49, 0xbf,
	0x4f, 0xf7, 0xfa, 0xc6, 0xfa, 0x0d, 0x92, 0x42, 0x92, 0xa2, 0x04, 0x41, 0x9e, 0x09, 0x55, 0x1d,
	0xab, 0xd5, 0x74, 0x68, 0x24, 0x54, 0x04, 0xa4, 0x58, 0xc7, 0x6a, 0x7d, 0xc4, 0x98, 0x6c, 0x93,
	0x96, 0x93, 0x31, 0x29, 0x77, 0xec, 0x54, 0x38, 0x17, 0x78, 0xb3, 0xfb, 0x02, 0x71, 0xff, 0xdb,
	0x2f, 0xb2, 0x2b, 0x17, 0xc8, 0x03, 0x02, 0xb0, 0x24, 0x57, 0x29, 0xbe, 0x63, 0x43, 0x0d, 0xcc,
	0xcb, 0x8a, 0x82, 0x0c, 0x1b, 0xa9, 0x34, 0x5c, 0xe4, 0xdd, 0x87, 0x8b, 0xbb, 0x01, 0x48, 0xbc,
	0x2d, 0x10, 0x26, 0xb7, 0x58, 0xd7, 0xa2, 0xc7, 0x73, 0xa2, 0x78, 0x73, 0xb2, 0xbe, 0x1c, 0xe9,
	0x6a, 0xd4, 0x48, 0x72, 0x8c, 0x3d, 0x79, 0xfb, 0x2f, 0x3f, 0xb8, 0xea, 0xd8, 0xb8, 0xa5, 0x7d,
	0x71, 0x7d, 0xbf, 0x05, 0xae, 0x0c, 0xd3, 0xd0, 0x23, 0xef, 0xbc, 0x3b, 0xf8, 0xd5, 0xab, 0xab,
	0x81, 0xf9, 0xd1, 0x0a, 0xbe, 0x1a, 0x79, 0x87, 0x95, 0x36, 0xce, 0x77, 0xe4, 0xed, 0xf8, 0xfe,
	0x6f, 0x08, 0x84, 0xe8, 0x6b, 0xe0, 0x4c, 0x96, 0xbd, 0x9d, 0xdd, 0xb0, 0x55, 0xfb, 0xe6, 0x44,
	0x8b, 0xc5, 0x48, 0x1e, 0xeb, 0x85, 0xc6, 0x59, 0x0a, 0x4e, 0xb2, 0xb4, 0x0a, 0x82, 0x64, 0x47,
	0x94, 0xbe, 0x44, 0x71, 0x69, 0x72, 0xcd, 0x74, 0x3d, 0xe4, 0xb5, 0x50, 0xa2, 0x66, 0x44, 0x31,
	0x15, 0x9b, 0x48, 0xa1, 0xef, 0x68, 0x61, 0x8a, 0xc9, 0xcc, 0xc4, 0x54, 0x5c, 0x2b, 0x69, 0x04,
	0x80, 0x1b, 0x13, 0x14, 0x2d, 0xcf, 0x84, 0x8e, 0x13, 0x04, 0x97, 0x40, 0x74, 0xf8, 0xfa, 0xca,
	0x1a, 0x8d, 0xc8, 0x21, 0x7b, 0x6f, 0x85, 0x5b, 0x20, 0xa4, 0x1f, 0x1d, 0x21, 0x93, 0xf6, 0x16,
	0x17, 0xc8, 0x1d, 0x66, 0x0d, 0xbf, 0x07, 0x62, 0x26, 0xea, 0xc8, 0x58, 0xc3, 0x5a, 0xcb, 0xe9,
	0x3b, 0xbe, 0x14, 0x3a, 0x42, 0xc0, 0x0f, 0x40, 0xd4, 0x44, 0x0a, 0xc2, 0x27, 0x48, 0x4d, 0xc5,
	0x2f, 0x98, 0xb4, 0x2e, 0x00, 0x56, 0x40, 0x88, 0xbd, 0xda, 0xcf, 0xd3, 0x6b, 0x25, 0x4f, 0xa6,
	0x2f, 0x71, 0xb5, 0x30, 0x30, 0xfc, 0x3e, 0x08, 0x90, 0x94, 0xbe, 0x72, 0x69, 0x1f, 0xe4, 0xbd,
	0x83, 0x40, 0xa1, 0x08, 0xa2, 0xba, 0x81, 0x34, 0x5a, 0x19, 0x89, 0xb7, 0x72, 0x13, 0x21, 0x78,
	0x92, 0xf8, 0x1f, 0x82, 0x08, 0x3a, 0x35, 0xb0, 0x89, 0xac, 0xd4, 0x55, 0xe7, 0x26, 0x67, 0xdf,
	0x72, 0xf2, 0xee, 0xb7, 0x9c, 0x7c, 0xdd, 0xfd, 0xd8, 0x53, 0x8a, 0x92, 0x28, 0x4f, 0xbe, 0xc8,
	0xfa, 0x24, 0x17, 0xe4, 0xa9, 0x80, 0x53, 0xb0, 0xb0, 0x2f, 0x9b, 0x8f, 0x90, 0xbd, 0x2f, 0x3f,
	0xc2, 0x5a, 0xcb, 0xfd, 0x26, 0xe2, 0x49, 0x7f, 0xdf, 0x1b, 0xd3, 0xdf, 0x3f, 0x9d, 0xfe, 0xcb,
	0x20, 0xe6, 0x7e, 0x6e, 0xb1, 0x52, 0x81, 0x5c, 0x60, 0x25, 0x28, 0x45, 0x75, 0xe6, 0xd7, 0x13,
	0xf9, 0x16, 0xb9, 0xa3, 0x87, 0xb9, 0x0e, 0x37, 0xc1, 0xe2, 0x03, 0xa9, 0x22, 0x48, 0xcd, 0xfa,
	0xa7, 0x55, 0xa1, 0xd9, 0x38, 0xa8, 0x55, 0x85, 0xb2, 0xb8, 0x2b, 0x0a, 0x95, 0xe4, 0x5c, 0x3a,
	0xd5, 0xeb, 0xe7, 0xae, 0x0d, 0x4d, 0x1b, 0x9a, 0x65, 0x20, 0x05, 0x1f, 0x61, 0xa4, 0xc2, 0x5b,
	0xe0, 0x3d, 0x0f, 0x6a, 0x9f, 0x97, 0x3e, 0x16, 0xea, 0x49, 0x5f, 0x7a, 0xa1, 0xd7, 0xcf, 0x5d,
	0x1d, 0x02, 0xd8, 0xfe, 0xe0, 0x0a, 0x48, 0x7a, 0x6c, 0xf7, 0xc4, 0x7d, 0xb1, 0x9e, 0xf4, 0xa7,
	0x61, 0xaf, 0x9f, 0x4b, 0x0c, 0x4d, 0xf7, 0x70, 0x07, 0xdb, 0xf0, 0x36, 0x48, 0x4d, 0x79, 0x6d,
	0xee, 0xf3, 0x1f, 0x8b, 0x07, 0x3f, 0x48, 0x06, 0xd2, 0x4b, 0xbd, 0x7e, 0xee, 0xfa, 0x84, 0x73,
	0x46, 0x5e, 0x3a, 0xf8, 0xcb, 0x5f, 0x67, 0xe6, 0x6e, 0xfd, 0x27, 0x00, 0xe2, 0x9e, 0xaa, 0x82,
	0x77, 0x5c, 0x77, 0xb5, 0x3a, 0x5f, 0x6f, 0xd4, 0x9a, 0xe2, 0xc1, 0x8f, 0xf8, 0x3d, 0xb1, 0xc2,
	0xd7, 0xe9, 0xe6, 0xd2, 0xbd, 0x7e, 0x6e, 0xd1, 0x63, 0x2e, 0x6a, 0x27, 0x72, 0x1b, 0xab, 0xb2,
	0x8d, 0x54, 0x58, 0x04, 0xd7, 0xc7, 0x90, 0xfb, 0x7c, 0xbd, 0xfc, 0x11, 0x59, 0x85, 0x2f, 0x7d,
	0xa3, 0xd7, 0xcf, 0x2d, 0x78, 0x60, 0xfb, 0xa4, 0x3e, 0x49, 0xa9, 0x14, 0xc0, 0xb5, 0x69, 0x8c,
	0x50, 0x49, 0xfa, 0xd3, 0x8b, 0xbd, 0x7e, 0x0e, 0x4e, 0x42, 0x90, 0x0a, 0xd7, 0x27, 0xa2, 0x1c,
	0x3c, 0x60, 0xa0, 0x64, 0x60, 0x0a, 0x72, 0xa0, 0x53, 0xd0, 0x48, 0x2d, 0x07, 0xd2, 0x38, 0x70,
	0xc3, 0x04, 0x3d, 0x6a, 0x31, 0x4c, 0x43, 0xeb, 0x38, 0x81, 0x3e, 0x00, 0xe9, 0x31, 0x54, 0x95,
	0x97, 0xea, 0x22, 0xbf, 0xe7, 0x44, 0x0b, 0xa5, 0x97, 0x7b, 0xfd, 0xdc, 0x0d, 0x0f, 0xb2, 0x2a,
	0x9b, 0x36, 0x96, 0xdb, 0x2c, 0xe4, 0x24, 0x8b, 0xde, 0x14, 0x09, 0x4f, 0xb1, 0xe8, 0x4d, 0x92,
	0x49, 0x46, 0x84, 0x4f, 0xaa, 0xa2, 0x24, 0x54, 0x92, 0x91, 0xa9, 0xed, 0x09, 0xb4, 0x3c, 0xa6,
	0x79, 0x2f, 0xf3, 0x07, 0x65, 0x61, 0x4f, 0xa8, 0x24, 0xa3, 0x53, 0xbc, 0x97, 0x65, 0x4d, 0x41,
	0x6d, 0xa4, 0x3a, 0xda, 0xff, 0xc6, 0x0f, 0xae, 0x8c, 0x5d, 0x3a, 0xf0, 0x1e, 0x48, 0x4b, 0xc2,
	0x0f, 0x1b, 0x42, 0xad, 0x3e, 0x6b, 0xe5, 0x73, 0xe9, 0x6f, 0xf4, 0xfa, 0xb9, 0xd4, 0x18, 0xc4,
	0xbb, 0xf6, 0x4d, 0xb0, 0x38, 0x81, 0xae, 0x0a, 0x07, 0x15, 0x96, 0x02, 0x94, 0xe8, 0x31, 0x64,
	0x15, 0x69, 0x2a, 0xc9, 0x81, 0x6d, 0x70, 0x63, 0x02, 0x25, 0x7c, 0x22, 0x94, 0x1b, 0x75, 0x9a,
	0x06, 0x34, 0x7f, 0xc7, 0x60, 0x82, 0xd3, 0x5d, 0xce, 0x88, 0x56, 0x6b, 0x94, 0xcb, 0x42, 0xad,
	0x96, 0x0c, 0xcc, 0x88, 0x56, 0xeb, 0x2a, 0x0a, 0xb2, 0x2c, 0x98, 0x07, 0x0b, 0x13, 0xa8, 0x5d,
	0x5e, 0xdc, 0x4b, 0x06, 0xd3, 0xd7, 0x7b, 0xfd, 0xdc, 0x7b, 0x63, 0x90, 0x5d, 0x19, 0xb7, 0x1d,
	0xa6, 0x7e, 0xe7, 0x03, 0x89, 0xf1, 0x6b, 0x0b, 0x7e, 0x08, 0x96, 0x19, 0xed, 0x15, 0x51, 0x12,
	0xca, 0x75, 0xf1, 0xc1, 0xc1, 0x04, 0x57, 0x37, 0x7b, 0xfd, 0xdc, 0xd2, 0x38, 0xc8, 0x4b, 0x56,
	0x1e, 0x2c, 0x4c, 0xe2, 0x4b, 0x8d, 0x4f, 0x93, 0x3e, 0xb6, 0x90, 0x71, 0x5c, 0xa9, 0x7b, 0x36,
	0x4a, 0x8c, 0x91, 0x7d, 0x4d, 0xd8, 0xdb, 0x1b, 0x2b, 0x95, 0x21, 0xa0, 0x86, 0xda, 0xce, 0xd2,
	0x4b, 0x9b, 0x2f, 0xfe, 0x91, 0x99, 0x7b, 0xf1, 0x32, 0xe3, 0xfb, 0xfc, 0x65, 0xc6, 0xf7, 0xf7,
	0x97, 0x19, 0xdf, 0x93, 0x57, 0x99, 0xb9, 0xcf, 0x5f, 0x65, 0xe6, 0xfe, 0xf2, 0x2a, 0x33, 0xf7,
	0xd9, 0x22, 0xfd, 0x78, 0x7f, 0xea, 0xf9, 0x7c, 0x4f, 0x0f, 0xf0, 0xc3, 0x30, 0x3d, 0x9a, 0x37,
	0xfe, 0x17, 0x00, 0x00, 0xff, 0xff, 0x9a, 0xfe, 0x03, 0x50, 0xdd, 0x17, 0x00, 0x00,
}

func (this *PoolType) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PoolType)
	if !ok {
		that2, ok := that.(PoolType)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if this.CreatorAddr != that1.CreatorAddr {
		return false
	}
	return true
}
func (this *PoolReserve) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PoolReserve)
	if !ok {
		that2, ok := that.(PoolReserve)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Supply.Equal(&that1.Supply) {
		return false
	}
	if this.Addr != that1.Addr {
		return false
	}
	if this.Denom != that1.Denom {
		return false
	}
	if that1.MinSupply == nil {
		if this.MinSupply != nil {
			return false
		}
	} else if !this.MinSupply.Equal(*that1.MinSupply) {
		return false
	}
	if that1.MaxSupply == nil {
		if this.MaxSupply != nil {
			return false
		}
	} else if !this.MaxSupply.Equal(*that1.MaxSupply) {
		return false
	}
	return true
}
func (this *Pool) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Pool)
	if !ok {
		that2, ok := that.(Pool)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.PairId != that1.PairId {
		return false
	}
	if this.TypeId != that1.TypeId {
		return false
	}
	if this.CreatorAddr != that1.CreatorAddr {
		return false
	}
	if !this.Reserve.Equal(that1.Reserve) {
		return false
	}
	if !this.Supply.Equal(&that1.Supply) {
		return false
	}
	if this.PrevDepositReqId != that1.PrevDepositReqId {
		return false
	}
	if this.PrevWithdrawReqId != that1.PrevWithdrawReqId {
		return false
	}
	if this.Disabled != that1.Disabled {
		return false
	}
	if !this.PriceRange.Equal(that1.PriceRange) {
		return false
	}
	return true
}
func (this *PoolState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PoolState)
	if !ok {
		that2, ok := that.(PoolState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Supply.Equal(&that1.Supply) {
		return false
	}
	if this.PrevDepositReqId != that1.PrevDepositReqId {
		return false
	}
	if this.PrevWithdrawReqId != that1.PrevWithdrawReqId {
		return false
	}
	if this.Disabled != that1.Disabled {
		return false
	}
	if !this.PriceRange.Equal(that1.PriceRange) {
		return false
	}
	return true
}
func (this *PriceRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PriceRange)
	if !ok {
		that2, ok := that.(PriceRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Min == nil {
		if this.Min != nil {
			return false
		}
	} else if !this.Min.Equal(*that1.Min) {
		return false
	}
	if that1.Max == nil {
		if this.Max != nil {
			return false
		}
	} else if !this.Max.Equal(*that1.Max) {
		return false
	}
	return true
}
func (this *RequestDeposit) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestDeposit)
	if !ok {
		that2, ok := that.(RequestDeposit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.PoolId != that1.PoolId {
		return false
	}
	if this.DepositorAddr != that1.DepositorAddr {
		return false
	}
	if !this.PoolCoin.Equal(&that1.PoolCoin) {
		return false
	}
	if this.MsgHeight != that1.MsgHeight {
		return false
	}
	if len(this.DepositAmt) != len(that1.DepositAmt) {
		return false
	}
	for i := range this.DepositAmt {
		if !this.DepositAmt[i].Equal(&that1.DepositAmt[i]) {
			return false
		}
	}
	if len(this.AcceptedAmt) != len(that1.AcceptedAmt) {
		return false
	}
	for i := range this.AcceptedAmt {
		if !this.AcceptedAmt[i].Equal(&that1.AcceptedAmt[i]) {
			return false
		}
	}
	if this.Status != that1.Status {
		return false
	}
	return true
}
func (this *RequestWithdraw) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestWithdraw)
	if !ok {
		that2, ok := that.(RequestWithdraw)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.PoolId != that1.PoolId {
		return false
	}
	if this.WithdrawAddr != that1.WithdrawAddr {
		return false
	}
	if !this.PoolCoin.Equal(&that1.PoolCoin) {
		return false
	}
	if this.MsgHeight != that1.MsgHeight {
		return false
	}
	if len(this.WithdrawAmt) != len(that1.WithdrawAmt) {
		return false
	}
	for i := range this.WithdrawAmt {
		if !this.WithdrawAmt[i].Equal(&that1.WithdrawAmt[i]) {
			return false
		}
	}
	if this.Status != that1.Status {
		return false
	}
	return true
}
func (this *Order) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Order)
	if !ok {
		that2, ok := that.(Order)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.PairId != that1.PairId {
		return false
	}
	if this.CreatorAddr != that1.CreatorAddr {
		return false
	}
	if this.MsgHeight != that1.MsgHeight {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Direction != that1.Direction {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.BatchId != that1.BatchId {
		return false
	}
	if !this.Offer.Equal(&that1.Offer) {
		return false
	}
	if !this.Remaining.Equal(&that1.Remaining) {
		return false
	}
	if !this.Received.Equal(&that1.Received) {
		return false
	}
	if !this.Price.Equal(that1.Price) {
		return false
	}
	if !this.Amt.Equal(that1.Amt) {
		return false
	}
	if !this.OpenAmt.Equal(that1.OpenAmt) {
		return false
	}
	if !this.Expires.Equal(that1.Expires) {
		return false
	}
	return true
}
func (this *MarketMakingOrderId) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MarketMakingOrderId)
	if !ok {
		that2, ok := that.(MarketMakingOrderId)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PairId != that1.PairId {
		return false
	}
	if this.CreatorAddr != that1.CreatorAddr {
		return false
	}
	if len(this.OrderIds) != len(that1.OrderIds) {
		return false
	}
	for i := range this.OrderIds {
		if this.OrderIds[i] != that1.OrderIds[i] {
			return false
		}
	}
	return true
}
func (m *Pair) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pair) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Pair) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CurrentBatchId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.CurrentBatchId))
		i--
		dAtA[i] = 0x38
	}
	if m.LastPrice != nil {
		{
			size := m.LastPrice.Size()
			i -= size
			if _, err := m.LastPrice.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.LastOrderId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.LastOrderId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.EscrowAddr) > 0 {
		i -= len(m.EscrowAddr)
		copy(dAtA[i:], m.EscrowAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.EscrowAddr)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.QuoteDenom) > 0 {
		i -= len(m.QuoteDenom)
		copy(dAtA[i:], m.QuoteDenom)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.QuoteDenom)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.BaseDenom) > 0 {
		i -= len(m.BaseDenom)
		copy(dAtA[i:], m.BaseDenom)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.BaseDenom)))
		i--
		dAtA[i] = 0x12
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PoolType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PoolType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PoolType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CreatorAddr) > 0 {
		i -= len(m.CreatorAddr)
		copy(dAtA[i:], m.CreatorAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.CreatorAddr)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PoolReserve) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PoolReserve) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PoolReserve) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxSupply != nil {
		{
			size := m.MaxSupply.Size()
			i -= size
			if _, err := m.MaxSupply.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.MinSupply != nil {
		{
			size := m.MinSupply.Size()
			i -= size
			if _, err := m.MinSupply.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Denom) > 0 {
		i -= len(m.Denom)
		copy(dAtA[i:], m.Denom)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.Denom)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Addr) > 0 {
		i -= len(m.Addr)
		copy(dAtA[i:], m.Addr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.Addr)))
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.Supply.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Pool) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pool) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Pool) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PriceRange != nil {
		{
			size, err := m.PriceRange.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Disabled {
		i--
		if m.Disabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.PrevWithdrawReqId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PrevWithdrawReqId))
		i--
		dAtA[i] = 0x40
	}
	if m.PrevDepositReqId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PrevDepositReqId))
		i--
		dAtA[i] = 0x38
	}
	{
		size, err := m.Supply.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x32
	if m.Reserve != nil {
		{
			size, err := m.Reserve.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.CreatorAddr) > 0 {
		i -= len(m.CreatorAddr)
		copy(dAtA[i:], m.CreatorAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.CreatorAddr)))
		i--
		dAtA[i] = 0x22
	}
	if m.TypeId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.TypeId))
		i--
		dAtA[i] = 0x18
	}
	if m.PairId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PairId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PoolState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PoolState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PoolState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PriceRange != nil {
		{
			size, err := m.PriceRange.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Disabled {
		i--
		if m.Disabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.PrevWithdrawReqId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PrevWithdrawReqId))
		i--
		dAtA[i] = 0x18
	}
	if m.PrevDepositReqId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PrevDepositReqId))
		i--
		dAtA[i] = 0x10
	}
	{
		size, err := m.Supply.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *PriceRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PriceRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PriceRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Max != nil {
		{
			size := m.Max.Size()
			i -= size
			if _, err := m.Max.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Min != nil {
		{
			size := m.Min.Size()
			i -= size
			if _, err := m.Min.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintLiquidity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PoolBatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PoolBatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PoolBatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Executed {
		i--
		if m.Executed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.SwapId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.SwapId))
		i--
		dAtA[i] = 0x30
	}
	if m.WithdrawId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.WithdrawId))
		i--
		dAtA[i] = 0x28
	}
	if m.DepositId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.DepositId))
		i--
		dAtA[i] = 0x20
	}
	if m.Height != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x18
	}
	if m.PoolId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PoolId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RequestDeposit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestDeposit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestDeposit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x40
	}
	if len(m.AcceptedAmt) > 0 {
		for iNdEx := len(m.AcceptedAmt) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AcceptedAmt[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLiquidity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.DepositAmt) > 0 {
		for iNdEx := len(m.DepositAmt) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DepositAmt[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLiquidity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.MsgHeight != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.MsgHeight))
		i--
		dAtA[i] = 0x28
	}
	{
		size, err := m.PoolCoin.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.DepositorAddr) > 0 {
		i -= len(m.DepositorAddr)
		copy(dAtA[i:], m.DepositorAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.DepositorAddr)))
		i--
		dAtA[i] = 0x1a
	}
	if m.PoolId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PoolId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RequestWithdraw) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestWithdraw) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestWithdraw) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x38
	}
	if len(m.WithdrawAmt) > 0 {
		for iNdEx := len(m.WithdrawAmt) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.WithdrawAmt[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLiquidity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.MsgHeight != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.MsgHeight))
		i--
		dAtA[i] = 0x28
	}
	{
		size, err := m.PoolCoin.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.WithdrawAddr) > 0 {
		i -= len(m.WithdrawAddr)
		copy(dAtA[i:], m.WithdrawAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.WithdrawAddr)))
		i--
		dAtA[i] = 0x1a
	}
	if m.PoolId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PoolId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Order) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Order) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Order) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	n9, err9 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Expires, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires):])
	if err9 != nil {
		return 0, err9
	}
	i -= n9
	i = encodeVarintLiquidity(dAtA, i, uint64(n9))
	i--
	dAtA[i] = 0x7a
	{
		size := m.OpenAmt.Size()
		i -= size
		if _, err := m.OpenAmt.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x72
	{
		size := m.Amt.Size()
		i -= size
		if _, err := m.Amt.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x6a
	{
		size := m.Price.Size()
		i -= size
		if _, err := m.Price.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x62
	{
		size, err := m.Received.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x5a
	{
		size, err := m.Remaining.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x52
	{
		size, err := m.Offer.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintLiquidity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x4a
	if m.BatchId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.BatchId))
		i--
		dAtA[i] = 0x40
	}
	if m.Status != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x38
	}
	if m.Direction != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Direction))
		i--
		dAtA[i] = 0x30
	}
	if m.Type != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x28
	}
	if m.MsgHeight != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.MsgHeight))
		i--
		dAtA[i] = 0x20
	}
	if len(m.CreatorAddr) > 0 {
		i -= len(m.CreatorAddr)
		copy(dAtA[i:], m.CreatorAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.CreatorAddr)))
		i--
		dAtA[i] = 0x1a
	}
	if m.PairId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PairId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MarketMakingOrderId) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MarketMakingOrderId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MarketMakingOrderId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.OrderIds) > 0 {
		dAtA14 := make([]byte, len(m.OrderIds)*10)
		var j13 int
		for _, num := range m.OrderIds {
			for num >= 1<<7 {
				dAtA14[j13] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j13++
			}
			dAtA14[j13] = uint8(num)
			j13++
		}
		i -= j13
		copy(dAtA[i:], dAtA14[:j13])
		i = encodeVarintLiquidity(dAtA, i, uint64(j13))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CreatorAddr) > 0 {
		i -= len(m.CreatorAddr)
		copy(dAtA[i:], m.CreatorAddr)
		i = encodeVarintLiquidity(dAtA, i, uint64(len(m.CreatorAddr)))
		i--
		dAtA[i] = 0x12
	}
	if m.PairId != 0 {
		i = encodeVarintLiquidity(dAtA, i, uint64(m.PairId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintLiquidity(dAtA []byte, offset int, v uint64) int {
	offset -= sovLiquidity(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Pair) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	l = len(m.BaseDenom)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = len(m.QuoteDenom)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = len(m.EscrowAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.LastOrderId != 0 {
		n += 1 + sovLiquidity(uint64(m.LastOrderId))
	}
	if m.LastPrice != nil {
		l = m.LastPrice.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.CurrentBatchId != 0 {
		n += 1 + sovLiquidity(uint64(m.CurrentBatchId))
	}
	return n
}

func (m *PoolType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = len(m.CreatorAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	return n
}

func (m *PoolReserve) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Supply.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = len(m.Denom)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.MinSupply != nil {
		l = m.MinSupply.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.MaxSupply != nil {
		l = m.MaxSupply.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	return n
}

func (m *Pool) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	if m.PairId != 0 {
		n += 1 + sovLiquidity(uint64(m.PairId))
	}
	if m.TypeId != 0 {
		n += 1 + sovLiquidity(uint64(m.TypeId))
	}
	l = len(m.CreatorAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.Reserve != nil {
		l = m.Reserve.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = m.Supply.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	if m.PrevDepositReqId != 0 {
		n += 1 + sovLiquidity(uint64(m.PrevDepositReqId))
	}
	if m.PrevWithdrawReqId != 0 {
		n += 1 + sovLiquidity(uint64(m.PrevWithdrawReqId))
	}
	if m.Disabled {
		n += 2
	}
	if m.PriceRange != nil {
		l = m.PriceRange.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	return n
}

func (m *PoolState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Supply.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	if m.PrevDepositReqId != 0 {
		n += 1 + sovLiquidity(uint64(m.PrevDepositReqId))
	}
	if m.PrevWithdrawReqId != 0 {
		n += 1 + sovLiquidity(uint64(m.PrevWithdrawReqId))
	}
	if m.Disabled {
		n += 2
	}
	if m.PriceRange != nil {
		l = m.PriceRange.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	return n
}

func (m *PriceRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Min != nil {
		l = m.Min.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.Max != nil {
		l = m.Max.Size()
		n += 1 + l + sovLiquidity(uint64(l))
	}
	return n
}

func (m *PoolBatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	if m.PoolId != 0 {
		n += 1 + sovLiquidity(uint64(m.PoolId))
	}
	if m.Height != 0 {
		n += 1 + sovLiquidity(uint64(m.Height))
	}
	if m.DepositId != 0 {
		n += 1 + sovLiquidity(uint64(m.DepositId))
	}
	if m.WithdrawId != 0 {
		n += 1 + sovLiquidity(uint64(m.WithdrawId))
	}
	if m.SwapId != 0 {
		n += 1 + sovLiquidity(uint64(m.SwapId))
	}
	if m.Executed {
		n += 2
	}
	return n
}

func (m *RequestDeposit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	if m.PoolId != 0 {
		n += 1 + sovLiquidity(uint64(m.PoolId))
	}
	l = len(m.DepositorAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = m.PoolCoin.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	if m.MsgHeight != 0 {
		n += 1 + sovLiquidity(uint64(m.MsgHeight))
	}
	if len(m.DepositAmt) > 0 {
		for _, e := range m.DepositAmt {
			l = e.Size()
			n += 1 + l + sovLiquidity(uint64(l))
		}
	}
	if len(m.AcceptedAmt) > 0 {
		for _, e := range m.AcceptedAmt {
			l = e.Size()
			n += 1 + l + sovLiquidity(uint64(l))
		}
	}
	if m.Status != 0 {
		n += 1 + sovLiquidity(uint64(m.Status))
	}
	return n
}

func (m *RequestWithdraw) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	if m.PoolId != 0 {
		n += 1 + sovLiquidity(uint64(m.PoolId))
	}
	l = len(m.WithdrawAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	l = m.PoolCoin.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	if m.MsgHeight != 0 {
		n += 1 + sovLiquidity(uint64(m.MsgHeight))
	}
	if len(m.WithdrawAmt) > 0 {
		for _, e := range m.WithdrawAmt {
			l = e.Size()
			n += 1 + l + sovLiquidity(uint64(l))
		}
	}
	if m.Status != 0 {
		n += 1 + sovLiquidity(uint64(m.Status))
	}
	return n
}

func (m *Order) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovLiquidity(uint64(m.Id))
	}
	if m.PairId != 0 {
		n += 1 + sovLiquidity(uint64(m.PairId))
	}
	l = len(m.CreatorAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if m.MsgHeight != 0 {
		n += 1 + sovLiquidity(uint64(m.MsgHeight))
	}
	if m.Type != 0 {
		n += 1 + sovLiquidity(uint64(m.Type))
	}
	if m.Direction != 0 {
		n += 1 + sovLiquidity(uint64(m.Direction))
	}
	if m.Status != 0 {
		n += 1 + sovLiquidity(uint64(m.Status))
	}
	if m.BatchId != 0 {
		n += 1 + sovLiquidity(uint64(m.BatchId))
	}
	l = m.Offer.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = m.Remaining.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = m.Received.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = m.Price.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = m.Amt.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = m.OpenAmt.Size()
	n += 1 + l + sovLiquidity(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)
	n += 1 + l + sovLiquidity(uint64(l))
	return n
}

func (m *MarketMakingOrderId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PairId != 0 {
		n += 1 + sovLiquidity(uint64(m.PairId))
	}
	l = len(m.CreatorAddr)
	if l > 0 {
		n += 1 + l + sovLiquidity(uint64(l))
	}
	if len(m.OrderIds) > 0 {
		l = 0
		for _, e := range m.OrderIds {
			l += sovLiquidity(uint64(e))
		}
		n += 1 + sovLiquidity(uint64(l)) + l
	}
	return n
}

func sovLiquidity(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozLiquidity(x uint64) (n int) {
	return sovLiquidity(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Pair) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Pair: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Pair: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseDenom", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseDenom = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuoteDenom", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuoteDenom = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EscrowAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EscrowAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastOrderId", wireType)
			}
			m.LastOrderId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastOrderId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastPrice", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Dec
			m.LastPrice = &v
			if err := m.LastPrice.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentBatchId", wireType)
			}
			m.CurrentBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentBatchId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PoolType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PoolType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PoolType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatorAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatorAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PoolReserve) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PoolReserve: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PoolReserve: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Supply", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Supply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Denom", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Denom = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinSupply", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Int
			m.MinSupply = &v
			if err := m.MinSupply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSupply", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Int
			m.MaxSupply = &v
			if err := m.MaxSupply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Pool) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Pool: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Pool: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PairId", wireType)
			}
			m.PairId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PairId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeId", wireType)
			}
			m.TypeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TypeId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatorAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatorAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reserve", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reserve == nil {
				m.Reserve = &PoolReserve{}
			}
			if err := m.Reserve.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Supply", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Supply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevDepositReqId", wireType)
			}
			m.PrevDepositReqId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrevDepositReqId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevWithdrawReqId", wireType)
			}
			m.PrevWithdrawReqId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrevWithdrawReqId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Disabled = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PriceRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PriceRange == nil {
				m.PriceRange = &PriceRange{}
			}
			if err := m.PriceRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PoolState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PoolState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PoolState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Supply", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Supply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevDepositReqId", wireType)
			}
			m.PrevDepositReqId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrevDepositReqId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevWithdrawReqId", wireType)
			}
			m.PrevWithdrawReqId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrevWithdrawReqId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Disabled = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PriceRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PriceRange == nil {
				m.PriceRange = &PriceRange{}
			}
			if err := m.PriceRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PriceRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PriceRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PriceRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Dec
			m.Min = &v
			if err := m.Min.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Dec
			m.Max = &v
			if err := m.Max.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PoolBatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PoolBatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PoolBatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolId", wireType)
			}
			m.PoolId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PoolId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DepositId", wireType)
			}
			m.DepositId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DepositId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithdrawId", wireType)
			}
			m.WithdrawId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WithdrawId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SwapId", wireType)
			}
			m.SwapId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SwapId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Executed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestDeposit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestDeposit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestDeposit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolId", wireType)
			}
			m.PoolId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PoolId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DepositorAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DepositorAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolCoin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PoolCoin.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgHeight", wireType)
			}
			m.MsgHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MsgHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DepositAmt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DepositAmt = append(m.DepositAmt, types.Coin{})
			if err := m.DepositAmt[len(m.DepositAmt)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptedAmt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AcceptedAmt = append(m.AcceptedAmt, types.Coin{})
			if err := m.AcceptedAmt[len(m.AcceptedAmt)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= RequestStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestWithdraw) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestWithdraw: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestWithdraw: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolId", wireType)
			}
			m.PoolId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PoolId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithdrawAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WithdrawAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolCoin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PoolCoin.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgHeight", wireType)
			}
			m.MsgHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MsgHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithdrawAmt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WithdrawAmt = append(m.WithdrawAmt, types.Coin{})
			if err := m.WithdrawAmt[len(m.WithdrawAmt)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= RequestStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Order) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Order: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Order: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PairId", wireType)
			}
			m.PairId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PairId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatorAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatorAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgHeight", wireType)
			}
			m.MsgHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MsgHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= OrderType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			m.Direction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Direction |= OrderDirection(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= OrderStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchId", wireType)
			}
			m.BatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Offer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remaining", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Remaining.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Received", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Received.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Price", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Price.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amt", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Amt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenAmt", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OpenAmt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Expires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MarketMakingOrderId) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MarketMakingOrderId: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MarketMakingOrderId: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PairId", wireType)
			}
			m.PairId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PairId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatorAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLiquidity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLiquidity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatorAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowLiquidity
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OrderIds = append(m.OrderIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowLiquidity
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthLiquidity
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthLiquidity
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.OrderIds) == 0 {
					m.OrderIds = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowLiquidity
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OrderIds = append(m.OrderIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderIds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLiquidity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLiquidity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLiquidity(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLiquidity
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLiquidity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLiquidity
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupLiquidity
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthLiquidity
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthLiquidity        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLiquidity          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupLiquidity = fmt.Errorf("proto: unexpected end of group")
)
