// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ollo/liquidity/params.proto

package types

import (
	fmt "fmt"
	github_com_cosmos_cosmos_sdk_types "github.com/cosmos/cosmos-sdk/types"
	types "github.com/cosmos/cosmos-sdk/types"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	_ "google.golang.org/protobuf/types/known/durationpb"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Params defines the parameters for the module.
type Params struct {
	PoolParams   *PoolParams   `protobuf:"bytes,1,opt,name=pool_params,json=poolParams,proto3" json:"pool_params,omitempty"`
	OrderParams  *OrderParams  `protobuf:"bytes,2,opt,name=order_params,json=orderParams,proto3" json:"order_params,omitempty"`
	FeeParams    *FeeParams    `protobuf:"bytes,3,opt,name=fee_params,json=feeParams,proto3" json:"fee_params,omitempty"`
	MarketParams *MarketParams `protobuf:"bytes,4,opt,name=market_params,json=marketParams,proto3" json:"market_params,omitempty"`
}

func (m *Params) Reset()      { *m = Params{} }
func (*Params) ProtoMessage() {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_a926018dc9235fe2, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

type OrderParams struct {
	MaxLifespan      time.Duration                          `protobuf:"bytes,1,opt,name=max_lifespan,json=maxLifespan,proto3,stdduration" json:"max_lifespan"`
	DepositExtraGas  github_com_cosmos_cosmos_sdk_types.Gas `protobuf:"varint,2,opt,name=deposit_extra_gas,json=depositExtraGas,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Gas" json:"deposit_extra_gas"`
	WithdrawExtraGas github_com_cosmos_cosmos_sdk_types.Gas `protobuf:"varint,3,opt,name=withdraw_extra_gas,json=withdrawExtraGas,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Gas" json:"withdraw_extra_gas"`
	OrderExtraGas    github_com_cosmos_cosmos_sdk_types.Gas `protobuf:"varint,4,opt,name=order_extra_gas,json=orderExtraGas,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Gas" json:"order_extra_gas"`
}

func (m *OrderParams) Reset()         { *m = OrderParams{} }
func (m *OrderParams) String() string { return proto.CompactTextString(m) }
func (*OrderParams) ProtoMessage()    {}
func (*OrderParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_a926018dc9235fe2, []int{1}
}
func (m *OrderParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrderParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrderParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrderParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderParams.Merge(m, src)
}
func (m *OrderParams) XXX_Size() int {
	return m.Size()
}
func (m *OrderParams) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderParams.DiscardUnknown(m)
}

var xxx_messageInfo_OrderParams proto.InternalMessageInfo

type PoolParams struct {
	MinInitPoolSupply  github_com_cosmos_cosmos_sdk_types.Int `protobuf:"bytes,1,opt,name=min_init_pool_supply,json=minInitPoolSupply,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Int" json:"min_init_pool_supply"`
	MinInitPoolDeposit github_com_cosmos_cosmos_sdk_types.Int `protobuf:"bytes,2,opt,name=min_init_pool_deposit,json=minInitPoolDeposit,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Int" json:"min_init_pool_deposit"`
	MaxPriceRatio      github_com_cosmos_cosmos_sdk_types.Dec `protobuf:"bytes,3,opt,name=max_price_ratio,json=maxPriceRatio,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"max_price_ratio"`
}

func (m *PoolParams) Reset()         { *m = PoolParams{} }
func (m *PoolParams) String() string { return proto.CompactTextString(m) }
func (*PoolParams) ProtoMessage()    {}
func (*PoolParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_a926018dc9235fe2, []int{2}
}
func (m *PoolParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PoolParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PoolParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PoolParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PoolParams.Merge(m, src)
}
func (m *PoolParams) XXX_Size() int {
	return m.Size()
}
func (m *PoolParams) XXX_DiscardUnknown() {
	xxx_messageInfo_PoolParams.DiscardUnknown(m)
}

var xxx_messageInfo_PoolParams proto.InternalMessageInfo

type MarketParams struct {
	Precision   uint32 `protobuf:"varint,1,opt,name=precision,proto3" json:"precision,omitempty"`
	BatchSize   uint32 `protobuf:"varint,2,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	MaxAmmTicks uint32 `protobuf:"varint,3,opt,name=max_amm_ticks,json=maxAmmTicks,proto3" json:"max_amm_ticks,omitempty"`
}

func (m *MarketParams) Reset()         { *m = MarketParams{} }
func (m *MarketParams) String() string { return proto.CompactTextString(m) }
func (*MarketParams) ProtoMessage()    {}
func (*MarketParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_a926018dc9235fe2, []int{3}
}
func (m *MarketParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MarketParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MarketParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MarketParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarketParams.Merge(m, src)
}
func (m *MarketParams) XXX_Size() int {
	return m.Size()
}
func (m *MarketParams) XXX_DiscardUnknown() {
	xxx_messageInfo_MarketParams.DiscardUnknown(m)
}

var xxx_messageInfo_MarketParams proto.InternalMessageInfo

type FeeParams struct {
	FeeCollecterAddr  string                                   `protobuf:"bytes,1,opt,name=fee_collecter_addr,json=feeCollecterAddr,proto3" json:"fee_collecter_addr,omitempty"`
	DustCollectorAddr string                                   `protobuf:"bytes,2,opt,name=dust_collector_addr,json=dustCollectorAddr,proto3" json:"dust_collector_addr,omitempty"`
	SwapRate          *github_com_cosmos_cosmos_sdk_types.Dec  `protobuf:"bytes,3,opt,name=swap_rate,json=swapRate,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"swap_rate,omitempty"`
	WithdrawRate      *github_com_cosmos_cosmos_sdk_types.Dec  `protobuf:"bytes,4,opt,name=withdraw_rate,json=withdrawRate,proto3,customtype=github.com/cosmos/cosmos-sdk/types.Dec" json:"withdraw_rate,omitempty"`
	PairInitFee       github_com_cosmos_cosmos_sdk_types.Coins `protobuf:"bytes,5,rep,name=pair_init_fee,json=pairInitFee,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.Coins" json:"pair_init_fee"`
	PoolInitFee       github_com_cosmos_cosmos_sdk_types.Coins `protobuf:"bytes,6,rep,name=pool_init_fee,json=poolInitFee,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.Coins" json:"pool_init_fee"`
}

func (m *FeeParams) Reset()         { *m = FeeParams{} }
func (m *FeeParams) String() string { return proto.CompactTextString(m) }
func (*FeeParams) ProtoMessage()    {}
func (*FeeParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_a926018dc9235fe2, []int{4}
}
func (m *FeeParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FeeParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FeeParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FeeParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeeParams.Merge(m, src)
}
func (m *FeeParams) XXX_Size() int {
	return m.Size()
}
func (m *FeeParams) XXX_DiscardUnknown() {
	xxx_messageInfo_FeeParams.DiscardUnknown(m)
}

var xxx_messageInfo_FeeParams proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Params)(nil), "ollo.liquidity.Params")
	proto.RegisterType((*OrderParams)(nil), "ollo.liquidity.OrderParams")
	proto.RegisterType((*PoolParams)(nil), "ollo.liquidity.PoolParams")
	proto.RegisterType((*MarketParams)(nil), "ollo.liquidity.MarketParams")
	proto.RegisterType((*FeeParams)(nil), "ollo.liquidity.FeeParams")
}

func init() { proto.RegisterFile("ollo/liquidity/params.proto", fileDescriptor_a926018dc9235fe2) }

var fileDescriptor_a926018dc9235fe2 = []byte{
	// 750 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0x4d, 0x4f, 0x13, 0x5b,
	0x18, 0xee, 0xd7, 0x25, 0xf4, 0xb4, 0x73, 0x81, 0x73, 0xb9, 0xf7, 0xf2, 0xe5, 0x94, 0x74, 0x61,
	0x88, 0xd1, 0xa9, 0xa8, 0x0b, 0xa3, 0x89, 0x09, 0x05, 0x21, 0x24, 0x1a, 0xc8, 0x60, 0x5c, 0x10,
	0x93, 0xc9, 0xe9, 0xcc, 0x69, 0x39, 0x61, 0x66, 0xde, 0x71, 0xce, 0xa9, 0x14, 0x7e, 0x81, 0x4b,
	0x97, 0x2c, 0x5d, 0x1a, 0x7f, 0x09, 0x4b, 0x96, 0xc6, 0x05, 0x28, 0xc4, 0xf8, 0x37, 0xcc, 0xf9,
	0x98, 0xb6, 0xb0, 0xb2, 0x24, 0xae, 0x3a, 0xe7, 0xbc, 0xef, 0xf3, 0x3c, 0xed, 0xf3, 0x3e, 0x6f,
	0x07, 0xcd, 0x43, 0x18, 0x42, 0x23, 0x64, 0x6f, 0xbb, 0x2c, 0x60, 0xe2, 0xb0, 0x91, 0x90, 0x94,
	0x44, 0xdc, 0x49, 0x52, 0x10, 0x80, 0xff, 0x96, 0x45, 0xa7, 0x5f, 0x9c, 0x9b, 0xee, 0x40, 0x07,
	0x54, 0xa9, 0x21, 0x9f, 0x74, 0xd7, 0x9c, 0xdd, 0x01, 0xe8, 0x84, 0xb4, 0xa1, 0x4e, 0xad, 0x6e,
	0xbb, 0x11, 0x74, 0x53, 0x22, 0x18, 0xc4, 0xa6, 0xfe, 0xbf, 0x0f, 0x3c, 0x02, 0xee, 0x69, 0xa0,
	0x0f, 0xcc, 0x14, 0xea, 0xef, 0x0b, 0x68, 0x6c, 0x5b, 0xe9, 0xe1, 0xa7, 0xa8, 0x92, 0x00, 0x84,
	0x9e, 0x96, 0x9f, 0xc9, 0x2f, 0xe6, 0x97, 0x2a, 0x0f, 0xe6, 0x9c, 0xab, 0xfa, 0xce, 0x36, 0x40,
	0xa8, 0x01, 0x2e, 0x4a, 0xfa, 0xcf, 0xf8, 0x19, 0xaa, 0x42, 0x1a, 0xd0, 0x34, 0x43, 0x17, 0x14,
	0x7a, 0xfe, 0x3a, 0x7a, 0x4b, 0xf6, 0x18, 0x78, 0x05, 0x06, 0x07, 0xfc, 0x18, 0xa1, 0x36, 0xa5,
	0x19, 0xba, 0xa8, 0xd0, 0xb3, 0xd7, 0xd1, 0xeb, 0x94, 0x1a, 0x6c, 0xb9, 0x9d, 0x3d, 0xe2, 0x15,
	0x64, 0x45, 0x24, 0xdd, 0xa7, 0x22, 0x03, 0x97, 0x14, 0x78, 0xe1, 0x3a, 0xf8, 0xa5, 0x6a, 0x32,
	0xf8, 0x6a, 0x34, 0x74, 0x7a, 0x52, 0x3a, 0xfe, 0x58, 0xcb, 0xd5, 0x7f, 0x16, 0x50, 0x65, 0xe8,
	0xfb, 0xe1, 0x75, 0x54, 0x8d, 0x48, 0xcf, 0x0b, 0x59, 0x9b, 0xf2, 0x84, 0xc4, 0xc6, 0x90, 0x59,
	0x47, 0x5b, 0xed, 0x64, 0x56, 0x3b, 0x6b, 0xc6, 0xea, 0xe6, 0xf8, 0xc9, 0x59, 0x2d, 0x77, 0x7c,
	0x5e, 0xcb, 0xbb, 0x95, 0x88, 0xf4, 0x5e, 0x18, 0x1c, 0xde, 0x45, 0x53, 0x01, 0x4d, 0x80, 0x33,
	0xe1, 0xd1, 0x9e, 0x48, 0x89, 0xd7, 0x21, 0xda, 0x9f, 0x52, 0xd3, 0x91, 0x88, 0xaf, 0x67, 0xb5,
	0xdb, 0x1d, 0x26, 0xf6, 0xba, 0x2d, 0xc7, 0x87, 0xa8, 0xa1, 0x27, 0x65, 0x3e, 0xee, 0xf1, 0x60,
	0xbf, 0x21, 0x0e, 0x13, 0xca, 0x9d, 0x0d, 0xc2, 0xdd, 0x09, 0x43, 0xf4, 0x5c, 0xf2, 0x6c, 0x10,
	0x8e, 0xdf, 0x20, 0x7c, 0xc0, 0xc4, 0x5e, 0x90, 0x92, 0x83, 0x21, 0xf2, 0xe2, 0x8d, 0xc8, 0x27,
	0x33, 0xa6, 0x3e, 0xfb, 0x6b, 0x34, 0xa1, 0x87, 0x3a, 0xa0, 0x2e, 0xdd, 0x88, 0xda, 0x52, 0x34,
	0x19, 0x6f, 0xfd, 0x53, 0x01, 0xa1, 0x41, 0x8e, 0xb0, 0x87, 0xa6, 0x23, 0x16, 0x7b, 0x2c, 0x66,
	0xc2, 0x53, 0x09, 0xe4, 0xdd, 0x24, 0x09, 0x0f, 0x95, 0xe1, 0xe5, 0x91, 0xb4, 0x36, 0x63, 0xe1,
	0x4e, 0x45, 0x2c, 0xde, 0x8c, 0x99, 0x90, 0x02, 0x3b, 0x8a, 0x08, 0x13, 0xf4, 0xef, 0x55, 0x01,
	0x63, 0xa3, 0x9a, 0xc2, 0xe8, 0x0a, 0x78, 0x48, 0x61, 0x4d, 0x33, 0x49, 0xab, 0x64, 0x58, 0x92,
	0x94, 0xf9, 0xd4, 0x53, 0x79, 0x50, 0x53, 0x18, 0x8d, 0x7c, 0x8d, 0xfa, 0xae, 0x15, 0x91, 0xde,
	0xb6, 0x64, 0x71, 0x25, 0x49, 0x1d, 0x50, 0x75, 0x38, 0xb8, 0x78, 0x01, 0x95, 0x93, 0x94, 0xfa,
	0x8c, 0x33, 0xd0, 0x89, 0xb4, 0xdc, 0xc1, 0x05, 0xbe, 0x85, 0x50, 0x8b, 0x08, 0x7f, 0xcf, 0xe3,
	0xec, 0x88, 0xaa, 0x5f, 0x67, 0xb9, 0x65, 0x75, 0xb3, 0xc3, 0x8e, 0x28, 0xae, 0xcb, 0x55, 0xe9,
	0x79, 0x24, 0x8a, 0x3c, 0xc1, 0xfc, 0x7d, 0x1d, 0x14, 0x4b, 0xa5, 0x75, 0x25, 0x8a, 0x5e, 0xc9,
	0xab, 0xfa, 0x8f, 0x22, 0x2a, 0xf7, 0xf7, 0x0c, 0xdf, 0x45, 0x58, 0xae, 0xa5, 0x0f, 0x61, 0x48,
	0x7d, 0x41, 0x53, 0x8f, 0x04, 0x41, 0xaa, 0x07, 0xe3, 0x4e, 0xb6, 0x29, 0x5d, 0xcd, 0x0a, 0x2b,
	0x41, 0x90, 0x62, 0x07, 0xfd, 0x13, 0x74, 0xb9, 0xc8, 0xda, 0xc1, 0xb4, 0x2b, 0x97, 0xdd, 0x29,
	0x59, 0x5a, 0xcd, 0x2a, 0xaa, 0x7f, 0x03, 0x95, 0xf9, 0x01, 0x49, 0xa4, 0x5f, 0xd4, 0xd8, 0x75,
	0x67, 0x04, 0xab, 0xc6, 0x25, 0xd8, 0x25, 0x82, 0xe2, 0x2d, 0x64, 0xf5, 0xd7, 0x40, 0x91, 0x95,
	0x46, 0x26, 0xab, 0x66, 0x04, 0x8a, 0x10, 0x90, 0x95, 0x10, 0x96, 0xea, 0xc8, 0xb4, 0x29, 0x9d,
	0xf9, 0x6b, 0xb1, 0xa8, 0x96, 0x5f, 0x63, 0x9d, 0x16, 0xe1, 0xd4, 0x79, 0xb7, 0xdc, 0xa2, 0x82,
	0x2c, 0x3b, 0xab, 0xc0, 0xe2, 0xe6, 0x7d, 0x39, 0xe7, 0xcf, 0xe7, 0xb5, 0xa5, 0xdf, 0xd0, 0x93,
	0x00, 0xee, 0x56, 0xa4, 0x82, 0xcc, 0xd1, 0x3a, 0xd5, 0x82, 0x32, 0x99, 0x7d, 0xc1, 0xb1, 0x3f,
	0x21, 0x08, 0x10, 0x1a, 0xc1, 0xe6, 0xa3, 0x93, 0xef, 0x76, 0xee, 0xe4, 0xc2, 0xce, 0x9f, 0x5e,
	0xd8, 0xf9, 0x6f, 0x17, 0x76, 0xfe, 0xc3, 0xa5, 0x9d, 0x3b, 0xbd, 0xb4, 0x73, 0x5f, 0x2e, 0xed,
	0xdc, 0xee, 0x7f, 0xea, 0x95, 0xd4, 0x1b, 0x7a, 0x29, 0x29, 0xa2, 0xd6, 0x98, 0xfa, 0xd7, 0x7b,
	0xf8, 0x2b, 0x00, 0x00, 0xff, 0xff, 0x8a, 0x51, 0xb4, 0x1e, 0xb3, 0x06, 0x00, 0x00,
}

func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MarketParams != nil {
		{
			size, err := m.MarketParams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.FeeParams != nil {
		{
			size, err := m.FeeParams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.OrderParams != nil {
		{
			size, err := m.OrderParams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.PoolParams != nil {
		{
			size, err := m.PoolParams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OrderParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrderParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrderParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.OrderExtraGas != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.OrderExtraGas))
		i--
		dAtA[i] = 0x20
	}
	if m.WithdrawExtraGas != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.WithdrawExtraGas))
		i--
		dAtA[i] = 0x18
	}
	if m.DepositExtraGas != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.DepositExtraGas))
		i--
		dAtA[i] = 0x10
	}
	n5, err5 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.MaxLifespan, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxLifespan):])
	if err5 != nil {
		return 0, err5
	}
	i -= n5
	i = encodeVarintParams(dAtA, i, uint64(n5))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *PoolParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PoolParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PoolParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size := m.MaxPriceRatio.Size()
		i -= size
		if _, err := m.MaxPriceRatio.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size := m.MinInitPoolDeposit.Size()
		i -= size
		if _, err := m.MinInitPoolDeposit.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size := m.MinInitPoolSupply.Size()
		i -= size
		if _, err := m.MinInitPoolSupply.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintParams(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *MarketParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MarketParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MarketParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxAmmTicks != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxAmmTicks))
		i--
		dAtA[i] = 0x18
	}
	if m.BatchSize != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.BatchSize))
		i--
		dAtA[i] = 0x10
	}
	if m.Precision != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.Precision))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *FeeParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FeeParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FeeParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PoolInitFee) > 0 {
		for iNdEx := len(m.PoolInitFee) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PoolInitFee[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintParams(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.PairInitFee) > 0 {
		for iNdEx := len(m.PairInitFee) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PairInitFee[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintParams(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.WithdrawRate != nil {
		{
			size := m.WithdrawRate.Size()
			i -= size
			if _, err := m.WithdrawRate.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.SwapRate != nil {
		{
			size := m.SwapRate.Size()
			i -= size
			if _, err := m.SwapRate.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DustCollectorAddr) > 0 {
		i -= len(m.DustCollectorAddr)
		copy(dAtA[i:], m.DustCollectorAddr)
		i = encodeVarintParams(dAtA, i, uint64(len(m.DustCollectorAddr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.FeeCollecterAddr) > 0 {
		i -= len(m.FeeCollecterAddr)
		copy(dAtA[i:], m.FeeCollecterAddr)
		i = encodeVarintParams(dAtA, i, uint64(len(m.FeeCollecterAddr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintParams(dAtA []byte, offset int, v uint64) int {
	offset -= sovParams(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PoolParams != nil {
		l = m.PoolParams.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.OrderParams != nil {
		l = m.OrderParams.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.FeeParams != nil {
		l = m.FeeParams.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.MarketParams != nil {
		l = m.MarketParams.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	return n
}

func (m *OrderParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxLifespan)
	n += 1 + l + sovParams(uint64(l))
	if m.DepositExtraGas != 0 {
		n += 1 + sovParams(uint64(m.DepositExtraGas))
	}
	if m.WithdrawExtraGas != 0 {
		n += 1 + sovParams(uint64(m.WithdrawExtraGas))
	}
	if m.OrderExtraGas != 0 {
		n += 1 + sovParams(uint64(m.OrderExtraGas))
	}
	return n
}

func (m *PoolParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.MinInitPoolSupply.Size()
	n += 1 + l + sovParams(uint64(l))
	l = m.MinInitPoolDeposit.Size()
	n += 1 + l + sovParams(uint64(l))
	l = m.MaxPriceRatio.Size()
	n += 1 + l + sovParams(uint64(l))
	return n
}

func (m *MarketParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Precision != 0 {
		n += 1 + sovParams(uint64(m.Precision))
	}
	if m.BatchSize != 0 {
		n += 1 + sovParams(uint64(m.BatchSize))
	}
	if m.MaxAmmTicks != 0 {
		n += 1 + sovParams(uint64(m.MaxAmmTicks))
	}
	return n
}

func (m *FeeParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FeeCollecterAddr)
	if l > 0 {
		n += 1 + l + sovParams(uint64(l))
	}
	l = len(m.DustCollectorAddr)
	if l > 0 {
		n += 1 + l + sovParams(uint64(l))
	}
	if m.SwapRate != nil {
		l = m.SwapRate.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.WithdrawRate != nil {
		l = m.WithdrawRate.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if len(m.PairInitFee) > 0 {
		for _, e := range m.PairInitFee {
			l = e.Size()
			n += 1 + l + sovParams(uint64(l))
		}
	}
	if len(m.PoolInitFee) > 0 {
		for _, e := range m.PoolInitFee {
			l = e.Size()
			n += 1 + l + sovParams(uint64(l))
		}
	}
	return n
}

func sovParams(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozParams(x uint64) (n int) {
	return sovParams(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PoolParams == nil {
				m.PoolParams = &PoolParams{}
			}
			if err := m.PoolParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OrderParams == nil {
				m.OrderParams = &OrderParams{}
			}
			if err := m.OrderParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FeeParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FeeParams == nil {
				m.FeeParams = &FeeParams{}
			}
			if err := m.FeeParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MarketParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MarketParams == nil {
				m.MarketParams = &MarketParams{}
			}
			if err := m.MarketParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrderParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrderParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrderParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxLifespan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.MaxLifespan, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DepositExtraGas", wireType)
			}
			m.DepositExtraGas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DepositExtraGas |= github_com_cosmos_cosmos_sdk_types.Gas(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithdrawExtraGas", wireType)
			}
			m.WithdrawExtraGas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WithdrawExtraGas |= github_com_cosmos_cosmos_sdk_types.Gas(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderExtraGas", wireType)
			}
			m.OrderExtraGas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrderExtraGas |= github_com_cosmos_cosmos_sdk_types.Gas(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PoolParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PoolParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PoolParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinInitPoolSupply", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MinInitPoolSupply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinInitPoolDeposit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MinInitPoolDeposit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxPriceRatio", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MaxPriceRatio.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MarketParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MarketParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MarketParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Precision", wireType)
			}
			m.Precision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Precision |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchSize", wireType)
			}
			m.BatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchSize |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAmmTicks", wireType)
			}
			m.MaxAmmTicks = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxAmmTicks |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FeeParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FeeParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FeeParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FeeCollecterAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FeeCollecterAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DustCollectorAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DustCollectorAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SwapRate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Dec
			m.SwapRate = &v
			if err := m.SwapRate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithdrawRate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cosmos_cosmos_sdk_types.Dec
			m.WithdrawRate = &v
			if err := m.WithdrawRate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PairInitFee", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PairInitFee = append(m.PairInitFee, types.Coin{})
			if err := m.PairInitFee[len(m.PairInitFee)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PoolInitFee", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PoolInitFee = append(m.PoolInitFee, types.Coin{})
			if err := m.PoolInitFee[len(m.PoolInitFee)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipParams(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowParams
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthParams
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupParams
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthParams
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthParams        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowParams          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupParams = fmt.Errorf("proto: unexpected end of group")
)
