package simulation

import (
	"math/rand"

	"ollo/x/ons/keeper"
	"ollo/x/ons/types"

	"github.com/cosmos/cosmos-sdk/baseapp"
	sdk "github.com/cosmos/cosmos-sdk/types"
	simtypes "github.com/cosmos/cosmos-sdk/types/simulation"
)

func SimulateMsgDelThread(
	ak types.AccountKeeper,
	bk types.BankKeeper,
	k keeper.Keeper,
) simtypes.Operation {
	return func(r *rand.Rand, app *baseapp.BaseApp, ctx sdk.Context, accs []simtypes.Account, chainID string,
	) (simtypes.OperationMsg, []simtypes.FutureOperation, error) {
		simAccount, _ := simtypes.RandomAcc(r, accs)
		msg := &types.MsgDeleteThread{
			Creator: simAccount.Address.String(),
		}

		// TODO: Handling the DelThread simulation

		return simtypes.NoOpMsg(types.ModuleName, msg.Type(), "DelThread simulation not implemented"), nil, nil
	}
}
