/*
  Queries what SQL Server considers are missing indexes according its performance statistics and generates
  the appropriate clauses.
  Modified from http://www.toadworld.com/platforms/sql-server/w/wiki/10063.find-missing-indexes.aspx.

  Note that one shouldn't blindly add indexes generated by this view.
*/
CREATE VIEW [Core].[SystemMissingIndexes] AS
SELECT
	dm_mid.database_id AS [Database],
	dm_migs.avg_user_impact * (dm_migs.user_seeks+dm_migs.user_scans) EstimatedImpactAvg,
	dm_migs.last_user_seek AS LastUserSeek,
	OBJECT_NAME(dm_mid.object_id,dm_mid.database_id) AS [TableName],
	'CREATE INDEX [IX_' + OBJECT_NAME(dm_mid.object_id,dm_mid.database_id)
	+ '_'
	+ REPLACE(REPLACE(REPLACE(ISNULL(dm_mid.equality_columns,''),', ','_'),'[',''),']','') +
		CASE
			WHEN dm_mid.equality_columns IS NOT NULL AND dm_mid.inequality_columns IS NOT NULL
			THEN '_'
			ELSE ''
		END
	+ REPLACE(REPLACE(REPLACE(ISNULL(dm_mid.inequality_columns,''),', ','_'),'[',''),']','')
	+ ']'
	+ ' ON ' + dm_mid.statement
	+ ' (' + ISNULL (dm_mid.equality_columns,'')
	+ CASE WHEN dm_mid.equality_columns IS NOT NULL AND dm_mid.inequality_columns IS NOT NULL THEN ',' ELSE
	'' END
	+ ISNULL (dm_mid.inequality_columns, '')
	+ ')'
	+ ISNULL (' INCLUDE (' + dm_mid.included_columns + ')', '') AS CreateIndexStatement
FROM sys.dm_db_missing_index_groups dm_mig
	INNER JOIN sys.dm_db_missing_index_group_stats dm_migs ON dm_migs.group_handle = dm_mig.index_group_handle
	INNER JOIN sys.dm_db_missing_index_details dm_mid ON dm_mig.index_handle = dm_mid.index_handle
WHERE dm_mid.database_id LIKE N'OneBoxDeployment.Core%';
