/** @type {import('next').NextConfig} */
const nextConfig = {
  eslint: {
    ignoreDuringBuilds: true,
  },
  experimental: {
    appDir: true,
    serverActions: true,
  },
  webpack: (config) => {
    if (config.name === 'server')
      config.optimization.concatenateModules = false;

    return config;
  },
};

module.exports = nextConfig;
