.\" Author: Tino Reichardt
.TH %PROGNAME% 1 "2017-05-23" "%PROGNAME% %VERSION%"

.SH NAME
%PROGNAME% \- Compress or decompress .%SUFFIX% files

.BR un%PROGNAME% "\ is equivalent to\ " "%PROGNAME% \-d"
.br
.BR %ALGORITHM%cat-mt "\ is equivalent to\ " "%PROGNAME% \-dcf"
.br

.SH SYNOPSIS
.B %PROGNAME%
.RB [ -%LEVELNUMBERS%cdzfhklLqrtvV ]
.RB [ "-S \fIsuffix\fP" ]
.RB [ "\fIfile\fP ..." ]

.SH DESCRIPTION
.B %PROGNAME%
is a multithreaded compression utility for %ALGORITHM% with a command line
syntax similar to gzip or bzip2.
.br
It's based on the zstdmt library version %ZSTDMT% and version %VERSION% of the %ALGORITHM% algorithm.
.br
More information about %ALGORITHM% can be found here: %HOMEPAGE%

.SH OPTIONS
%LEVELNOTES%

.TP
.BI -c
Compressed or uncompressed output is written to the standard output. No files
are modified (force zcat mode).

.TP
.BI -d
Decompress the source files instead of compressing them.

.TP
.BI -z
The complement to -d: forces compression.

.TP
.BI -f
Force compression of file, even if it is not actually reduced in size.
.br
Additionally, files are overwritten without prompting for confirmation.

.TP
.BI -o \ FILE
Use filename `FILE` for output of (de)compression.

.TP
.BI -h
Display a help screen and quit.

.TP
.BI -k
Keep input files after compression or decompression.

.TP
.BI -l
List information for the specified compressed files.

.TP
.BI -L
Display the %PROGNAME% license and quit.

.TP
.BI -q
Be quiet: suppress all messages.

.TP
.BI -S \ suffix
Set the suffix for compressed files. Default: .%SUFFIX%

.TP
.BI -t
Test the integrity of each file leaving any files intact.

.TP
.BI -v
Be more verbose.

.TP
.BI -V
Show version information and quit.

.SH EXTRA OPTIONS

.TP
.BI -T \ N
Set number of compression or decompression threads. Defaults to the
number of cores of the cpu.

.TP
.BI -b \ N
Set input chunksize to N MiB (default: auto).
An overview of the default values is here: https://github.com/mcmilk/zstdmt/tree/master/lib

.TP
.BI -i \ N
Set number of iterations for testing (default: 1).

.TP
.BI -B
Print timings and memory usage to stderr.

.TP
.BI -C
Disable crc32 calculation in verbose listing mode.

.SH EXIT STATUS
The %PROGNAME% utility exits with one of the following values:

.TP 5
.BI 0
Success.

.TP 5
.BI 1
An error occurred.

.TP 5
.BI 2
An warning occurred.

.SH EXAMPLES

.TP 0
.B compress using shell pipe:
cat somefile | %PROGNAME% > somefile.%SUFFIX%
.br
echo "hello *world*" | %PROGNAME% > hello.%SUFFIX%

.TP 0
.B # compress using the -o option:
%PROGNAME% \-o out.%SUFFIX% inputfile
.br
cat source | %PROGNAME% \-o out.%SUFFIX%

.TP 0
.B # compress all files in the current directory with level %LDEF%:
%PROGNAME% \-%LDEF% *

.TP 0
.B # decompress using shell pipe:
cat somefile.%SUFFIX% | %PROGNAME% -d > somefile

.SH BUGS
Please report any bugs to https://github.com/mcmilk/zstdmt/issues

.SH AUTHOR
Tino Reichardt <milky-zstdmt (at) mcmilk.de>

.SH "SEE ALSO"
.BR bzip2 (1),
.BR gzip (1),
.BR lz4 (1),
.BR xz (1),
.BR zstd (1)
