export default {
  // Common
  'common.no_image_to_compress': '未识别到可压缩的图片',
  'common.drag_and_drop': '鼠标松开进行压缩',
  'common.start': '开始',
  'common.stop': '停止',
  'common.compress_completed': '压缩完成',
  'common.compress_failed': '压缩失败',
  'common.compress_failed_msg': '压缩失败，请检查图片文件并重试。',
  // Nav
  'nav.home': '首页',
  'nav.compression': '批量压缩',
  'nav.watch': '监听文件',
  'nav.settings': '设置',
  'nav.update': '发现新版本',
  // Update
  'update.title': '发现新版本',
  'update.version': '版本号 {{version}}',
  'update.changelog': '更新日志',
  'update.button.update': '立即更新',
  'update.message.installed': '新版本安装完成',
  'update.message.failed': '更新失败，请重试',
  'update.button.restart': '安装完成，请重启应用',
  'update.successful': 'v{{version}} 更新完成！',
  // Settings
  'settings.title': '设置',
  'settings.description': '管理应用设置和偏好。',
  'settings.reset_all': '重置',
  'settings.reload': '刷新',
  'settings.reset_all_confirm': '确定重置所有应用设置？',
  // Settings.General
  'settings.general.title': '通用设置',
  'settings.general.description': '管理应用的通用设置和偏好。',
  'settings.general.theme.title': '主题',
  'settings.general.theme.description': '选择应用的主题',
  'settings.general.theme.option.light': '浅色模式',
  'settings.general.theme.option.dark': '深色模式',
  'settings.general.theme.option.system': '跟随系统',
  // Settings.General.Language
  'settings.general.language.title': '语言',
  'settings.general.language.description': '默认使用系统语言',
  // Settings.General.Notification
  'settings.general.notification.title': '系统通知',
  'settings.general.notification.description': `允许应用发送系统通知`,
  'settings.general.notification.got_to_set': '前往系统偏好设置',
  // General.Autostart
  'settings.general.autostart.title': '开机自动启动',
  'settings.general.autostart.description': '开机后自动启动应用',
  // Settings.General.Update
  'settings.general.update.title': '自动检查更新',
  'settings.general.update.description': '当有新版本可用时,自动检查更新并通知',
  // Settings.General.Privacy
  'settings.general.privacy.title': '隐私模式',
  'settings.general.privacy.description': '当隐私模式启用时，应用不会收集任何数据',
  // Settings.Compression
  'settings.compression.title': '压缩设置',
  // Settings.Compression.Concurrency
  'settings.compression.concurrency.title': '并发任务数',
  'settings.compression.concurrency.description': '并发压缩任务数',
  // Settings.Compression.Mode
  'settings.compression.mode.title': '压缩模式',
  'settings.compression.mode.description.auto':
    '优先使用TinyPNG，当TinyPNG服务不可用时，切换为本地压缩重试',
  'settings.compression.mode.description.remote':
    '仅使用TinyPNG压缩，需联网，当TinyPNG服务不可用时压缩失败，适用于非隐私图片',
  'settings.compression.mode.description.local': '仅使用本地压缩，无需联网，适用于隐私图片',
  'settings.compression.mode.option.auto': '自动选择',
  'settings.compression.mode.option.remote': 'TinyPNG',
  'settings.compression.mode.option.local': '本地压缩',
  // Settings.Compression.Type
  'settings.compression.type.title': '压缩类型',
  'settings.compression.type.description.lossless':
    '保留完整图像细节但压缩率较低，仅支持PNG/APNG、WebP、AVIF、TIFF/TIF格式',
  'settings.compression.type.description.lossy':
    '调整部分图像细节来显著减小文件体积，所有格式均支持。',
  'settings.compression.type.option.lossless': '无损压缩',
  'settings.compression.type.option.lossy': '有损压缩',
  // Settings.Compression.Level
  'settings.compression.level.title': '压缩等级',
  'settings.compression.level.description':
    '使用有损压缩时，合理设置压缩等级可达到视觉上的最佳效果。',
  'settings.compression.level.option.1': '微弱',
  'settings.compression.level.option.2': '轻度',
  'settings.compression.level.option.3': '均衡',
  'settings.compression.level.option.4': '高',
  'settings.compression.level.option.5': '极高',
  // Settings.Compression.Metadata
  'settings.compression.metadata.title': '保留元数据',
  'settings.compression.metadata.description': '保留原图的所有元数据（EXIF、ICC、XMP、IPTC）',
  //Settings.Compression.Output
  'settings.compression.output.title': '保存方式',
  'settings.compression.output.description': '图片压缩完成后的保存方式',
  'settings.compression.output.option.overwrite': '替换原文件',
  'settings.compression.output.option.save_as_new_file': '保存为新文件',
  'settings.compression.output.option.save_to_new_folder': '保存到指定文件夹',
  'settings.compression.output.option.save_as_new_file.title': '新文件的名称后缀',
  'settings.compression.output.option.save_as_new_file.description':
    '原文件名是example.jpg，后缀是_compressed，则新文件名为example_compressed.jpg。',
  'settings.compression.output.option.save_to_new_folder.title': '指定文件夹',
  'settings.compression.output.option.save_to_new_folder.description':
    '指定已压缩图片的存放文件夹，默认为系统下载文件夹',
  'settings.compression.output.option.save_to_new_folder.choose': '选择文件夹',
  //Settings.Compression.Threshold
  'settings.compression.threshold.title': '压缩率限制',
  'settings.compression.threshold.description': '当图片压缩率低于设置阈值时，不进行保存',
  // Settings.Compression.Convert
  'settings.compression.convert.enable.title': '格式转换',
  'settings.compression.convert.enable.description': '在压缩完成后，额外将图片转换为指定格式',
  'settings.compression.convert.format.title': '转换格式',
  'settings.compression.convert.format.description': '',
  // Settings.Compression.ConvertAlpha
  'settings.compression.convert_alpha.title': '透明背景填充',
  'settings.compression.convert_alpha.description':
    '当具有透明背景的图像转换为不支持透明通道的图像格式（如WEBP、AVIF、PNG转为JPG）时，指定使用哪种颜色进行填充',
  // Settings.Compression.Resize.Enable
  'settings.compression.resize.enable.title': '尺寸调整',
  'settings.compression.resize.enable.description': '在压缩时启用图片尺寸调整',
  // Settings.Compression.Resize.Dimensions
  'settings.compression.resize.dimensions.title': '尺寸参数',
  'settings.compression.resize.dimensions.description':
    '只配置一边时，另一边将根据内容本身比例自动计算；两边都配置时，则按照配置的尺寸进行缩放或裁剪；当配置尺寸大于原图尺寸时，则保持图像原始比例，不进行调整',
  'settings.compression.resize.dimensions.width': '宽度',
  'settings.compression.resize.dimensions.height': '高度',
  'settings.compression.resize.dimensions.auto': '自动',
  // Settings.Compression.Resize.Fit
  'settings.compression.resize.fit.title': '内容适应',
  'settings.compression.resize.fit.description':
    '调整尺寸时，图片在配置的尺寸大小与内容本身比例不一致时，应如何缩放或裁剪',
  'settings.compression.resize.fit.tooltip.title': '适应方式说明',
  'settings.compression.resize.fit.tooltip.contain':
    '包含: 保持宽高比，缩放图像以完全适应指定尺寸，不裁剪。',
  'settings.compression.resize.fit.tooltip.cover':
    '覆盖: （默认）保持宽高比，尝试通过裁剪/剪切来确保图像覆盖两个提供的尺寸。',
  'settings.compression.resize.fit.tooltip.fill':
    '填充: 不保持宽高比，拉伸图像以填满两个提供的尺寸。',
  'settings.compression.resize.fit.tooltip.inside':
    '内部: 保持宽高比，将图像调整为尽可能大，同时确保其尺寸小于或等于指定的尺寸。',
  'settings.compression.resize.fit.tooltip.outside':
    '外部: 保持宽高比，将图像调整为尽可能小，同时确保其尺寸大于或等于指定的尺寸。',
  // Settings.Compression.Resize.Fit.Option
  'settings.compression.resize.fit.option.contain': '包含（Contain）',
  'settings.compression.resize.fit.option.cover': '覆盖（Cover）',
  'settings.compression.resize.fit.option.fill': '填充（Fill）',
  'settings.compression.resize.fit.option.inside': '内部（Inside）',
  'settings.compression.resize.fit.option.outside': '外部（Outside）',
  // Settings.Compression.FileIgnore
  'settings.compression.file_ignore.title': '忽略文件',
  'settings.compression.file_ignore.description':
    '当监听新增图片时，将会忽略这些文件，多个文件用换行符分隔，支持glob语法',
  // Settings.Compression.Watermark
  'settings.compression.watermark.title': '水印',
  'settings.compression.watermark.description': '压缩后为图片添加文字或图片水印',
  'settings.compression.watermark.option.type': '类型',
  'settings.compression.watermark.option.type.none': '无',
  'settings.compression.watermark.option.type.text': '文字',
  'settings.compression.watermark.option.type.image': '图片',
  // Settings.Compression.Watermark.Position
  'settings.compression.watermark.position.title': '位置',
  'settings.compression.watermark.position.description': '水印在图片中的位置',
  'settings.compression.watermark.option.position.top': '顶部',
  'settings.compression.watermark.option.position.top_right': '顶部右侧',
  'settings.compression.watermark.option.position.top_left': '顶部左侧',
  'settings.compression.watermark.option.position.bottom': '底部',
  'settings.compression.watermark.option.position.bottom_right': '底部右侧',
  'settings.compression.watermark.option.position.bottom_left': '底部左侧',
  'settings.compression.watermark.option.position.left': '左侧',
  'settings.compression.watermark.option.position.right': '右侧',
  'settings.compression.watermark.option.position.center': '中心',
  // Settings.Compression.Watermark.Text
  'settings.compression.watermark.text.title': '文字内容',
  'settings.compression.watermark.text.description': '设置水印文字的内容',
  // Settings.Compression.Watermark.Text.Color
  'settings.compression.watermark.text.color.title': '颜色',
  'settings.compression.watermark.text.color.description': '设置水印文字的颜色',
  // Settings.Compression.Watermark.Text.FontSize
  'settings.compression.watermark.text.font_size.title': '字体大小',
  'settings.compression.watermark.text.font_size.description': '设置水印文字的字体大小',
  // Settings.Compression.Watermark.Image
  'settings.compression.watermark.image.title': '图片',
  'settings.compression.watermark.image.description': '选择作为水印的图片',
  'settings.compression.watermark.image.select_image': '选择图片',
  'settings.compression.watermark.image.not_set': '未设置',
  'settings.compression.watermark.image.file_not_exists': '文件不存在',
  'settings.compression.watermark.image.reset': '重置',
  // Settings.Compression.Watermark.Image.Opacity
  'settings.compression.watermark.image.opacity.title': '透明度',
  'settings.compression.watermark.image.opacity.description':
    '设置水印图片的透明度，值在0-1之间，1为完全不透明，0为完全透明',
  // Settings.Compression.Watermark.Image.Scale
  'settings.compression.watermark.image.scale.title': '缩放',
  'settings.compression.watermark.image.scale.description':
    '设置水印图片的缩放比例，值在0.05-1之间，1为不缩放，保持原图尺寸',
  // Settings.Tinypng
  'settings.tinypng.title': 'TinyPNG',
  // Settings.Tinypng.ApiKeys
  'settings.tinypng.api_keys.title': 'API密钥',
  'settings.tinypng.api_keys.description':
    '<tinypng>TinyPNG</tinypng>是一个流行的第三方在线图像压缩服务。你可以点击<here>这里</here>获取API密钥。',
  'settings.tinypng.api_keys.here': '这里',
  'settings.tinypng.api_keys.form.add_title': '添加API密钥',
  'settings.tinypng.api_keys.form.add_description': '添加一个新的API密钥到系统中。',
  'settings.tinypng.api_keys.form.name': '名称',
  'settings.tinypng.api_keys.form.name_placeholder': '输入名称',
  'settings.tinypng.api_keys.form.api_key': 'API密钥',
  'settings.tinypng.api_keys.form.api_key_placeholder': '输入API密钥',
  'settings.tinypng.api_keys.form.api_already_exists': 'API密钥已存在',
  'settings.tinypng.api_keys.form.name_already_exists': '名称已存在',
  'settings.tinypng.api_keys.form.cancel': '取消',
  'settings.tinypng.api_keys.form.add': '添加',
  'settings.tinypng.api_keys.form.invalid_api_key': '无效的API密钥',
  'settings.tinypng.api_keys.no_api_keys': '没有定义任何API密钥',
  'settings.tinypng.api_keys.table.name': '名称',
  'settings.tinypng.api_keys.table.api_key': 'API密钥',
  'settings.tinypng.api_keys.table.usage': '使用量',
  'settings.tinypng.api_keys.table.status': '状态',
  'settings.tinypng.api_keys.table.created_at': '创建时间',
  'settings.tinypng.api_keys.table.actions': '操作',
  'settings.tinypng.api_keys.table.delete_title': '删除TinyPNG API密钥',
  'settings.tinypng.api_keys.table.err_msg': '错误信息',
  'settings.tinypng.api_keys.table.delete_description': '确定要删除这个密钥吗？',
  // Settings.Tinypng.Metadata
  'settings.tinypng.metadata.title': '保留元数据',
  'settings.tinypng.metadata.description': '选择图片压缩时要保留的元数据',
  'settings.tinypng.metadata.copyright': '版权',
  'settings.tinypng.metadata.creator': '创建者',
  'settings.tinypng.metadata.location': '位置',
  // Settings.About
  'settings.about.title': '关于',
  'settings.about.description': '关于PicSharp',
  // Settings.About.Version
  'settings.about.version.title': '当前版本 V{{version}}',
  'settings.about.version.description':
    'PicSharp 是基于 <license>AGPL-3.0</license> 许可证发布的开源软件。',
  'settings.about.version.check_update': '检查更新',
  'settings.about.version.no_update_available': '当前已是最新版本',
  'settings.about.version.check_update_failed': '检查更新失败，请稍后再试',
  // Settings.About.Feedback
  'settings.about.feedback.title': '反馈',
  'settings.about.feedback.description': '优化建议、Bug反馈、功能需求等',
  // Settings.About.Detail
  'settings.about.detail.title': 'GitHub',
  'settings.about.detail.description': '如果你喜欢PicSharp，请给个⭐️吧～使它让更多人知道🥰',
  // Tray
  'tray.open': '打开',
  'tray.settings': '设置',
  'tray.check_update': '检查更新',
  'tray.quit': '退出',
  // Undo
  'undo.original_file_not_exists': '原始文件不存在',
  'undo.output_file_not_exists': '输出文件不存在',
  'undo.success': '撤销成功',
  'undo.no_allow_undo': '不允许撤销',
  'undo.undone': '已撤销',
  // Menu
  'menu.about': '关于 PicSharp',
  'menu.settings': '设置',
  'menu.check_update': '检查更新',
  'menu.relaunch': '重新启动',
  'menu.minimize': '最小化',
  'menu.maximize': '最大化',
  'menu.fullscreen': '全屏',
  'menu.hide': '隐藏',
  'menu.hide_others': '隐藏其他',
  'menu.show_all': '显示全部',
  'menu.services': '服务',
  'menu.exit': '退出',
  'menu.help': '帮助',
  'menu.report_issue': '问题反馈',
  'menu.star_on_github': '🌟 鼓励一下',
  'menu.edit': '编辑',
  'menu.edit.undo': '撤销',
  'menu.edit.redo': '重做',
  'menu.edit.cut': '剪切',
  'menu.edit.copy': '复制',
  'menu.edit.paste': '粘贴',
  'menu.edit.delete': '删除',
  'menu.edit.select_all': '全选',
  'menu.window': '窗口',
  'menu.view': '视图',
  // Window Controls
  'window.controls.minimize': '最小化',
  'window.controls.maximize': '最大化',
  'window.controls.restore': '还原',
  'window.controls.fullscreen': '全屏',
  'window.controls.exit_fullscreen': '退出全屏',
  'window.controls.always_on_top': '置顶',
  'window.controls.cancel_always_on_top': '取消置顶',
  'window.controls.close': '关闭',
  // Clipboard
  'clipboard.parse_clipboard_images': '正在解析剪贴板图片',
  'clipboard.parse_clipboard_images_error': '解析剪贴板图片失败: {{error}}',
  'clipboard.parse_clipboard_images_no_images': '未找到图片',
  //
  'page.compression.process.actions.save': '保存',
  'page.compression.process.actions.compress': '压缩',
  'compression.file_action.open_file': '查看',
  'compression.file_action.compare_file': '对比原图',
  'compression.file_action.compare_file_title': '图像对比 {{name}}',
  'compression.file_action.reveal_in_finder': '在Finder中显示',
  'compression.file_action.reveal_in_exploer': '在文件资源管理器中显示',
  'compression.file_action.copy': '复制',
  'compression.file_action.copy_path': '路径',
  'compression.file_action.copy_file': '文件',
  'compression.file_action.copy_as_markdown': 'Markdown代码',
  'compression.file_action.copy_as_base64': 'Base64文本',
  'compression.file_action.undo': '撤销',
  'compression.file_action.delete_in_list': '从当前列表中删除',
  'compression.toolbar.info.total_files': '图片数',
  'compression.toolbar.info.files_size': '占用空间',
  'compression.toolbar.info.saved_volume': '节省空间',
  'compression.toolbar.info.saved_volume_rate': '减少',
  'compression.toolbar.info.total_original_size': '压缩前',
  'compression.toolbar.info.total_saved_volume': '压缩后',
  processing: '处理中',
  saving: '保存中',
  compressed: '压缩完成',
  saved: '保存成功',
  failed: '失败',
  please_wait: '请稍等',
  add_success: '添加成功',
  delete_success: '删除成功',
  confirm: '确认',
  cancel: '取消',
  export: '导出',
  export_success: '导出成功',
  export_failed: '导出失败',
  import: '导入',
  import_success: '导入成功',
  import_failed: '导入失败',
  click_to_view: '点击查看',
  valid: '有效',
  invalid: '无效',
  no_data: '无数据',
  current_window: '当前窗口',
  new_window: '新建窗口',
  ns_compress: '图片压缩',
  ns_watch_and_compress: '监控新增图片并自动压缩',
  quit: '退出',
  goToSettings: '前往设置',
  no_config: '未配置',
  beforeCompression: '压缩前',
  afterCompression: '压缩后',
  'error.something_went_wrong': '呀，出错了‼️',
  'error.unexpected_error': '应用运行过程中发生了意外的错误',
  'error.refresh_page': '刷新页面',

  // Toast/Notification massages
  'tips.tinypng_api_keys_not_configured': 'TinyPNG API密钥未配置',
  'tips.save_to_folder_not_configured': '图片保存目录未配置',
  'tips.compressing': '正在压缩... 成功：{{fulfilled}}，失败：{{rejected}}，总任务数：{{total}}',
  'tips.compress_completed': '成功：{{fulfilled}}  失败：{{rejected}}  总任务数：{{total}}',
  'tips.saving': '正在保存... 成功：{{fulfilled}}，失败：{{rejected}}，总任务数：{{total}}',
  'tips.save_completed': '保存完成，成功：{{fulfilled}}，失败：{{rejected}}，总任务数：{{total}}',
  'tips.settings_reset_success': '重置完成',
  'tips.settings_reload_success': '刷新完成',
  'tips.file_path_copied': '文件路径已复制到剪贴板',
  'tips.markdown_code_copied': 'Markdown代码已复制到剪贴板',
  'tips.copying': '正在复制...',
  'tips.copied_success': '已复制到剪贴板',
  'tips.copied_failed': '复制失败',
  'tips.file_copied': '文件已复制到剪贴板',
  'tips.file_copy_failed': '文件复制失败',
  'tips.invalid_paths': '无效的文件路径',
  'tips.file_not_exists': '文件不存在',
  'tips.path_not_exists': '文件路径不存在',
  'tips.watch_and_save_same_folder': '监听目录和图片保存目录相同',
  'tips.error': '错误',
  'tips.warning': '警告',
  'tips.watch_folder_deleted': '监听目录已被删除',
  'tips.watch_folder_moved_or_renamed': '监听目录已被移动或重命名',
  'tips.watching': '监听中...',
  'tips.are_you_sure_to_exit': '是否退出当前页面？',
  'tips.please_wait_for_compression_to_finish': '请等待当前所有任务完成',
  'tips.autostart.error': '开机自启动配置错误',
  'tips.autostart.already_enabled': '开机自启动已开启',
  'tips.autostart.already_disabled': '开机自启动已关闭',
  'tips.file_watch_not_running': '文件监听服务启动失败，请重试或重启应用',
  'tips.file_watch_abort': '文件监听服务已终止',
  'tips.file_watch_target_changed': '监听目录被修改或移动',
  'tips.path_not_dir': '{{path}} 不是目录',
  'tips.import_files': '正在导入文件...',
  'tips.load_image_failed': '加载失败',
  'tips.service_startup_failed': '服务启动失败',
  'tips.watch_service_startup_failed': '文件监听服务启动失败',
  'tips.file_size': '{{bytes}} 字节（磁盘上的{{formatted_disk_size}}）',
  'tips.reload_app': '正在重启应用...',
  'tips.reload_app_failed': '重启应用失败，请稍后再试',
  // 经典模式压缩引导页
  'page.compression.classic.app_title': 'PicSharp',
  'page.compression.classic.app_description': '简单高效的图片压缩工具',
  'page.compression.classic.upload_title': '图像上传',
  'page.compression.classic.upload_description': '粘贴、拖放文件或文件夹到此处',
  'page.compression.classic.upload_file': '选择文件',
  'page.compression.classic.upload_directory': '选择文件夹',
  'page.compression.classic.tinypng_supported_formats': 'TinyPNG支持的图像格式',
  'page.compression.classic.local_supported_formats': '本地压缩支持的图像格式',
  'page.compression.classic.drop_title': '松开鼠标上传图像',
  'page.compression.classic.drop_description': '支持多个文件和文件夹',

  // 监控文件夹压缩引导页
  'page.compression.watch.guide.title': '监控目录新增图片并自动压缩',
  'page.compression.watch.guide.description': '监控目录内新增图片并自动压缩',
  'page.compression.watch.guide.open_folder': '打开文件夹',
  'page.compression.watch.guide.folder': '目录',
  'page.compression.watch.guide.history': '历史',
  'page.compression.watch.guide.attention': '注意事项',
  'page.compression.watch.guide.attention_description':
    '只识别新增（新建、复制、移入）的图片，对于目录中已存在的图片，不会进行压缩。如果图片被替换为目录中已存在且同名的图片，其会被认定为同一张图像，也不会进行压缩。',
  'page.compression.tinify.error.unsupported_file_type':
    'TinyPNG 仅支持 PNG、JPG、JPEG、WebP 和 AVIF 图像',
  // Image Viewer
  'image_viewer.loading': '加载中...',
};
