<?php
namespace ccxt;

// ----------------------------------------------------------------------------

// PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
// https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

// -----------------------------------------------------------------------------

function test_trade($exchange, $trade, $symbol, $now) {
    assert ($trade);
    $sampleTrade = array(
        'info' => array( 'a' => 1, 'b' => 2, 'c' => 3 ),    // the original decoded JSON as is
        'id' => '12345-67890:09876/54321',       // string $trade $id
        'timestamp' => 1502962946216,            // Unix $timestamp in milliseconds
        'datetime' => '2017-08-17 12:42:48.000', // ISO8601 datetime with milliseconds
        'symbol' => 'ETH/BTC',                   // $symbol
        'order' => '12345-67890:09876/54321',    // string order $id or null/None/null
        'type' => 'limit',                       // order type, 'market', 'limit' or null/None/null
        'side' => 'buy',                         // direction of the $trade, 'buy' or 'sell'
        'takerOrMaker' => 'taker',               // string, 'taker' or 'maker'
        'price' => 0.06917684,                   // float price in quote currency
        'amount' => 1.5,                         // amount of base currency
        'cost' => 0.10376526,                    // total cost (including $fees), `price * amount`
    );
    $keys = is_array($sampleTrade) ? array_keys($sampleTrade) : array();
    for ($i = 0; $i < count($keys); $i++) {
        $key = $keys[$i];
        assert (is_array($trade) && array_key_exists($key, $trade));
    }
    $fee = (is_array($trade) && array_key_exists('fee', $trade)) ? $trade['fee'] : null;
    $fees = (is_array($trade) && array_key_exists('fees', $trade)) ? $trade['fees'] : null;
    // logical XOR
    if ($fee || $fees) {
        assert (!($fee && $fees));
    }
    if ($fee) {
        assert ((is_array($fee) && array_key_exists('cost', $fee)) && (is_array($fee) && array_key_exists('currency', $fee)));
    }
    if ($fees) {
        assert (gettype($fees) === 'array' && count(array_filter(array_keys($fees), 'is_string')) == 0);
        for ($i = 0; $i < count($fees); $i++) {
            $fee = $fees[$i];
            assert ((is_array($fee) && array_key_exists('cost', $fee)) && (is_array($fee) && array_key_exists('currency', $fee)));
        }
    }
    $id = $trade['id'];
    assert (($id === null) || (gettype($id) === 'string'));
    $timestamp = $trade['timestamp'];
    assert ((is_float($timestamp) || is_int($timestamp)) || $timestamp === null);
    if ($timestamp) {
        assert ($timestamp > 1230940800000); // 03 Jan 2009 - first block
        assert ($timestamp < 2147483648000); // 19 Jan 2038 - int32 overflows
        $adjustedNow = $now + 60000;
        assert ($timestamp < $adjustedNow, 'trade.timestamp is greater than or equal to current time => $trade => ' . $exchange->iso8601 ($timestamp) . ' $now => ' . $exchange->iso8601 ($now));
    }
    assert ($trade['datetime'] === $exchange->iso8601 ($timestamp));
    assert ($trade['symbol'] === $symbol, 'trade $symbol is not equal to requested $symbol => $trade => ' . $trade['symbol'] . ' requested => ' . $symbol);
    assert ($trade['type'] === null || gettype($trade['type']) === 'string');
    assert ($trade['side'] === null || $trade['side'] === 'buy' || $trade['side'] === 'sell');
    assert ($trade['order'] === null || gettype($trade['order']) === 'string');
    assert ((is_float($trade['price']) || is_int($trade['price'])), 'trade.price is not a number');
    assert ($trade['price'] > 0);
    assert ((is_float($trade['amount']) || is_int($trade['amount'])), 'trade.amount is not a number');
    assert ($trade['amount'] >= 0);
    $takerOrMaker = $trade['takerOrMaker'];
    assert ($takerOrMaker === null || $takerOrMaker === 'taker' || $takerOrMaker === 'maker');
}


