Welcome to the ccxt wiki!

## General Information

- [Supported Exchanges](https://github.com/ccxt/ccxt/wiki/Exchange-Markets)
- [Exchanges By Country](https://github.com/ccxt/ccxt/wiki/Exchange-Markets-By-Country)

## How To Install

- [Install](https://github.com/ccxt/ccxt/wiki/Install)
  - [Node.js](https://github.com/ccxt/ccxt/wiki/Install#nodejs)
  - [Python](https://github.com/ccxt/ccxt/wiki/Install#python)
  - [PHP](https://github.com/ccxt/ccxt/wiki/Install#php)
  - [Web Browsers](https://github.com/ccxt/ccxt/wiki/Install#web-browsers)
  - [Docker](https://github.com/ccxt/ccxt/wiki/Install#docker)
  - [Proxy](https://github.com/ccxt/ccxt/wiki/Install#proxy)
  - [CORS (Access-Control-Allow-Origin)](https://github.com/ccxt/ccxt/wiki/Install#cors-access-control-allow-origin)

## How To Use

- [User Manual](https://github.com/ccxt/ccxt/wiki/Manual)
  - [Architecture Overview](https://github.com/ccxt/ccxt/wiki/Manual#overview)
  - [Instantiation](https://github.com/ccxt/ccxt/wiki/Manual#instantiation)
  - [Exchange Structure](https://github.com/ccxt/ccxt/wiki/Manual#exchange-structure)
  - [Exchange Properties](https://github.com/ccxt/ccxt/wiki/Manual#exchange-properties)
  - [Rate Limit](https://github.com/ccxt/ccxt/wiki/Manual#rate-limit)
  - [Markets](https://github.com/ccxt/ccxt/wiki/Manual#markets)
  - [Symbols And Market Ids](https://github.com/ccxt-dev/ccxt/wiki/Manual#symbols-and-market-ids)
  - [API Methods / Endpoints](https://github.com/ccxt/ccxt/wiki/Manual#api-methods--endpoints)
    - [Implicit API Methods](https://github.com/ccxt/ccxt/wiki/Manual#implicit-api-methods)
    - [Public/Private API](https://github.com/ccxt/ccxt/wiki/Manual#publicprivate-api)
    - [Synchronous vs Asynchronous Calls](https://github.com/ccxt/ccxt/wiki/Manual#synchronous-vs-asynchronous-calls)
    - [Unified API](https://github.com/ccxt/ccxt/wiki/Manual#unified-api)
      - [Overriding Params](https://github.com/ccxt/ccxt/wiki/Manual#overriding-unified-api-params)
      - [Pagination](https://github.com/ccxt/ccxt/wiki/Manual#pagination)
  - [Market Data](https://github.com/ccxt/ccxt/wiki/Manual#market-data)
    - [Order Book](https://github.com/ccxt/ccxt/wiki/Manual#order-book)
      - [Market Depth](https://github.com/ccxt/ccxt/wiki/Manual#market-depth)
    - [Price Tickers](https://github.com/ccxt/ccxt/wiki/Manual#price-tickers)
    - [OHLCV Candlestick Charts](https://github.com/ccxt/ccxt/wiki/Manual#ohlcv-candlestick-charts)
    - [Public Trades](https://github.com/ccxt/ccxt/wiki/Manual#trades-executions-transactions)
  - [Trading](https://github.com/ccxt/ccxt/wiki/Manual#trading)
    - [Authentication](https://github.com/ccxt/ccxt/wiki/Manual#authentication)
    - [API Keys Setup](https://github.com/ccxt/ccxt/wiki/Manual#api-keys-setup)
    - [Querying Account Balance](https://github.com/ccxt/ccxt/wiki/Manual#querying-account-balance)
    - [Orders](https://github.com/ccxt/ccxt/wiki/Manual#orders)
      - [Querying Orders](https://github.com/ccxt/ccxt/wiki/Manual#querying-orders)
        - [`.orders` Cache](https://github.com/ccxt-dev/ccxt/wiki/Manual#orders-cache)
        - [By Order Id](https://github.com/ccxt-dev/ccxt/wiki/Manual#by-order-id)
        - [All Orders](https://github.com/ccxt-dev/ccxt/wiki/Manual#all-orders)
        - [Open Orders](https://github.com/ccxt-dev/ccxt/wiki/Manual#open-orders)
        - [Closed Orders](https://github.com/ccxt-dev/ccxt/wiki/Manual#closed-orders)
      - [Order Structure](https://github.com/ccxt/ccxt/wiki/Manual#order-structure)
      - [Placing Orders](https://github.com/ccxt/ccxt/wiki/Manual#placing-orders)
        - [Market Orders](https://github.com/ccxt/ccxt/wiki/Manual#market-orders)
        - [Limit Orders](https://github.com/ccxt/ccxt/wiki/Manual#limit-orders)
        - [Custom Params](https://github.com/ccxt/ccxt/wiki/Manual#custom-order-params)
      - [Canceling Orders](https://github.com/ccxt/ccxt/wiki/Manual#canceling-orders)
    - [Personal Trades](https://github.com/ccxt-dev/ccxt/wiki/Manual#personal-trades)
    - [Funding Your Account](https://github.com/ccxt/ccxt/wiki/Manual#funding-your-account)
      - [Deposit](https://github.com/ccxt/ccxt/wiki/Manual#deposit)
      - [Withdraw](https://github.com/ccxt/ccxt/wiki/Manual#withdraw)
      - [Transactions](https://github.com/ccxt/ccxt/wiki/Manual#transactions)
        - [Deposits](https://github.com/ccxt/ccxt/wiki/Manual#deposits)
        - [Withdrawals](https://github.com/ccxt/ccxt/wiki/Manual#withdrawals)
        - [All Transactions](https://github.com/ccxt/ccxt/wiki/Manual#all-transactions)
    - [Fees](https://github.com/ccxt/ccxt/wiki/Manual#fees)
      - [Trading Fees](https://github.com/ccxt/ccxt/wiki/Manual#trading-fees)
      - [Funding Fees](https://github.com/ccxt/ccxt/wiki/Manual#funding-fees)

## WebSocket Support

- [CCXT Pro](https://github.com/ccxt/ccxt/wiki/ccxt.pro)

## Troubleshooting

- [Frequently Asked Questions](https://github.com/ccxt/ccxt/wiki/FAQ)
- [Overriding The Nonce](https://github.com/ccxt/ccxt/wiki/Manual#overriding-the-nonce)
- [Error Handling](https://github.com/ccxt/ccxt/wiki/Manual#error-handling)
- [Troubleshooting](https://github.com/ccxt/ccxt/wiki/Manual#troubleshooting)
- [How To Submit An Issue](https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-submit-an-issue)

## Examples

- [Usage Examples](https://github.com/ccxt/ccxt/tree/master/examples) (work in progress)

## New Exchanges

- [Certification](https://github.com/ccxt/ccxt/wiki/Certification)
- [Requirements](https://github.com/ccxt/ccxt/wiki/Requirements)

## API Reference

- API Reference (under construction right now!)
