/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ChooseAccountTypeActivity
extends Activity {
    private static final String TAG = "AccountChooser";
    private HashMap<String, AuthInfo> mTypeToAuthenticatorInfo = new HashMap();
    private ArrayList<AuthInfo> mAuthenticatorInfosToDisplay;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseAccountTypeActivity.onCreate(savedInstanceState=" + savedInstanceState + ")");
        }
        HashSet<String> setOfAllowableAccountTypes = null;
        String[] validAccountTypes = this.getIntent().getStringArrayExtra("allowableAccountTypes");
        if (validAccountTypes != null) {
            setOfAllowableAccountTypes = new HashSet<String>(validAccountTypes.length);
            for (String type : validAccountTypes) {
                setOfAllowableAccountTypes.add(type);
            }
        }
        this.buildTypeToAuthDescriptionMap();
        this.mAuthenticatorInfosToDisplay = new ArrayList(this.mTypeToAuthenticatorInfo.size());
        for (Map.Entry<String, AuthInfo> entry : this.mTypeToAuthenticatorInfo.entrySet()) {
            String type = entry.getKey();
            AuthInfo info = entry.getValue();
            if (setOfAllowableAccountTypes != null && !setOfAllowableAccountTypes.contains(type)) continue;
            this.mAuthenticatorInfosToDisplay.add(info);
        }
        if (this.mAuthenticatorInfosToDisplay.isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putString("errorMessage", "no allowable account types");
            this.setResult(-1, new Intent().putExtras(bundle));
            this.finish();
            return;
        }
        if (this.mAuthenticatorInfosToDisplay.size() == 1) {
            this.setResultAndFinish(this.mAuthenticatorInfosToDisplay.get((int)0).desc.type);
            return;
        }
        this.setContentView(17367094);
        ListView list = (ListView)this.findViewById(16908298);
        list.setAdapter(new AccountArrayAdapter((Context)this, 17367043, this.mAuthenticatorInfosToDisplay));
        list.setChoiceMode(0);
        list.setTextFilterEnabled(false);
        list.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                ChooseAccountTypeActivity.this.setResultAndFinish(((AuthInfo)((ChooseAccountTypeActivity)ChooseAccountTypeActivity.this).mAuthenticatorInfosToDisplay.get((int)position)).desc.type);
            }
        });
    }

    private void setResultAndFinish(String type) {
        Bundle bundle = new Bundle();
        bundle.putString("accountType", type);
        this.setResult(-1, new Intent().putExtras(bundle));
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseAccountTypeActivity.setResultAndFinish: selected account type " + type);
        }
        this.finish();
    }

    private void buildTypeToAuthDescriptionMap() {
        for (AuthenticatorDescription desc : AccountManager.get(this).getAuthenticatorTypes()) {
            Drawable icon;
            String name;
            block6: {
                name = null;
                icon = null;
                try {
                    Context authContext = this.createPackageContext(desc.packageName, 0);
                    icon = authContext.getResources().getDrawable(desc.iconId);
                    CharSequence sequence = authContext.getResources().getText(desc.labelId);
                    if (sequence != null) {
                        name = ((Object)sequence).toString();
                    }
                    name = ((Object)sequence).toString();
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (Log.isLoggable(TAG, 5)) {
                        Log.w(TAG, "No icon name for account type " + desc.type);
                    }
                }
                catch (Resources.NotFoundException e) {
                    if (!Log.isLoggable(TAG, 5)) break block6;
                    Log.w(TAG, "No icon resource for account type " + desc.type);
                }
            }
            AuthInfo authInfo = new AuthInfo(desc, name, icon);
            this.mTypeToAuthenticatorInfo.put(desc.type, authInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccountArrayAdapter
    extends ArrayAdapter<AuthInfo> {
        private LayoutInflater mLayoutInflater;
        private ArrayList<AuthInfo> mInfos;

        public AccountArrayAdapter(Context context, int textViewResourceId, ArrayList<AuthInfo> infos) {
            super(context, textViewResourceId, infos);
            this.mInfos = infos;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(17367093, null);
                holder = new ViewHolder();
                holder.text = (TextView)convertView.findViewById(16908944);
                holder.icon = (ImageView)convertView.findViewById(16908943);
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.text.setText(this.mInfos.get((int)position).name);
            holder.icon.setImageDrawable(this.mInfos.get((int)position).drawable);
            return convertView;
        }
    }

    private static class ViewHolder {
        ImageView icon;
        TextView text;

        private ViewHolder() {
        }
    }

    private static class AuthInfo {
        final AuthenticatorDescription desc;
        final String name;
        final Drawable drawable;

        AuthInfo(AuthenticatorDescription desc, String name, Drawable drawable2) {
            this.desc = desc;
            this.name = name;
            this.drawable = drawable2;
        }
    }
}

