/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.QueuedWork;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import java.io.File;

public class SharedPreferencesBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final String TAG = "SharedPreferencesBackupHelper";
    private static final boolean DEBUG = false;
    private Context mContext;
    private String[] mPrefGroups;

    public SharedPreferencesBackupHelper(Context context, String ... prefGroups) {
        super(context);
        this.mContext = context;
        this.mPrefGroups = prefGroups;
    }

    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        Context context = this.mContext;
        QueuedWork.waitToFinish();
        String[] prefGroups = this.mPrefGroups;
        int N = prefGroups.length;
        String[] files = new String[N];
        for (int i = 0; i < N; ++i) {
            files[i] = context.getSharedPrefsFile(prefGroups[i]).getAbsolutePath();
        }
        SharedPreferencesBackupHelper.performBackup_checked(oldState, data, newState, files, prefGroups);
    }

    public void restoreEntity(BackupDataInputStream data) {
        Context context = this.mContext;
        String key = data.getKey();
        if (this.isKeyInList(key, this.mPrefGroups)) {
            File f = context.getSharedPrefsFile(key).getAbsoluteFile();
            this.writeFile(f, data);
        }
    }
}

