/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.format;

import android.filterfw.core.MutableFrameFormat;
import android.graphics.Bitmap;

public class ImageFormat {
    public static final String COLORSPACE_KEY = "colorspace";
    public static final int COLORSPACE_GRAY = 1;
    public static final int COLORSPACE_RGB = 2;
    public static final int COLORSPACE_RGBA = 3;
    public static final int COLORSPACE_YUV = 4;

    public static MutableFrameFormat create(int width, int height, int colorspace, int bytesPerSample, int target) {
        MutableFrameFormat result = new MutableFrameFormat(2, target);
        result.setDimensions(width, height);
        result.setBytesPerSample(bytesPerSample);
        result.setMetaValue(COLORSPACE_KEY, colorspace);
        if (target == 1) {
            result.setObjectClass(Bitmap.class);
        }
        return result;
    }

    public static MutableFrameFormat create(int width, int height, int colorspace, int target) {
        return ImageFormat.create(width, height, colorspace, ImageFormat.bytesPerSampleForColorspace(colorspace), target);
    }

    public static MutableFrameFormat create(int colorspace, int target) {
        return ImageFormat.create(0, 0, colorspace, ImageFormat.bytesPerSampleForColorspace(colorspace), target);
    }

    public static MutableFrameFormat create(int colorspace) {
        return ImageFormat.create(0, 0, colorspace, ImageFormat.bytesPerSampleForColorspace(colorspace), 0);
    }

    public static int bytesPerSampleForColorspace(int colorspace) {
        switch (colorspace) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
        }
        throw new RuntimeException("Unknown colorspace id " + colorspace + "!");
    }
}

